/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.common.framework.auth.KcTransactionalDocumentAuthorizerBase;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.document.authorization.SubAwardTask;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;

public class SubAwardDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public static final String CAN_MAINTAIN_SUBAWARD_ATTACHMENTS = "CAN_MAINTAIN_SUBAWARD_ATTACHMENTS";
    public static final String CAN_VIEW_SUBAWARD_ATTACHMENTS = "CAN_VIEW_SUBAWARD_ATTACHMENTS";

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        SubAwardDocument subawardDocument = (SubAwardDocument)document;
        if (subawardDocument.getSubAward().getSubAwardId() == null) {
            if (this.canCreateSubAward(user.getPrincipalId())) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteSubAwardTask(userId, subawardDocument, "modifySubaward")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteSubAwardTask(userId, subawardDocument, "viewSubaward")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteSubAwardTask(userId, subawardDocument, "createSubaward")) {
                editModes.add("createSubaward");
            }
        }
        if (editModes.contains("fullEntry") || this.canMaintainSubAwardAttachments(subawardDocument, user)) {
            editModes.add(CAN_MAINTAIN_SUBAWARD_ATTACHMENTS);
        }
        if (editModes.contains(CAN_MAINTAIN_SUBAWARD_ATTACHMENTS) || this.canViewSubAwardAttachments(subawardDocument, user)) {
            editModes.add(CAN_VIEW_SUBAWARD_ATTACHMENTS);
        }
        return editModes;
    }

    protected boolean canMaintainSubAwardAttachments(SubAwardDocument document, Person user) {
        return this.canExecuteSubAwardTask(user.getPrincipalId(), document, "createSubaward");
    }

    protected boolean canViewSubAwardAttachments(SubAwardDocument document, Person user) {
        return this.canExecuteSubAwardTask(user.getPrincipalId(), document, "viewSubaward");
    }

    private boolean canExecuteSubAwardTask(String userId, SubAwardDocument subawardDocument, String taskName) {
        SubAwardTask task = new SubAwardTask(taskName, subawardDocument);
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    private boolean canCreateSubAward(String userId) {
        ApplicationTask task = new ApplicationTask("createSubaward");
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    public boolean canOpen(Document document, Person user) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        if (subAwardDocument.getSubAward().getSubAwardId() == null) {
            return this.canCreateSubAward(user.getPrincipalId());
        }
        return this.canExecuteSubAwardTask(user.getPrincipalId(), (SubAwardDocument)document, "viewSubaward");
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        SubAwardDocument subawardDocument = (SubAwardDocument)document;
        return !this.isFinal(document) && !this.isProcessed(document) && !subawardDocument.isViewOnly() && this.hasPermission(subawardDocument, user, "Submit Subaward Document");
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return !((KcTransactionalDocumentBase)document).isViewOnly() && super.canBlanketApprove(document, user);
    }

    @Override
    protected boolean isFinal(Document document) {
        return "F".equals(document.getDocumentHeader().getWorkflowDocument().getStatus().getCode());
    }

    protected boolean isProcessed(Document document) {
        boolean isProcessed = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if (status.equalsIgnoreCase("P")) {
            isProcessed = true;
        }
        return isProcessed;
    }

    private boolean hasPermission(SubAwardDocument subAwardDocument, Person user, String permissionName) {
        return this.isAuthorized((BusinessObject)subAwardDocument, "KC-SUBAWARD", permissionName, user.getPrincipalId());
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateSubAward(user.getPrincipalId());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteSubAwardTask(user.getPrincipalId(), (SubAwardDocument)document, "modifySubaward");
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRecall(Document document, Person user) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        return subAwardDocument.getDocumentHeader().hasWorkflowDocument() && subAwardDocument.getDocumentHeader().getWorkflowDocument().isEnroute() && this.getKcAuthorizationService().hasPermission(user.getPrincipalId(), subAwardDocument, "Recall Document");
    }

    private KcAuthorizationService getKcAuthorizationService() {
        return KcServiceLocator.getService(KcAuthorizationService.class);
    }
}

