/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.modular;

import java.io.Serializable;
import java.sql.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;

@Entity
@Table(name="BUDGET_MODULAR_IDC")
@IdClass(value=BudgetModularIdcId.class)
public class BudgetModularIdc
extends KcPersistableBusinessObjectBase
implements BudgetModularIdcContract {
    private static final long serialVersionUID = 9162516694202776979L;
    @Id
    @Column(name="BUDGET_PERIOD_NUMBER", insertable=false, updatable=false)
    private Long budgetPeriodId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Id
    @Column(name="RATE_NUMBER")
    private Integer rateNumber;
    @Column(name="BUDGET_ID")
    private Long budgetId;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="IDC_RATE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal idcRate = new ScaleTwoDecimal(0.0);
    @Column(name="IDC_BASE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal idcBase = new ScaleTwoDecimal(0.0);
    @Column(name="IDC_BASE_UNROUNDED")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal idcBaseUnrounded;
    @Column(name="FUNDS_REQUESTED")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal fundsRequested = new ScaleTwoDecimal(0.0);
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="DESCRIPTION", referencedColumnName="RATE_CLASS_CODE", insertable=false, updatable=false)
    private RateClass rateClass;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_PERIOD_NUMBER", referencedColumnName="BUDGET_PERIOD_NUMBER")
    private BudgetModular budgetModular;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScaleTwoDecimal getFundsRequested() {
        return this.fundsRequested;
    }

    public void setFundsRequested(ScaleTwoDecimal fundsRequested) {
        this.fundsRequested = fundsRequested;
    }

    public ScaleTwoDecimal getIdcBase() {
        return this.idcBase;
    }

    public void setIdcBase(ScaleTwoDecimal idcBase) {
        this.idcBase = idcBase;
    }

    public ScaleTwoDecimal getIdcBaseUnrounded() {
        return this.idcBaseUnrounded;
    }

    public void setIdcBaseUnrounded(ScaleTwoDecimal idcBaseUnrounded) {
        this.idcBaseUnrounded = idcBaseUnrounded;
    }

    public ScaleTwoDecimal getIdcRate() {
        return this.idcRate;
    }

    public void setIdcRate(ScaleTwoDecimal idcRate) {
        this.idcRate = idcRate;
    }

    public Integer getRateNumber() {
        return this.rateNumber;
    }

    public void setRateNumber(Integer rateNumber) {
        this.rateNumber = rateNumber;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public void calculateFundsRequested() {
        ScaleTwoDecimal fundsRequested = ScaleTwoDecimal.ZERO;
        if (this.getIdcBase() != null && this.getIdcRate() != null) {
            fundsRequested = (ScaleTwoDecimal)this.getIdcBase().percentage((AbstractDecimal)this.getIdcRate());
        }
        this.setFundsRequested(fundsRequested);
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BudgetModular getBudgetModular() {
        return this.budgetModular;
    }

    public void setBudgetModular(BudgetModular budgetModular) {
        this.budgetModular = budgetModular;
    }

    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public static final class BudgetModularIdcId
    implements Serializable,
    Comparable<BudgetModularIdcId> {
        private Long budgetPeriodId;
        private Integer rateNumber;

        public Long getBudgetPeriodId() {
            return this.budgetPeriodId;
        }

        public void setBudgetPeriodId(Long budgetPeriodId) {
            this.budgetPeriodId = budgetPeriodId;
        }

        public Integer getRateNumber() {
            return this.rateNumber;
        }

        public void setRateNumber(Integer rateNumber) {
            this.rateNumber = rateNumber;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("budgetPeriodId", (Object)this.budgetPeriodId).append("rateNumber", (Object)this.rateNumber).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            BudgetModularIdcId rhs = (BudgetModularIdcId)other;
            return new EqualsBuilder().append((Object)this.budgetPeriodId, (Object)rhs.budgetPeriodId).append((Object)this.rateNumber, (Object)rhs.rateNumber).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.budgetPeriodId).append((Object)this.rateNumber).toHashCode();
        }

        @Override
        public int compareTo(BudgetModularIdcId other) {
            return new CompareToBuilder().append((Object)this.budgetPeriodId, (Object)other.budgetPeriodId).append((Object)this.rateNumber, (Object)other.rateNumber).toComparison();
        }
    }
}

