/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseSalaryStream;
import org.kuali.coeus.common.budget.impl.print.BudgetDataPeriodVO;
import org.kuali.coeus.common.budget.impl.print.SalaryTypeVO;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.printing.schema.BudgetSalaryDocument;
import org.kuali.kra.printing.schema.SalaryType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="budgetSalaryXmlStream")
@Scope(value="prototype")
public class BudgetSalaryXmlStream
extends BudgetBaseSalaryStream {
    private static final String BUDGET_SALARY = "Budget Salary";
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;

    @Override
    public Map<String, BudgetSalaryDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, BudgetSalaryDocument> xmlObjectList = new LinkedHashMap<String, BudgetSalaryDocument>();
        this.budget = (Budget)printableBusinessObject;
        BudgetSalaryDocument budgetSalaryDocument = (BudgetSalaryDocument)BudgetSalaryDocument.Factory.newInstance();
        if (this.budget != null) {
            BudgetSalaryDocument.BudgetSalary budgetSalary = this.getSalaryType();
            budgetSalaryDocument.setBudgetSalary(budgetSalary);
            xmlObjectList.put(BUDGET_SALARY, budgetSalaryDocument);
        }
        return xmlObjectList;
    }

    protected BudgetSalaryDocument.BudgetSalary getSalaryType() {
        ArrayList<SalaryTypeVO> salaryTypeVoList = new ArrayList<SalaryTypeVO>();
        this.getBudgetCalculationService().calculateBudgetSummaryTotals(this.budget);
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : this.budget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            if (!this.isPersonnel(entry.getKey().getCode())) continue;
            for (CostElement costElement : entry.getValue()) {
                this.addSalaryDataForCostElement(costElement, salaryTypeVoList);
            }
        }
        boolean includeNonPersonnel = false;
        this.setSalaryTypesForLineItemCalcuAmount(salaryTypeVoList, includeNonPersonnel);
        List<SalaryType> salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalaryTypeXmlObject();
        budgetSalary.setSalaryArray(salaryTypeList.toArray(new SalaryType[0]));
        return budgetSalary;
    }

    private void addSalaryDataForCostElement(CostElement costElement, List<SalaryTypeVO> salaryTypeVoList) {
        SalaryTypeVO groupVO = new SalaryTypeVO();
        groupVO.setCostElement(costElement.getDescription());
        salaryTypeVoList.add(groupVO);
        for (BudgetPersonnelDetails details : (List)this.budget.getObjectCodePersonnelList().get(costElement)) {
            SalaryTypeVO salaryTypeVoPerPerson = new SalaryTypeVO();
            salaryTypeVoPerPerson.setName(details.getBudgetPerson().getPersonName());
            salaryTypeVoPerPerson.setBudgetPeriodVOs(this.getBudgetPeriodData((List)this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement() + "," + details.getPersonId() + "," + details.getBudgetPerson().getPersonName())));
            salaryTypeVoList.add(salaryTypeVoPerPerson);
        }
        if (this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement()) != null) {
            SalaryTypeVO salaryTypeVoPerPerson = new SalaryTypeVO();
            salaryTypeVoPerPerson.setName("Summary Line Item");
            salaryTypeVoPerPerson.setBudgetPeriodVOs(this.getBudgetPeriodData((List)this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement())));
            salaryTypeVoList.add(salaryTypeVoPerPerson);
        }
    }

    private List<BudgetDataPeriodVO> getBudgetPeriodData(List<ScaleTwoDecimal> costs) {
        ArrayList<BudgetDataPeriodVO> budgetDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodId = 1;
        for (ScaleTwoDecimal cost : costs) {
            BudgetDataPeriodVO periodData = new BudgetDataPeriodVO();
            periodData.setBudgetPeriodId(budgetPeriodId++);
            periodData.setPeriodCost(cost);
            budgetDataList.add(periodData);
        }
        return budgetDataList;
    }

    protected BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

