/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.person;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class KcStateValuesFinder
extends UifKeyValuesFinderBase {
    private static final long serialVersionUID = 3624265421997217342L;
    private StateService stateService;

    public List<KeyValue> getKeyValues(ViewModel model, InputField field) {
        ProposalPerson person = (ProposalPerson)ObjectPropertyUtils.getPropertyValue((Object)model, (String)field.getBindingInfo().getBindByNamePrefix());
        List baseCodes = person == null || StringUtils.isEmpty((CharSequence)person.getCountryCode()) ? this.getStateService().findAllStatesInCountry("US") : this.getStateService().findAllStatesInCountryByAltCode(person.getCountryCode());
        this.clearInternalCache();
        return Stream.concat(Stream.of(new ConcreteKeyValue("", "")), baseCodes.stream().filter(State::isActive).map(state -> new ConcreteKeyValue(state.getCode(), state.getCountryCode() + " - " + this.getName((State)state))).sorted(Comparator.comparing(KeyValue::getValue))).collect(Collectors.toList());
    }

    private String getName(State state) {
        return StringUtils.isNotBlank((CharSequence)state.getNameV3()) ? state.getNameV3() : state.getName();
    }

    protected StateService getStateService() {
        if (this.stateService == null) {
            this.stateService = LocationApiServiceLocator.getStateService();
        }
        return this.stateService;
    }

    public void setStateService(StateService stateService) {
        this.stateService = stateService;
    }
}

