/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.util;

import java.beans.PropertyDescriptor;
import java.util.Collection;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public final class ObjectCopyUtils {
    public static final int MAX_DEPTH_FOR_PROXY_MATERILIZATION = 3;

    public static void prepareObjectForDeepCopy(PersistableBusinessObject bo) {
        try {
            ObjectCopyUtils.materializeAllProxies(bo);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void materializeAllProxies(PersistableBusinessObject bo) {
        ObjectUtils.materializeSubObjectsToDepth((PersistableBusinessObject)bo, (int)3);
        ObjectCopyUtils.materializeUpdateableCollections(bo);
    }

    public static void materializeUpdateableCollections(Object bo) throws FormatException {
        ObjectCopyUtils.materializeUpdateableCollections(bo, 3);
    }

    public static void materializeUpdateableCollections(Object bo, int depth) throws FormatException {
        PropertyDescriptor[] propertyDescriptors;
        if (depth == 0 || ObjectUtils.isNull((Object)bo)) {
            return;
        }
        if (depth < 0 || depth > 3) {
            throw new IllegalArgumentException("The depth passed in was out of bounds.  Only values between 0 and 3, inclusively, are allowed.");
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(bo.getClass())) {
            Collection updateableCollection;
            if (!KNSServiceLocator.getPersistenceStructureService().hasCollection(bo.getClass(), propertyDescriptor.getName()) || !KNSServiceLocator.getPersistenceStructureService().isCollectionUpdatable(bo.getClass(), propertyDescriptor.getName()) || (updateableCollection = (Collection)ObjectUtils.getPropertyValue((Object)bo, (String)propertyDescriptor.getName())) == null || !ProxyHelper.isCollectionProxy((Object)updateableCollection)) continue;
            ObjectUtils.materializeObjects((Collection)updateableCollection);
            for (PersistableBusinessObject elementBo : updateableCollection) {
                ObjectCopyUtils.materializeUpdateableCollections(elementBo, depth - 1);
            }
        }
    }
}

