/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardCommentFactory;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;

class CostSharingDataFeedCommand
extends ProposalDataFeedCommandBase {
    private static final String COST_SHARE_COMMENT_PATTERN = "Added Cost Shares from Proposal Number %s";

    public CostSharingDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    @Override
    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            int costshareCount = 0;
            if (this.mergeType == FundingProposalMergeType.REPLACE) {
                this.award.setAwardCostShares(new ArrayList<AwardCostShare>());
            }
            List<InstitutionalProposalCostShare> costShares = this.proposal.getInstitutionalProposalCostShares();
            for (InstitutionalProposalCostShare ipCostShare : costShares) {
                this.award.add(this.copyCostShare(ipCostShare));
                ++costshareCount;
            }
            if (costshareCount > 0) {
                this.addCostShareComment(this.proposal);
            }
        }
    }

    protected void addCostShareComment(InstitutionalProposal proposal) {
        if (!(this.mergeType != FundingProposalMergeType.NEWAWARD && this.mergeType != FundingProposalMergeType.REPLACE || Objects.isNull(this.proposal.getCostShareComment()) || StringUtils.isEmpty((CharSequence)this.proposal.getCostShareComment().getComments()))) {
            if (this.mergeType == FundingProposalMergeType.REPLACE) {
                this.award.getAwardCostShareComment().setComments("");
            }
            this.award.getAwardCostShareComment().setComments(this.proposal.getCostShareComment().getComments());
        } else {
            String newComment = String.format(COST_SHARE_COMMENT_PATTERN, proposal.getProposalNumber());
            this.appendComments(this.findOrCreateCommentOfSpecifiedType(new AwardCommentFactory().createCostShareComment()), newComment);
        }
    }

    private AwardCostShare copyCostShare(InstitutionalProposalCostShare ipCostShare) {
        AwardCostShare awardCostShare = new AwardCostShare();
        awardCostShare.setCommitmentAmount(ipCostShare.getAmount());
        awardCostShare.setCostSharePercentage(ipCostShare.getCostSharePercentage());
        awardCostShare.setCostShareType(ipCostShare.getCostShareType());
        awardCostShare.setCostShareTypeCode(ipCostShare.getCostShareTypeCode());
        awardCostShare.setSource(ipCostShare.getSourceAccount());
        awardCostShare.setProjectPeriod(ipCostShare.getProjectPeriod());
        awardCostShare.setUnitNumber(ipCostShare.getUnitNumber());
        awardCostShare.setUnit(ipCostShare.getUnit());
        return awardCostShare;
    }
}

