/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalTypeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="proposalTypeService")
public class ProposalTypeServiceImpl
implements ProposalTypeService {
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    @Override
    public String getResubmissionProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_RESUBMISSION");
    }

    @Override
    public String getContinuationProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_CONTINUATION");
    }

    @Override
    public String getRevisionProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_REVISION");
    }

    @Override
    public String getS2SSubmissionChangeCorrectedCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "S2S_SUBMISSION_TYPE_CODE_CHANGE_CORRECTED_APPLICATION");
    }

    @Override
    public String getNewProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_NEW");
    }

    @Override
    public String getRenewProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_RENEWAL");
    }

    @Override
    public boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && (proposalTypeCode.equals(this.getRenewProposalTypeCode()) || proposalTypeCode.equals(this.getRevisionProposalTypeCode()) || proposalTypeCode.equals(this.getContinuationProposalTypeCode()));
    }

    @Override
    public boolean isProposalTypeRevisionOrSupplementChangedOrCorrectedProposalTypeCode(String proposalTypeCode) {
        return !StringUtils.isEmpty((CharSequence)proposalTypeCode) && (proposalTypeCode.equals(this.getRevisionProposalTypeCode()) || proposalTypeCode.equals(this.getSupplementChangedOrCorrectedProposalTypeCode()));
    }

    @Override
    public String getNewChangedOrCorrectedProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_NEW_CHANGE_CORRECTED");
    }

    @Override
    public String getResubmissionChangedOrCorrectedProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_RESUBMISSION_CHANGE_CORRECTED");
    }

    @Override
    public String getBudgetSowUpdateProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_BUDGET_SOW_UPDATE");
    }

    @Override
    public String getRenewalChangedOrCorrectedProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_RENEWAL_CHANGE_CORRECTED");
    }

    @Override
    public String getSupplementChangedOrCorrectedProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_SUPPLEMENT_CHANGE_CORRECTED");
    }

    @Override
    public String getDefaultSubmissionTypeCode(String proposalTypeCode) {
        String defaultS2sSubmissionTypeCode = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.submissiontype.application");
        if (StringUtils.equals((CharSequence)proposalTypeCode, (CharSequence)this.getNewChangedOrCorrectedProposalTypeCode()) || StringUtils.equals((CharSequence)proposalTypeCode, (CharSequence)this.getResubmissionChangedOrCorrectedProposalTypeCode()) || StringUtils.equals((CharSequence)proposalTypeCode, (CharSequence)this.getSupplementChangedOrCorrectedProposalTypeCode()) || StringUtils.equals((CharSequence)proposalTypeCode, (CharSequence)this.getRenewalChangedOrCorrectedProposalTypeCode())) {
            defaultS2sSubmissionTypeCode = this.getParameterService().getParameterValueAsString("KC-PD", "Document", "S2S_SUBMISSION_TYPE_CODE_CHANGE_CORRECTED_APPLICATION");
        } else if (StringUtils.equals((CharSequence)proposalTypeCode, (CharSequence)this.getPreProposalProposalTypeCode())) {
            defaultS2sSubmissionTypeCode = this.getParameterService().getParameterValueAsString("KC-PD", "All", "S2S_SUBMISSION_TYPE_CODE_PREAPPLICATION");
        }
        return defaultS2sSubmissionTypeCode;
    }

    @Override
    public String getPreProposalProposalTypeCode() {
        return this.getParameterService().getParameterValueAsString("KC-PD", "Document", "PROPOSAL_TYPE_CODE_PRE_PROPOSAL");
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

