/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.rest;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.security.PropertySuppressionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component(value="loggingRequestInterceptor")
public class LoggingRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger LOG = LogManager.getLogger(LoggingRequestInterceptor.class);
    @Autowired
    @Qualifier(value="propertySuppressionService")
    private PropertySuppressionService propertySuppressionService;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.traceRequest(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.traceResponse(request, response);
        return response;
    }

    protected void traceRequest(HttpRequest request, byte[] body) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request URI: " + String.valueOf(request.getURI()) + ", Method: " + String.valueOf(request.getMethod()) + ", Headers: " + String.valueOf(this.getPropertySuppressionService().suppressValuesMap((Map)request.getHeaders())) + ", Body Length: " + ArrayUtils.getLength((Object)body));
        }
    }

    protected void traceResponse(HttpRequest request, ClientHttpResponse response) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response Status Code: " + String.valueOf(response.getStatusCode()) + ", Status Text: " + response.getStatusText());
            }
        }
        catch (IOException e) {
            LOG.warn("Error performing debug logging of response", (Throwable)e);
        }
    }

    public PropertySuppressionService getPropertySuppressionService() {
        return this.propertySuppressionService;
    }

    public void setPropertySuppressionService(PropertySuppressionService propertySuppressionService) {
        this.propertySuppressionService = propertySuppressionService;
    }
}

