/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.sql.Date;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.modular.ModularBudgetService;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.api.standalone.BudgetDto;
import org.kuali.coeus.common.budget.api.standalone.CostShareAllocationDto;
import org.kuali.coeus.common.budget.api.standalone.PeriodDto;
import org.kuali.coeus.common.budget.api.standalone.StandaloneBudgetImportService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.distribution.BudgetCostShare;
import org.kuali.coeus.common.budget.framework.distribution.BudgetUnrecoveredFandA;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalFandA;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalBudgetService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class InstitutionalProposalBudgetServiceImpl
implements InstitutionalProposalBudgetService {
    private static final String ACTIVE_VALUE = "Y";
    private static final Integer DEFAULT_COST_SHARE_TYPE_CODE = 1;
    private static final String TRUE_INDICATOR_VALUE = "1";
    private static final String FALSE_INDICATOR_VALUE = "0";
    private ModularBudgetService modularBudgetService;
    private ParameterService parameterService;
    private StandaloneBudgetImportService standaloneBudgetImportService;

    @Override
    public void doBudgetDataFeed(InstitutionalProposal institutionalProposal, DevelopmentProposal developmentProposal) {
        BudgetDto budget;
        Optional<? extends Budget> b = this.findBudget(developmentProposal);
        if (b.isPresent()) {
            Budget budget2 = b.get();
            institutionalProposal.setRequestedStartDateInitial(budget2.getBudgetPeriods().get(0).getStartDate());
            institutionalProposal.setRequestedEndDateInitial(budget2.getBudgetPeriods().get(0).getEndDate());
            if (budget2.getModularBudgetFlag().booleanValue()) {
                ScaleTwoDecimal totalDirect = ScaleTwoDecimal.ZERO;
                ScaleTwoDecimal totalIndirect = ScaleTwoDecimal.ZERO;
                List modularAmounts = this.getModularBudgetService().getModularBudgetAmounts((BudgetContract)budget2);
                for (BudgetPeriod budgetPeriod : budget2.getBudgetPeriods()) {
                    BudgetModularContract modularBudget;
                    if (budgetPeriod == null || (modularBudget = this.getModularBudgetService().getModularBudgetForPeriod(modularAmounts, (BudgetPeriodContract)budgetPeriod)) == null) continue;
                    ScaleTwoDecimal periodTotalIndirect = modularBudget.getBudgetModularIdcs().stream().map(BudgetModularIdcContract::getFundsRequested).reduce(ScaleTwoDecimal.ZERO, AbstractDecimal::add);
                    if (modularBudget.getTotalDirectCost() != null) {
                        totalDirect = (ScaleTwoDecimal)totalDirect.add((AbstractDecimal)modularBudget.getTotalDirectCost());
                        if (budgetPeriod.getBudgetPeriod() == 1) {
                            institutionalProposal.setTotalDirectCostInitial(modularBudget.getTotalDirectCost());
                        }
                    }
                    if (budgetPeriod.getBudgetPeriod() == 1) {
                        institutionalProposal.setTotalIndirectCostInitial(periodTotalIndirect);
                    }
                    totalIndirect = (ScaleTwoDecimal)totalIndirect.add((AbstractDecimal)periodTotalIndirect);
                }
                institutionalProposal.setTotalDirectCostTotal(totalDirect);
                institutionalProposal.setTotalIndirectCostTotal(totalIndirect);
            } else {
                institutionalProposal.setTotalDirectCostInitial(new ScaleTwoDecimal(budget2.getBudgetPeriod(0).getTotalDirectCost().bigDecimalValue()));
                institutionalProposal.setTotalIndirectCostInitial(new ScaleTwoDecimal(budget2.getBudgetPeriod(0).getTotalIndirectCost().bigDecimalValue()));
                institutionalProposal.setTotalDirectCostTotal(new ScaleTwoDecimal(budget2.getTotalDirectCost().bigDecimalValue()));
                institutionalProposal.setTotalIndirectCostTotal(new ScaleTwoDecimal(budget2.getTotalIndirectCost().bigDecimalValue()));
            }
            this.populateCostSharesFromBudget(institutionalProposal, budget2);
            this.populateUnrecoveredFandA(institutionalProposal, budget2);
            this.copyIndirectRates(institutionalProposal, budget2, developmentProposal.getBudgetRateClassCodes());
        } else if (this.getStandaloneBudgetImportService().isEnabled() && (budget = this.getStandaloneBudgetImportService().getFinalBudget(developmentProposal.getProposalNumber())) != null) {
            Optional<PeriodDto> firstPeriod = budget.getPeriods().stream().min(Comparator.comparing(PeriodDto::getNumber));
            firstPeriod.ifPresent(p -> {
                if (p.getStartDate() != null) {
                    institutionalProposal.setRequestedStartDateInitial(new Date(p.getStartDate().getTime()));
                }
                if (p.getEndDate() != null) {
                    institutionalProposal.setRequestedEndDateInitial(new Date(p.getEndDate().getTime()));
                }
                institutionalProposal.setTotalDirectCostInitial((ScaleTwoDecimal)new ScaleTwoDecimal(p.getTotals().getDirectCosts().getTotal().intValue()).divide((AbstractDecimal)ScaleTwoDecimal.ONE_HUNDRED));
                institutionalProposal.setTotalIndirectCostInitial((ScaleTwoDecimal)new ScaleTwoDecimal(p.getTotals().getIndirectCosts().getTotal().intValue()).divide((AbstractDecimal)ScaleTwoDecimal.ONE_HUNDRED));
            });
            if (budget.getTotals().getDirectCosts().getTotal() != null) {
                institutionalProposal.setTotalDirectCostTotal((ScaleTwoDecimal)new ScaleTwoDecimal(budget.getTotals().getDirectCosts().getTotal().intValue()).divide((AbstractDecimal)ScaleTwoDecimal.ONE_HUNDRED));
            }
            if (budget.getTotals().getIndirectCosts().getTotal() != null) {
                institutionalProposal.setTotalIndirectCostTotal((ScaleTwoDecimal)new ScaleTwoDecimal(budget.getTotals().getIndirectCosts().getTotal().intValue()).divide((AbstractDecimal)ScaleTwoDecimal.ONE_HUNDRED));
            }
            institutionalProposal.setBudgetId(budget.getId());
            institutionalProposal.setCoSponsorRatio(new ScaleTwoDecimal(budget.getCoSponsorRatio().doubleValue()));
            institutionalProposal.setCoSponsorTotal(new ScaleTwoDecimal(budget.getTotals().getGrandTotal().getCoSponsor().doubleValue() / 100.0));
            institutionalProposal.setCostShareTotal(new ScaleTwoDecimal(budget.getTotals().getGrandTotal().getCostShare().doubleValue() / 100.0));
            institutionalProposal.setBudgetEndDate(budget.getEndDate());
            institutionalProposal.setBudgetStartDate(budget.getStartDate());
            institutionalProposal.setHpcCoreHours(new ScaleTwoDecimal(budget.getHpcCode().getStats().getQuantity().getCoSponsor().doubleValue()));
            this.populateCostSharesFromBudget(institutionalProposal, budget);
        }
    }

    private void populateCostSharesFromBudget(InstitutionalProposal institutionalProposal, BudgetDto budget) {
        institutionalProposal.getInstitutionalProposalCostShares().clear();
        budget.getPeriods().stream().filter(Objects::nonNull).forEach(period -> period.getCostShareAllocations().stream().filter(Objects::nonNull).forEach(budgetCostShare -> {
            InstitutionalProposalCostShare ipCostShare = new InstitutionalProposalCostShare();
            if (NumberUtils.isParsable((String)budgetCostShare.getCode())) {
                ipCostShare.setCostShareTypeCode(Integer.valueOf(budgetCostShare.getCode()));
            }
            if (budgetCostShare.getTotal() != null) {
                ipCostShare.setAmount(new ScaleTwoDecimal(budgetCostShare.getTotal().intValue()));
            }
            ipCostShare.setCostSharePercentage(this.calculateCostSharePercentage((CostShareAllocationDto)budgetCostShare, (PeriodDto)period));
            ipCostShare.setProjectPeriod(period.getNumber().toString());
            ipCostShare.setSourceAccount(budgetCostShare.getSourceAccount());
            ipCostShare.setUnitNumber(budgetCostShare.getUnit().getId());
            institutionalProposal.add(ipCostShare);
        }));
        if (!institutionalProposal.getInstitutionalProposalCostShares().isEmpty()) {
            institutionalProposal.setCostSharingIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setCostSharingIndicator(FALSE_INDICATOR_VALUE);
        }
    }

    private ScaleTwoDecimal calculateCostSharePercentage(CostShareAllocationDto budgetCostShare, PeriodDto period) {
        double costShareAllocation = budgetCostShare.getTotal() == null ? 0.0 : (double)budgetCostShare.getTotal().intValue();
        double costShareTotal = period.getTotals().getGrandTotal().getCostShare().intValue();
        return costShareAllocation == 0.0 ? ScaleTwoDecimal.ZERO : (ScaleTwoDecimal)new ScaleTwoDecimal(costShareAllocation / costShareTotal).multiply((AbstractDecimal)ScaleTwoDecimal.ONE_HUNDRED);
    }

    private void populateUnrecoveredFandA(InstitutionalProposal institutionalProposal, Budget budget) {
        institutionalProposal.getInstitutionalProposalUnrecoveredFandAs().clear();
        for (BudgetUnrecoveredFandA budgetUfa : budget.getBudgetUnrecoveredFandAs()) {
            InstitutionalProposalUnrecoveredFandA ipUfa = new InstitutionalProposalUnrecoveredFandA();
            ipUfa.setApplicableIndirectcostRate(new ScaleTwoDecimal(budgetUfa.getApplicableRate().bigDecimalValue()));
            ipUfa.setFiscalYear(budgetUfa.getFiscalYear().toString());
            ipUfa.setOnCampusFlag(ACTIVE_VALUE.equals(budgetUfa.getOnCampusFlag()));
            ipUfa.setSourceAccount(budgetUfa.getSourceAccount());
            ipUfa.setIndirectcostRateTypeCode(Integer.parseInt(budget.getOhRateClassCode()));
            ipUfa.setUnderrecoveryOfIndirectcost(new ScaleTwoDecimal(budgetUfa.getAmount().bigDecimalValue()));
            institutionalProposal.add(ipUfa);
        }
        if (!institutionalProposal.getInstitutionalProposalUnrecoveredFandAs().isEmpty()) {
            institutionalProposal.setIdcRateIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setIdcRateIndicator(FALSE_INDICATOR_VALUE);
        }
    }

    private void populateCostSharesFromBudget(InstitutionalProposal institutionalProposal, Budget budget) {
        institutionalProposal.getInstitutionalProposalCostShares().clear();
        for (BudgetCostShare budgetCostShare : budget.getBudgetCostShares()) {
            InstitutionalProposalCostShare ipCostShare = new InstitutionalProposalCostShare();
            ipCostShare.setCostShareTypeCode(this.getCostShareTypeCode(budgetCostShare));
            if (this.isCostShareTypeEnabled()) {
                ProposalDevelopmentBudgetExt budgetExt = (ProposalDevelopmentBudgetExt)budgetCostShare.getBudget();
                institutionalProposal.getCostShareComment().setComments(budgetExt.getCostShareComment());
            }
            ipCostShare.setAmount(new ScaleTwoDecimal(budgetCostShare.getShareAmount().bigDecimalValue()));
            ipCostShare.setCostSharePercentage(new ScaleTwoDecimal(budgetCostShare.getSharePercentage().bigDecimalValue()));
            ipCostShare.setProjectPeriod(budgetCostShare.getProjectPeriod().toString());
            ipCostShare.setSourceAccount(budgetCostShare.getSourceAccount());
            ipCostShare.setUnitNumber(budgetCostShare.getUnitNumber());
            ipCostShare.setUnit(budgetCostShare.getUnit());
            institutionalProposal.add(ipCostShare);
        }
        if (!institutionalProposal.getInstitutionalProposalCostShares().isEmpty()) {
            institutionalProposal.setCostSharingIndicator(TRUE_INDICATOR_VALUE);
        } else {
            institutionalProposal.setCostSharingIndicator(FALSE_INDICATOR_VALUE);
        }
    }

    protected Integer getCostShareTypeCode(BudgetCostShare budgetCostShare) {
        if (this.isCostShareTypeEnabled()) {
            return budgetCostShare.getCostShareTypeCode() == null ? this.getCostShareTypeDefault() : budgetCostShare.getCostShareTypeCode();
        }
        return DEFAULT_COST_SHARE_TYPE_CODE;
    }

    protected void copyIndirectRates(InstitutionalProposal institutionalProposal, Budget budget, Set<String> budgetRateClassCodes) {
        institutionalProposal.getInstitutionalProposalFandAs().clear();
        if (this.isLifecyleRatesFlowthruEnabled() && budget.getBudgetRates() != null) {
            budget.getBudgetRates().stream().filter(budgetRate -> budgetRate.getRateClass().getRateClassTypeCode().equalsIgnoreCase(RateClassType.OVERHEAD.getRateClassType()) && budgetRateClassCodes.contains(budgetRate.getRateClassCode())).forEach(budgetRate -> {
                InstitutionalProposalFandA fandA = new InstitutionalProposalFandA();
                fandA.setRateTypeCode(budgetRate.getRateTypeCode());
                fandA.setRateClassCode(budgetRate.getRateClassCode());
                fandA.setActivityTypeCode(budgetRate.getActivityTypeCode());
                fandA.setFiscalYear(budgetRate.getFiscalYear());
                fandA.setApplicableRate(budgetRate.getApplicableRate());
                fandA.setInstituteRate(budgetRate.getInstituteRate());
                fandA.setOnOffCampusFlag(budgetRate.getOnOffCampusFlag());
                fandA.setStartDate(budgetRate.getStartDate());
                institutionalProposal.add(fandA);
            });
        }
    }

    protected boolean isLifecyleRatesFlowthruEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IP", "All", "Enable_Lifecycle_Rates_Flowthru");
    }

    protected boolean isCostShareTypeEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ENABLE_COST_SHARE_ACCOUNT_VALIDATION");
    }

    protected Integer getCostShareTypeDefault() {
        String costSharetype = this.getParameterService().getParameterValueAsString("KC-IP", "All", "Default_IP_Award_Cost_Share_Type");
        return !StringUtils.isEmpty((CharSequence)costSharetype) ? Integer.valueOf(Integer.parseInt(costSharetype)) : null;
    }

    private Optional<? extends Budget> findBudget(DevelopmentProposal developmentProposal) {
        return Optional.ofNullable(developmentProposal.getFinalBudget());
    }

    public ModularBudgetService getModularBudgetService() {
        return this.modularBudgetService;
    }

    public void setModularBudgetService(ModularBudgetService modularBudgetService) {
        this.modularBudgetService = modularBudgetService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public StandaloneBudgetImportService getStandaloneBudgetImportService() {
        return this.standaloneBudgetImportService;
    }

    public void setStandaloneBudgetImportService(StandaloneBudgetImportService standaloneBudgetImportService) {
        this.standaloneBudgetImportService = standaloneBudgetImportService;
    }
}

