/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.nonpersonnel;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.AwardBudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.ApplyToPeriodsBudgetEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.SaveBudgetLineItemEvent;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.impl.nonpersonnel.AddFormulatedCostBudgetEvent;
import org.kuali.coeus.common.budget.impl.nonpersonnel.BudgetExpensesRuleEvent;
import org.kuali.coeus.common.budget.impl.nonpersonnel.DeleteBudgetLineItemEvent;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcEventMethod;
import org.kuali.coeus.common.framework.ruleengine.KcEventResult;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@KcBusinessRule(value="budgetExpenseRule")
public class BudgetExpenseRule {
    private static final double MAX_BUDGET_DECIMAL_VALUE = 9.999999999E9;
    private static final String PERSONNEL_CATEGORY = "P";
    protected static final String BUDGET_NON_PERSONNEL_COST_DETAILS_ID = "PropBudget-NonPersonnelCosts-LineItemDetails";
    protected static final String BUDGET_PERSONNEL_COST_DETAILS_ID = "PropBudget-AssignPersonnelToPeriodsPage-PersonnelDetails";
    public static final String COST_ELEMENT = ".costElement";
    public static final String END_DATE = ".endDate";
    public static final String START_DATE = ".startDate";
    public static final String UNIT_COST = ".unitCost";
    public static final String CALCULATED_EXPENSES = ".calculatedExpenses";
    public static final String CAN_NOT_BE_AFTER = "can not be after";
    public static final String CAN_NOT_BE_BEFORE = "can not be before";
    public static final String LOWER_END_DATE = "end date";
    public static final String LOWER_START_DATE = "start date";
    public static final String UPPER_START_DATE = "Start Date";
    public static final String UPPER_END_DATE = "End Date";
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @KcEventMethod
    public boolean processCheckExistBudgetPersonnelDetailsBusinessRules(DeleteBudgetLineItemEvent event) {
        boolean valid = true;
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        if (CollectionUtils.isNotEmpty(event.getBudgetLineItem().getBudgetPersonnelDetailsList())) {
            errorMap.putError(event.getErrorPath() + COST_ELEMENT, "error.delete.lineitem", new String[0]);
            valid = false;
        }
        return valid;
    }

    @KcEventMethod
    public boolean processApplyToLaterPeriodsWithPersonnelDetails(ApplyToPeriodsBudgetEvent event) {
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        Budget budget = event.getBudget();
        BudgetLineItem budgetLineItem = event.getBudgetLineItem();
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        BudgetLineItem prevBudgetLineItem = budgetLineItem;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() <= event.getBudgetPeriod().getBudgetPeriod()) continue;
            QueryList<BudgetLineItem> currentBudgetPeriodLineItems = new QueryList<BudgetLineItem>(budgetPeriod.getBudgetLineItems());
            for (BudgetLineItem budgetLineItemToBeApplied : currentBudgetPeriodLineItems) {
                if (prevBudgetLineItem.getLineItemNumber().equals(budgetLineItemToBeApplied.getBasedOnLineItem())) {
                    if (!budgetLineItemToBeApplied.getBudgetCategory().getBudgetCategoryTypeCode().equals(PERSONNEL_CATEGORY) || budgetLineItemToBeApplied.getBudgetPersonnelDetailsList().isEmpty() && prevBudgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                    errorMap.putError(event.getErrorPath() + COST_ELEMENT, "error.applyTo.later.periods", new String[]{budgetLineItemToBeApplied.getBudgetPeriod().toString()});
                    return false;
                }
                if (!StringUtils.equals((CharSequence)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)PERSONNEL_CATEGORY) || !StringUtils.equals((CharSequence)budgetLineItem.getCostElement(), (CharSequence)budgetLineItemToBeApplied.getCostElement()) || !StringUtils.equals((CharSequence)budgetLineItem.getGroupName(), (CharSequence)budgetLineItemToBeApplied.getGroupName())) continue;
                errorMap.putError(event.getErrorPath() + COST_ELEMENT, "error.personnelLineItem.applyTo.later.periods", new String[]{budgetLineItemToBeApplied.getBudgetPeriod().toString()});
                return false;
            }
        }
        return true;
    }

    @KcEventMethod
    public boolean processCheckLineItemDates(AwardBudgetSaveEvent event) {
        boolean valid = true;
        List<BudgetPeriod> budgetPeriods = event.getBudget().getBudgetPeriods();
        int numLineItems = 0;
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.isReadOnly()) continue;
            numLineItems = budgetPeriod.getBudgetLineItems().size();
            for (int i = 0; i < numLineItems; ++i) {
                valid &= this.processCheckLineItemDates(budgetPeriod, budgetPeriod.getBudgetLineItem(i), "document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + i + "]");
            }
        }
        return valid;
    }

    @KcEventMethod
    public boolean processCheckLineItemDates(ApplyToPeriodsBudgetEvent event) {
        return this.processCheckLineItemDates(event.getBudgetPeriod(), event.getBudgetLineItem(), event.getErrorPath());
    }

    @KcEventMethod
    public boolean processCheckLineItemDates(SaveBudgetLineItemEvent event) {
        return this.processCheckLineItemDates(event.getBudgetPeriod(), event.getBudgetLineItem(), event.getErrorPath());
    }

    protected boolean processCheckLineItemDates(BudgetPeriod currentBudgetPeriod, BudgetLineItem budgetLineItem, String errorPath) {
        boolean valid = true;
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        if (budgetLineItem.getEndDate() == null) {
            errorMap.putError(errorPath + END_DATE, "error.required", new String[]{UPPER_END_DATE});
            valid = false;
        }
        if (budgetLineItem.getStartDate() == null) {
            errorMap.putError(errorPath + START_DATE, "error.required", new String[]{UPPER_START_DATE});
            valid = false;
        }
        if (!valid) {
            return valid;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetLineItem.getStartDate()) < 0) {
            errorMap.putError(errorPath + END_DATE, "error.line.item.dates", new String[0]);
            valid = false;
        }
        if (currentBudgetPeriod.getEndDate().compareTo(budgetLineItem.getEndDate()) < 0) {
            errorMap.putError(errorPath + END_DATE, "error.line.item.end.date", new String[]{CAN_NOT_BE_AFTER, LOWER_END_DATE});
            valid = false;
        }
        if (currentBudgetPeriod.getStartDate().compareTo(budgetLineItem.getEndDate()) > 0) {
            errorMap.putError(errorPath + END_DATE, "error.line.item.end.date", new String[]{CAN_NOT_BE_BEFORE, LOWER_START_DATE});
            valid = false;
        }
        if (currentBudgetPeriod.getStartDate().compareTo(budgetLineItem.getStartDate()) > 0) {
            errorMap.putError(errorPath + START_DATE, "error.line.item.start.date", new String[]{CAN_NOT_BE_BEFORE, LOWER_START_DATE});
            valid = false;
        }
        if (currentBudgetPeriod.getEndDate().compareTo(budgetLineItem.getStartDate()) < 0) {
            errorMap.putError(errorPath + START_DATE, "error.line.item.start.date", new String[]{CAN_NOT_BE_AFTER, LOWER_END_DATE});
            valid = false;
        }
        return valid;
    }

    @KcEventMethod
    public boolean processBudgetFormulatedCostValidations(AddFormulatedCostBudgetEvent event) {
        return this.processBudgetFormulatedCostValidations(event.getFormulatedCostDetail(), event.getErrorPath());
    }

    @KcEventMethod
    public boolean processBudgetFormulatedCostValidations(BudgetSaveEvent event) {
        boolean result = true;
        int budgetPeriodIdx = 0;
        for (BudgetPeriod budgetPeriod : event.getBudget().getBudgetPeriods()) {
            int lineItemIdx = 0;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String errorPath = "document.budget.budgetPeriod[" + budgetPeriodIdx + "].budgetLineItem[" + lineItemIdx + "].";
                int formulatedCostIdx = 0;
                for (BudgetFormulatedCostDetail budgetFormulatedCost : budgetLineItem.getBudgetFormulatedCosts()) {
                    result &= this.processBudgetFormulatedCostValidations(budgetFormulatedCost, errorPath + "budgetFormulatedCosts[" + formulatedCostIdx++ + "]");
                }
                ++lineItemIdx;
            }
            ++budgetPeriodIdx;
        }
        return result;
    }

    protected boolean processBudgetFormulatedCostValidations(BudgetFormulatedCostDetail budgetFormulatedCost, String errorKey) {
        boolean valid = true;
        MessageMap errorMap = this.getGlobalVariableService().getMessageMap();
        BigDecimal unitCost = budgetFormulatedCost.getUnitCost().bigDecimalValue();
        BigDecimal count = new ScaleTwoDecimal(budgetFormulatedCost.getCount().intValue()).bigDecimalValue();
        BigDecimal frequency = new ScaleTwoDecimal(budgetFormulatedCost.getFrequency().intValue()).bigDecimalValue();
        BigDecimal calculatedExpense = unitCost.multiply(count).multiply(frequency);
        if (new ScaleTwoDecimal(unitCost).isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(9.999999999E9))) {
            valid = false;
            errorMap.putError(errorKey + UNIT_COST, "error.invalid.budget.formulated.unit.cost", new String[0]);
        }
        if (new ScaleTwoDecimal(calculatedExpense).isGreaterThan((AbstractDecimal)new ScaleTwoDecimal(9.999999999E9))) {
            valid = false;
            errorMap.putError(errorKey + CALCULATED_EXPENSES, "error.invalid.budget.formulated.calculated.expense", new String[0]);
        }
        return valid;
    }

    @KcEventMethod
    public KcEventResult processBudgetLineItemExpenseRules(BudgetExpensesRuleEvent event) {
        KcEventResult result = new KcEventResult();
        Budget budget = event.getBudget();
        if (budget.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budget.getTotalCost().isGreaterThan((AbstractDecimal)budget.getTotalCostLimit())) {
            result.getMessageMap().putWarning(event.getErrorPath(), "warning.budgetCostLimit.exceeded", new String[0]);
        }
        if (budget.getTotalDirectCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budget.getTotalDirectCost().isGreaterThan((AbstractDecimal)budget.getTotalDirectCostLimit())) {
            result.getMessageMap().putWarning(event.getErrorPath(), "warning.budgetDirectCostLimit.exceeded", new String[0]);
        }
        String errorPath = BUDGET_PERSONNEL_COST_DETAILS_ID;
        if (event.getErrorPath().equalsIgnoreCase(BudgetConstants.BudgetAuditRules.NON_PERSONNEL_COSTS.getPageId())) {
            errorPath = BUDGET_NON_PERSONNEL_COST_DETAILS_ID;
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getTotalCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) && budgetPeriod.getTotalCost().isGreaterThan((AbstractDecimal)budgetPeriod.getTotalCostLimit())) {
                result.getMessageMap().putWarning(errorPath + "_" + budgetPeriod.getBudgetPeriod(), "warning.periodCostLimit.exceeded", new String[]{budgetPeriod.getBudgetPeriod().toString()});
            }
            if (!budgetPeriod.getDirectCostLimit().isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO) || !budgetPeriod.getTotalDirectCostForSync().isGreaterThan((AbstractDecimal)budgetPeriod.getDirectCostLimit())) continue;
            result.getMessageMap().putWarning(errorPath + "_" + budgetPeriod.getBudgetPeriod(), "warning.periodDirectCostLimit.exceeded", new String[]{budgetPeriod.getBudgetPeriod().toString()});
        }
        return result;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }
}

