/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.persistence;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class OjbMonthDayFieldConversion
implements FieldConversion {
    private static final DateTimeFormatter dbFormatter = DateTimeFormatter.ofPattern("MM/dd");

    public Object javaToSql(Object monthDay) throws ConversionException {
        if (monthDay instanceof MonthDay) {
            return ((MonthDay)monthDay).format(dbFormatter);
        }
        return monthDay;
    }

    public Object sqlToJava(Object monthDayString) throws ConversionException {
        try {
            if (monthDayString instanceof String) {
                return StringUtils.isEmpty((CharSequence)((String)monthDayString)) ? null : MonthDay.parse((CharSequence)monthDayString, dbFormatter);
            }
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
        return monthDayString;
    }
}

