/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.coeus.s2sgen.api.print;

import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.sys.api.model.KcFile;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class FormElements {
    private String namespace;
    private KcFile xmlFile;
    private PdfElements pdfElements;
    private StylesheetElements stylesheetElements;
    private List<AuditError> errors = Collections.emptyList();

    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public KcFile getXmlFile() {
        return xmlFile;
    }

    public void setXmlFile(KcFile xmlFile) {
        this.xmlFile = xmlFile;
    }

    public PdfElements getPdfElements() {
        return pdfElements;
    }

    public void setPdfElements(PdfElements pdfElements) {
        this.pdfElements = pdfElements;
    }

    public StylesheetElements getStylesheetElements() {
        return stylesheetElements;
    }

    public void setStylesheetElements(StylesheetElements stylesheetElements) {
        this.stylesheetElements = stylesheetElements;
    }

    public List<AuditError> getErrors() {
        return errors;
    }

    public void setErrors(List<AuditError> errors) {
        this.errors = errors;
    }

    public static class PdfElements {
        private KcFile pdfFile;
        private Map<String, AttachmentData> attachments = Collections.emptyMap();

        public KcFile getPdfFile() {
            return pdfFile;
        }

        public void setPdfFile(KcFile pdfFile) {
            this.pdfFile = pdfFile;
        }

        public Map<String, AttachmentData> getAttachments() {
            return attachments;
        }

        public void setAttachments(Map<String, AttachmentData> attachments) {
            this.attachments = attachments;
        }
    }

    public static class StylesheetElements {
        private List<KcFile> stylesheets = Collections.emptyList();
        private List<AttachmentData> attachments = Collections.emptyList();

        public List<KcFile> getStylesheets() {
            return stylesheets;
        }

        public void setStylesheets(List<KcFile> stylesheets) {
            this.stylesheets = stylesheets;
        }

        public List<AttachmentData> getAttachments() {
            return attachments;
        }

        public void setAttachments(List<AttachmentData> attachments) {
            this.attachments = attachments;
        }
    }
}
