/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.api.budget;

import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;

public final class S2SCostDto {

    private ScaleTwoDecimal cost;
    private String category;
    private String categoryType;
    private String description;
    private int quantity;
    private ScaleTwoDecimal costSharing;

    public ScaleTwoDecimal getCost() {
        return cost;
    }

    public void setCost(ScaleTwoDecimal cost) {
        this.cost = cost;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryType() {
        return categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getQuantity() {
        return quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public ScaleTwoDecimal getCostSharing() {
        return costSharing==null? ScaleTwoDecimal.ZERO:costSharing;
    }

    public void setCostSharing(ScaleTwoDecimal costSharing) {
        this.costSharing = costSharing;
    }
}
