/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfDeviationAuthorizationV11.NSFDeviationAuthorizationDocument;
import gov.grants.apply.forms.nsfDeviationAuthorizationV11.NSFDeviationAuthorizationDocument.NSFDeviationAuthorization;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.Collections;
import java.util.List;


/**
 * 
 * This class is used to generate XML Document object for grants.gov NSFDeviationAuthorizationV1.1. This form is generated using
 * XMLBean API's generated by compiling NSFDeviationAuthorizationV1.1 schema.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
@FormGenerator("NSFDeviationAuthorizationV1_1Generator")
public class NSFDeviationAuthorizationV1_1Generator extends NSFDeviationAuthorizationBaseGenerator<NSFDeviationAuthorizationDocument> implements S2SFormGeneratorPdfFillable<NSFDeviationAuthorizationDocument> {

    @Value("http://apply.grants.gov/forms/NSF_DeviationAuthorization-V1.1")
    private String namespace;

    @Value("NSF_DeviationAuthorization-V1.1")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_DeviationAuthorization-V1.1.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_DeviationAuthorization-V1.1.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;


    /**
     * 
     * This method returns NSFDeviationAuthorizationDocument object based on proposal development document which contains the
     * NSFDeviationAuthorizationDocument information NSFDeviationAuthorization for a particular proposal
     * 
     * @return authorizationDocument {@link XmlObject} of type NSFDeviationAuthorizationDocument.
     */
    private NSFDeviationAuthorizationDocument getNSFDeviationAuthorization() {

        NSFDeviationAuthorizationDocument authorizationDocument = NSFDeviationAuthorizationDocument.Factory.newInstance();
        NSFDeviationAuthorization nsfDeviationAuthorization = NSFDeviationAuthorization.Factory.newInstance();
        nsfDeviationAuthorization.setFormVersion(FormVersion.v1_1.getVersion());
        String devAuth = getAbstractText(DEVIATION_AUTHORIZATION);
        if (devAuth != null) {
            nsfDeviationAuthorization.setDeviationAuthorization(devAuth);
        }
        authorizationDocument.setNSFDeviationAuthorization(nsfDeviationAuthorization);
        return authorizationDocument;
    }

    /**
     * This method creates {@link XmlObject} of type {@link NSFDeviationAuthorizationDocument} by populating data from the given
     * {@link ProposalDevelopmentDocumentContract}
     * 
     * @param proposalDevelopmentDocument for which the {@link XmlObject} needs to be created
     * @return {@link XmlObject} which is generated using the given {@link ProposalDevelopmentDocumentContract}
     */
    @Override
    public NSFDeviationAuthorizationDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getNSFDeviationAuthorization();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(NSFDeviationAuthorizationDocument form, List<AttachmentData> attachments) {
        return new Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<NSFDeviationAuthorizationDocument> factory() {
        return NSFDeviationAuthorizationDocument.Factory;
    }
}
