/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.projectNarrativeAttachments12V12.ProjectNarrativeAttachments12Document;
import gov.grants.apply.forms.projectNarrativeAttachments12V12.ProjectNarrativeAttachments12Document.ProjectNarrativeAttachments12;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("Project_1_2V1_2Generator")
public class Project_1_2V1_2Generator extends ProjectBaseGenerator<ProjectNarrativeAttachments12Document> {

    @Value("http://apply.grants.gov/forms/ProjectNarrativeAttachments_1_2-V1.2")
    private String namespace;

    @Value("Project_1_2-V1.2")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ProjectNarrativeAttachments_1_2-V1.2.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ProjectNarrativeAttachments_1_2-V1.2.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    private ProjectNarrativeAttachments12Document getProjectNarrativeAttachments() {
        ProjectNarrativeAttachments12Document proAttachmentsDocument = ProjectNarrativeAttachments12Document.Factory.newInstance();
        ProjectNarrativeAttachments12 proAttachments = ProjectNarrativeAttachments12.Factory.newInstance();
        proAttachments.setFormVersion(FormVersion.v1_2.getVersion());
        AttachmentGroupMin1Max100DataType attMin1Max100DataType = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attMin1Max100DataType.setAttachedFileArray(getAttachedFileDataTypes(String.valueOf(PROJECT_ATTACHMENTS)));
        proAttachments.setAttachments(attMin1Max100DataType);
        proAttachmentsDocument.setProjectNarrativeAttachments12(proAttachments);
        return proAttachmentsDocument;
    }

    @Override
    public ProjectNarrativeAttachments12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getProjectNarrativeAttachments();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(ProjectNarrativeAttachments12Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getProjectNarrativeAttachments12().getAttachments() != null) {
                final List<AttachedFileDataType> attachedFileList = form.getProjectNarrativeAttachments12().getAttachments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); i++) {
                    final AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (i == 0 && a.getContentId().equals(attachedFile.getFileLocation().getHref())) {
                        return entry("ProjectNarrativeAttachments_1_2_P1.mandatoryFile0", a);
                    } else if (i > 0 && a.getContentId().equals(attachedFile.getFileLocation().getHref())) {
                        return entry("ProjectNarrativeAttachments_1_2_P1.optionalFile" + (i - 1), a);
                    }
                }
            }
            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<ProjectNarrativeAttachments12Document> factory() {
        return ProjectNarrativeAttachments12Document.Factory;
    }
}
