/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.validate;

import org.apache.xmlbeans.XmlObject;
import org.springframework.core.io.Resource;


/**
 * 
 * This class Forms the base for all XML Beans based validations to be done.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
public interface S2SValidatorService {
    
    String GRANTS_GOV_PREFIX = "/GrantApplication/Forms";


    /**
     * 
     * This method receives an XMLObject and validates it against its schema and returns the validation result. It also receives a
     * list in which upon validation failure, populates it with XPaths of the error nodes
     * 
     * @param formObject XML document as {@link XmlObject}
     * @param formName is the FormName.
     * @return validation result true if valid false otherwise.
     */
    ValidationResult validateForm(XmlObject formObject, String formName);

    /**
     *
     * This method receives a full s2s application and the url to a schema and validates the application against the schema.
     * Failure to retrieve the schema or a malformed schema will not cause a failure.
     */
    ValidationResult validateApplication(String applicationXml, Resource oppSchemaResource);
}
