/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.CitizenshipDataType;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.CitizenshipDataType.Enum;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.PHS398CareerDevelopmentAwardSup20Document;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.PHS398CareerDevelopmentAwardSup20Document.PHS398CareerDevelopmentAwardSup20;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.PHS398CareerDevelopmentAwardSup20Document.PHS398CareerDevelopmentAwardSup20.CareerDevelopmentAwardAttachments;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup20V20.PHS398CareerDevelopmentAwardSup20Document.PHS398CareerDevelopmentAwardSup20.CareerDevelopmentAwardAttachments.*;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.person.attr.CitizenshipType;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


@FormGenerator("PHS398CareerDevelopmentAwardSupV2_0Generator")
public class PHS398CareerDevelopmentAwardSupV2_0Generator extends PHS398CareerDevelopmentAwardSupBaseGenerator<PHS398CareerDevelopmentAwardSup20Document> implements S2SFormGeneratorPdfFillable<PHS398CareerDevelopmentAwardSup20Document> {

    @Value("http://apply.grants.gov/forms/PHS398_CareerDevelopmentAwardSup_2_0-V2.0")
    private String namespace;

    @Value("PHS398_CareerDevelopmentAwardSup_2_0")
    private String formName;

	@FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CareerDevelopmentAwardSup-V2.0.fo.xsl")
    private List<Resource> stylesheets;

	@Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_CareerDevelopmentAwardSup_2_0-V2.0.pdf")
	private Resource pdfForm;

    @Value("192")
    private int sortIndex;

    private PHS398CareerDevelopmentAwardSup20Document getPHS398CareerDevelopmentAwardSup() {
	    PHS398CareerDevelopmentAwardSup20Document phs398CareerDevelopmentAwardSupDocument = PHS398CareerDevelopmentAwardSup20Document.Factory.newInstance();
		PHS398CareerDevelopmentAwardSup20 phs398CareerDevelopmentAwardSup20 = PHS398CareerDevelopmentAwardSup20.Factory.newInstance();
		phs398CareerDevelopmentAwardSup20.setFormVersion(FormVersion.v2_0.getVersion());
		phs398CareerDevelopmentAwardSup20.setCitizenship(getCitizenshipDataType());
		phs398CareerDevelopmentAwardSup20.setCareerDevelopmentAwardAttachments(getCareerDevelopmentAwardAttachments());
		phs398CareerDevelopmentAwardSupDocument.setPHS398CareerDevelopmentAwardSup20(phs398CareerDevelopmentAwardSup20);
		return phs398CareerDevelopmentAwardSupDocument;
	}

	private Enum getCitizenshipDataType() {
		return pdDoc.getDevelopmentProposal().getProposalPersons().stream()
				.filter(ProposalPersonContract::isInvestigator)
				.map(proposalPerson -> s2SProposalPersonService.getCitizenship(proposalPerson))
				.map(citizenShip -> {
					if(CitizenshipType.NON_US_CITIZEN_WITH_TEMPORARY_VISA.equals(citizenShip)) {
						return CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA;
					} else if(CitizenshipType.PERMANENT_RESIDENT_OF_US.equals(citizenShip)) {
						return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S;
					} else if(CitizenshipType.US_CITIZEN_OR_NONCITIZEN_NATIONAL.equals(citizenShip)) {
						return CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL;
					} else if(CitizenshipType.PERMANENT_RESIDENT_OF_US_PENDING.equals(citizenShip)) {
						return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING;
					} else {
						return null;
					}
				}).findFirst().orElse(null);
	}	

	private CareerDevelopmentAwardAttachments getCareerDevelopmentAwardAttachments() {
		CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = CareerDevelopmentAwardAttachments.Factory.newInstance();
		AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
		List<AttachedFileDataType> attachedFileList = new ArrayList<>();
		AttachedFileDataType attachedFileDataType;
		for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
			int narrativeTypeCode = Integer.parseInt(narrative.getNarrativeType().getCode());
			switch (narrativeTypeCode) {
			case NARRATIVE_TYPE_INTRODUCTION_TO_APPLICATION:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				IntroductionToApplication introductionToApplication = IntroductionToApplication.Factory.newInstance();
				introductionToApplication.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setIntroductionToApplication(introductionToApplication);
				break;
			case NARRATIVE_TYPE_SPECIFIC_AIMS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				SpecificAims specificAims = SpecificAims.Factory.newInstance();
				specificAims.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setSpecificAims(specificAims);
				break;			
			case NARRATIVE_TYPE_PROGRESS_REPORT_PUBLICATION_LIST:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ProgressReportPublicationList progressReportPublicationList = ProgressReportPublicationList.Factory.newInstance();
				progressReportPublicationList.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setProgressReportPublicationList(progressReportPublicationList);
				break;
			case NARRATIVE_TYPE_PROTECTION_OF_HUMAN_SUBJECTS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null) {
	                continue;
	            }
				ProtectionOfHumanSubjects protectionOfHumanSubjects = ProtectionOfHumanSubjects.Factory.newInstance();
				protectionOfHumanSubjects.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
				break;
			case NARRATIVE_TYPE_INCLUSION_OF_WOMEN_AND_MINORITIES:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = InclusionOfWomenAndMinorities.Factory.newInstance();
				inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
				break;			
			case NARRATIVE_TYPE_INCLUSION_OF_CHILDREN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InclusionOfChildren inclusionOfChildren = InclusionOfChildren.Factory.newInstance();
				inclusionOfChildren.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInclusionOfChildren(inclusionOfChildren);
				break;
			case NARRATIVE_TYPE_VERTEBRATE_ANIMALS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				VertebrateAnimals vertebrateAnimals = VertebrateAnimals.Factory.newInstance();
				vertebrateAnimals.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setVertebrateAnimals(vertebrateAnimals);
				break;
			case NARRATIVE_TYPE_SELECT_AGENT_RESEARCH:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				SelectAgentResearch selectAgentResearch = SelectAgentResearch.Factory.newInstance();
				selectAgentResearch.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setSelectAgentResearch(selectAgentResearch);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_CONSORTIUM_CONTRACT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ConsortiumContractualArrangements consortiumContractualArrangements = ConsortiumContractualArrangements.Factory.newInstance();
				consortiumContractualArrangements.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setConsortiumContractualArrangements(consortiumContractualArrangements);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_RESOURCE_SHARING_PLAN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResourceSharingPlans resourceSharingPlans = ResourceSharingPlans.Factory.newInstance();
				resourceSharingPlans.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResourceSharingPlans(resourceSharingPlans);
				break;
			case NARRATIVE_TYPE_CANDIDATE_BACKGROUND:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				CandidateBackground candidateBackground = CandidateBackground.Factory.newInstance();
				candidateBackground.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setCandidateBackground(candidateBackground);
				break;
			case NARRATIVE_TYPE_CAREER_GOALS_AND_OBJECTIVES:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				CareerGoalsAndObjectives careerGoalsAndObjectives = CareerGoalsAndObjectives.Factory.newInstance();
				careerGoalsAndObjectives.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setCareerGoalsAndObjectives(careerGoalsAndObjectives);
				break;
			case NARRATIVE_TYPE_CAREER_DEVELOPMENT_AND_TRAINING:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				CareerDevelopmentAndTrainingActivities careerDevelopmentAndTrainingActivities = CareerDevelopmentAndTrainingActivities.Factory.newInstance();
				careerDevelopmentAndTrainingActivities.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setCareerDevelopmentAndTrainingActivities(careerDevelopmentAndTrainingActivities);
				break;
			case NARRATIVE_TYPE_RESPONSIBLE_CONDUCT_OF_RESEARCH:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResponsibleConductOfResearch responsibleConductOfResearch = ResponsibleConductOfResearch.Factory.newInstance();
				responsibleConductOfResearch.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResponsibleConductOfResearch(responsibleConductOfResearch);
				break;
			case NARRATIVE_TYPE_PHS398_MENTORING_PLAN:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				MentoringPlan mentoringPlan = MentoringPlan.Factory.newInstance();
				mentoringPlan.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setMentoringPlan(mentoringPlan);
				break;
			case NARRATIVE_TYPE_PHS398_MENTOR_STATEMENTS_LETTERS:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				StatementsOfSupport statementsOfSupport = StatementsOfSupport.Factory.newInstance();
				statementsOfSupport.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setStatementsOfSupport(statementsOfSupport);
				break;
			case NARRATIVE_TYPE_PHS398_INSTITUTIONAL_ENVIRONMENT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InsitutionalEnvironment insitutionalEnvironment = InsitutionalEnvironment.Factory.newInstance();
				insitutionalEnvironment.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInsitutionalEnvironment(insitutionalEnvironment);
				break;
			case NARRATIVE_TYPE_PHS398_INSTITUTIONAL_COMMITMENT:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				InstitutionalCommitment institutionalCommitment = InstitutionalCommitment.Factory.newInstance();
				institutionalCommitment.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setInstitutionalCommitment(institutionalCommitment);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_APPENDIX:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				attachedFileList.add(attachedFileDataType);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_REASEARCH_STRATEGY:
	            attachedFileDataType = addAttachedFileType(narrative);
	            if(attachedFileDataType == null){
	                continue;
	            }
				ResearchStrategy researchStrategy = ResearchStrategy.Factory.newInstance();
				researchStrategy.setAttFile(attachedFileDataType);
				careerDevelopmentAwardAttachments.setResearchStrategy(researchStrategy);
				break;
			case NARRATIVE_TYPE_PHS_CAREER_SUPPPORT_LTRS:
                attachedFileDataType = addAttachedFileType(narrative);
                if(attachedFileDataType == null){
                    continue;
                }
                LettersOfSupport lettersOfSupport = LettersOfSupport.Factory.newInstance();
                lettersOfSupport.setAttFile(attachedFileDataType);
                careerDevelopmentAwardAttachments.setLettersOfSupport(lettersOfSupport);
                break;             
			}
		}
		attachmentGroupMin0Max100DataType.setAttachedFileArray(attachedFileList.toArray(new AttachedFileDataType[0]));
		careerDevelopmentAwardAttachments.setAppendix(attachmentGroupMin0Max100DataType);
		return careerDevelopmentAwardAttachments;
	}

	@Override
	public PHS398CareerDevelopmentAwardSup20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
		this.pdDoc = proposalDevelopmentDocument;
		return getPHS398CareerDevelopmentAwardSup();
	}

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

	@Override
	public List<Resource> getStylesheets() {
		return stylesheets;
	}

	public void setStylesheets(List<Resource> stylesheets) {
		this.stylesheets = stylesheets;
	}

	@Override
	public Resource getPdfForm() {
		return pdfForm;
	}

	public void setPdfForm(Resource pdfForm) {
		this.pdfForm = pdfForm;
	}

	@Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

	@Override
	public Attachments getMappedAttachments(PHS398CareerDevelopmentAwardSup20Document form, List<AttachmentData> attachments) {
		final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
			final CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = form.getPHS398CareerDevelopmentAwardSup20().getCareerDevelopmentAwardAttachments();
			if (careerDevelopmentAwardAttachments != null) {
				final IntroductionToApplication introduction = careerDevelopmentAwardAttachments.getIntroductionToApplication();
				if (introduction != null && introduction.getAttFile() != null && a.getContentId().equals(introduction.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile0", a);
				}

				final CandidateBackground candidateBackground = careerDevelopmentAwardAttachments.getCandidateBackground();
				if (candidateBackground != null && candidateBackground.getAttFile() != null && a.getContentId().equals(candidateBackground.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile1", a);
				}

				final CareerGoalsAndObjectives careerGoalsAndObjectives = careerDevelopmentAwardAttachments.getCareerGoalsAndObjectives();
				if (careerGoalsAndObjectives != null && careerGoalsAndObjectives.getAttFile() != null && a.getContentId().equals(careerGoalsAndObjectives.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile2", a);
				}

				final CareerDevelopmentAndTrainingActivities careerDevelopmentAndTrainingActivities = careerDevelopmentAwardAttachments.getCareerDevelopmentAndTrainingActivities();
				if (careerDevelopmentAndTrainingActivities != null && careerDevelopmentAndTrainingActivities.getAttFile() != null && a.getContentId().equals(careerDevelopmentAndTrainingActivities.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile3", a);
				}

				final ResponsibleConductOfResearch responsibleConductOfResearch = careerDevelopmentAwardAttachments.getResponsibleConductOfResearch();
				if (responsibleConductOfResearch != null && responsibleConductOfResearch.getAttFile() != null && a.getContentId().equals(responsibleConductOfResearch.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile4", a);
				}

				final MentoringPlan mentoringPlan = careerDevelopmentAwardAttachments.getMentoringPlan();
				if (mentoringPlan != null && mentoringPlan.getAttFile() != null && a.getContentId().equals(mentoringPlan.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile5", a);
				}

				final StatementsOfSupport statementsOfSupport = careerDevelopmentAwardAttachments.getStatementsOfSupport();
				if (statementsOfSupport != null && statementsOfSupport.getAttFile() != null && a.getContentId().equals(statementsOfSupport.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile6", a);
				}

				final LettersOfSupport lettersOfSupport = careerDevelopmentAwardAttachments.getLettersOfSupport();
				if (lettersOfSupport != null && lettersOfSupport.getAttFile() != null && a.getContentId().equals(lettersOfSupport.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile7", a);
				}

				final InsitutionalEnvironment institutionalEnvironment = careerDevelopmentAwardAttachments.getInsitutionalEnvironment();
				if (institutionalEnvironment != null && institutionalEnvironment.getAttFile() != null && a.getContentId().equals(institutionalEnvironment.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile8", a);
				}

				final InstitutionalCommitment institutionalCommitment = careerDevelopmentAwardAttachments.getInstitutionalCommitment();
				if (institutionalCommitment != null && institutionalCommitment.getAttFile() != null && a.getContentId().equals(institutionalCommitment.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile9", a);
				}

				final SpecificAims specificAims = careerDevelopmentAwardAttachments.getSpecificAims();
				if (specificAims != null && specificAims.getAttFile() != null && a.getContentId().equals(specificAims.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile10", a);
				}

				final ResearchStrategy researchStrategy = careerDevelopmentAwardAttachments.getResearchStrategy();
				if (researchStrategy != null && researchStrategy.getAttFile() != null && a.getContentId().equals(researchStrategy.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.mandatoryFile0", a);
				}

				final ProgressReportPublicationList progressReportPublicationList = careerDevelopmentAwardAttachments.getProgressReportPublicationList();
				if (progressReportPublicationList != null && progressReportPublicationList.getAttFile() != null && a.getContentId().equals(progressReportPublicationList.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile11", a);
				}

				final ProtectionOfHumanSubjects protectionOfHumanSubjects = careerDevelopmentAwardAttachments.getProtectionOfHumanSubjects();
				if (protectionOfHumanSubjects != null && protectionOfHumanSubjects.getAttFile() != null && a.getContentId().equals(protectionOfHumanSubjects.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile12", a);
				}

				final InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = careerDevelopmentAwardAttachments.getInclusionOfWomenAndMinorities();
				if (inclusionOfWomenAndMinorities != null && inclusionOfWomenAndMinorities.getAttFile() != null && a.getContentId().equals(inclusionOfWomenAndMinorities.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile13", a);
				}

				final InclusionOfChildren inclusionOfChildren = careerDevelopmentAwardAttachments.getInclusionOfChildren();
				if (inclusionOfChildren != null && inclusionOfChildren.getAttFile() != null && a.getContentId().equals(inclusionOfChildren.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P1.optionalFile14", a);
				}

				final VertebrateAnimals vertebrateAnimals = careerDevelopmentAwardAttachments.getVertebrateAnimals();
				if (vertebrateAnimals != null && vertebrateAnimals.getAttFile() != null && a.getContentId().equals(vertebrateAnimals.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P2.optionalFile0", a);
				}

				final SelectAgentResearch selectAgentResearch = careerDevelopmentAwardAttachments.getSelectAgentResearch();
				if (selectAgentResearch != null && selectAgentResearch.getAttFile() != null && a.getContentId().equals(selectAgentResearch.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P2.optionalFile1", a);
				}

				final ConsortiumContractualArrangements consortiumContractualArrangements = careerDevelopmentAwardAttachments.getConsortiumContractualArrangements();
				if (consortiumContractualArrangements != null && consortiumContractualArrangements.getAttFile() != null && a.getContentId().equals(consortiumContractualArrangements.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P2.optionalFile2", a);
				}

				final ResourceSharingPlans resourceSharingPlans = careerDevelopmentAwardAttachments.getResourceSharingPlans();
				if (resourceSharingPlans != null && resourceSharingPlans.getAttFile() != null && a.getContentId().equals(resourceSharingPlans.getAttFile().getFileLocation().getHref())) {
					return entry("PHS398_CareerDevelopmentAwardSup_2_0_P2.optionalFile3", a);
				}

				if (careerDevelopmentAwardAttachments.getAppendix() != null) {
					final List<AttachedFileDataType> atts = careerDevelopmentAwardAttachments.getAppendix().getAttachedFileList();
					for (int i = 0; i < atts.size(); i++) {
						final AttachedFileDataType att = atts.get(i);
						if (att != null && a.getContentId().equals(att.getFileLocation().getHref())){
							return entry("PHS398_CareerDevelopmentAwardSup_2_0_P2.optionalFile_1_" + i, a);
						}
					}
				}
			}

			return entry((String) null, a);
		}).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

		return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
				attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
	}

	@Override
	public DocumentFactory<PHS398CareerDevelopmentAwardSup20Document> factory() {
		return PHS398CareerDevelopmentAwardSup20Document.Factory;
	}
}
