/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.edAbstractV11.AbstractAttachmentsDocument;
import gov.grants.apply.forms.edAbstractV11.AbstractAttachmentsDocument.AbstractAttachments;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;


/**
 * 
 * This class is used to generate XML Document object for grants.gov EDAbstractV1.1. This form is generated using XMLBean API's
 * generated by compiling EDAbstractV1.1 schema.
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
@FormGenerator("EDAbstractV1_1Generator")
public class EDAbstractV1_1Generator extends EDAbstractBaseGenerator<AbstractAttachmentsDocument> {

    @Value("http://apply.grants.gov/forms/ED_Abstract-V1.1")
    private String namespace;

    @Value("ED_Abstract-V1.1")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_Abstract-V1.1.fo.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/ED_Abstract-V1.1.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    /**
     * 
     * This method returns AbstractAttachmentsDocument object based on proposal development document which contains the
     * AbstractAttachmentsDocument informations about abstract type attachment for a particular proposal
     * 
     * @return abstractDocument(AbstractAttachmentsDocument) {@link XmlObject} of type AbstractAttachmentsDocument.
     */
    private AbstractAttachmentsDocument getAbstractAttachments() {

        AbstractAttachmentsDocument abstractDocument = AbstractAttachmentsDocument.Factory.newInstance();
        AbstractAttachments abstractAttachments = AbstractAttachments.Factory.newInstance();
        abstractAttachments.setFormVersion(FormVersion.v1_1.getVersion());
        abstractAttachments.setAttachments(AttachedFileDataType.Factory.newInstance());
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() != null && narrative.getNarrativeType().getCode().equals(ABSTRACT_ATTACHMENT_CODE)) {
            	attachedFileDataType = addAttachedFileType(narrative);
            	if(attachedFileDataType != null){
                	abstractAttachments.setAttachments(attachedFileDataType);
                }
            }
        }
        abstractDocument.setAbstractAttachments(abstractAttachments);
        return abstractDocument;
    }

    /**
     * This method creates {@link XmlObject} of type {@link AbstractAttachmentsDocument} by populating data from the given
     * {@link ProposalDevelopmentDocumentContract}
     * 
     * @param proposalDevelopmentDocument for which the {@link XmlObject} needs to be created
     * @return {@link XmlObject} which is generated using the given {@link ProposalDevelopmentDocumentContract}
     * 
     */
    @Override
    public AbstractAttachmentsDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {

        this.pdDoc = proposalDevelopmentDocument;
        return getAbstractAttachments();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }


    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(AbstractAttachmentsDocument form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getAbstractAttachments().getAttachments() != null && a.getContentId().equals(form.getAbstractAttachments().getAttachments().getFileLocation().getHref())) {
                return entry("ED_Abstract_P1.mandatoryFile0", a);
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<AbstractAttachmentsDocument> factory() {
        return AbstractAttachmentsDocument.Factory;
    }
}
