<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:footer="http://apply.grants.gov/system/Footer-V1.0"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
                xmlns:ED_SF424_Supplement_3_0="http://apply.grants.gov/forms/ED_SF424_Supplement_3_0-V3.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
                <fo:region-body margin-top="0.79in" margin-bottom="0.79in" />
                <fo:region-after extent=".79in" />
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="ED_SF424_Supplement_3_0:ED_SF424_Supplement_3_0">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set" />
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:static-content flow-name="xsl-region-after">
                    <fo:block>
                        <fo:inline font-size="6px" font-weight="bold">
                            Tracking Number:
                            <xsl:value-of select="/*/*/footer:Grants_govTrackingNumber" />
                        </fo:inline>
                    </fo:block>
                </fo:static-content>

                <fo:flow flow-name="xsl-region-body">
                    <fo:block>

                        <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="2pt">
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="12px" font-weight="bold">U.S. Department of Education Supplemental Information for the SF-424&#xA;Application for Federal Assistance</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">1. Project Director:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">* Name:</fo:inline>
                                            <fo:inline font-size="10px">&#160;</fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:Name">
                                                    <xsl:for-each select="globLib:PrefixName">
                                                        <fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:FirstName">
                                                        <fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:MiddleName">
                                                        <fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:LastName">
                                                        <fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:SuffixName">
                                                        <fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">Project Director Level of Effort (percentage of time devoted to grant):</fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirectorLevelOfEffort">
                                                    <fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline>
                                                    </fo:block>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">* Address:</fo:inline>
                                            <fo:inline font-size="10px">&#160;</fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:Address">
                                                    <xsl:for-each select="globLib:Street1"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:Street2"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>

                                                    <xsl:if test="globLib:County!=''">
                                                        <fo:block></fo:block>
                                                        <fo:inline font-size="10px">&#160;</fo:inline>

                                                        <xsl:for-each select="globLib:County"><fo:block keep-together="always">
                                                            <fo:inline font-size="10px">
                                                                <xsl:apply-templates />
                                                            </fo:inline></fo:block>
                                                            <fo:inline font-size="10px">&#160;County</fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:if>


                                                    <fo:block></fo:block>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:City"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:State"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:ZipPostalCode"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                    <fo:inline font-size="10px">&#160;</fo:inline>
                                                    <xsl:for-each select="globLib:Country"><fo:block keep-together="always">
                                                        <fo:inline font-size="10px">
                                                            <xsl:apply-templates />
                                                        </fo:inline></fo:block>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">* Phone Number (give area code): </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:Phone"><fo:block keep-together="always">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline></fo:block>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">Fax Number (give area code): </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:Fax"><fo:block keep-together="always">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline></fo:block>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">* Email Address: </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ProjectDirector">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:Email"><fo:block keep-together="always">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline></fo:block>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold">Alternate Email Address: </fo:inline>
                                            <fo:inline font-size="10px">&#160;</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">2. New Potential Grantee or Novice Applicant:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">a. Are you either a new potential grantee or novice applicant as defined in the program competition’s notice inviting applications (NIA)?</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsNoviceApplicant">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                            <fo:inline font-size="10px"> Yes&#160; </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsNoviceApplicant">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='N: No'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                            <fo:inline font-size="10px"> No </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:IsNoviceApplicant">
                                    <xsl:if test=".='Y: Yes'">
                                        <fo:table-row>
                                            <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                                <fo:block>
                                                    <fo:inline font-size="10px">b. If the program competition NIA is giving competitive preference points for a new potential grantee or novice applicant, how many points are you claiming for your application? (the NIA will indicate how many are available)</fo:inline>
                                                </fo:block>
                                            </fo:table-cell>
                                        </fo:table-row>
                                    </xsl:if>
                                </xsl:for-each>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">
                                                <xsl:for-each select="ED_SF424_Supplement_3_0:NIAPreferencePoints">
                                                    <xsl:apply-templates />
                                                </xsl:for-each>
                                            </fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">3. Qualified Opportunity Zones:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">If the NIA includes a Qualified Opportunity Zones (QOZ) Priority in which you propose to either provide services in QOZ(s) or are in a QOZ, provide the QOZ census tract number(s) below:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone1">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">1. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone2">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">2. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone3">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">3. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone4">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">4. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone5">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">5. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone6">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">6. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone7">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">7. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone8">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">8. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone9">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">9. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone10">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">10. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone11">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">11. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <xsl:for-each select="ED_SF424_Supplement_3_0:QualifiedOpportunityZone12">
                                    <fo:table-row>
                                        <fo:table-cell padding-start="6pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                            <fo:block>
                                                <fo:inline font-size="10px">12. <xsl:value-of select="."/></fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </xsl:for-each>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px" font-weight="bold" text-decoration="underline">4. Human Subjects Research:</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">a. Are any research activities involving human subjects planned at any time during the proposed project Period?</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">&#160;</fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsHumanResearch">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                            <fo:inline font-size="10px">Yes </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsHumanResearch">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='N: No'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                            <fo:inline font-size="10px"> No</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">b. Are ALL the research activities proposed designated to be exempt from the regulations?</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsHumanResearchExempt">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                            <fo:inline font-size="10px"> Yes&#160; Provide Exemption(s) #: </fo:inline>

                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber1">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 1 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>

                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber2">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 2 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>


                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber3">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 3 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>

                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber4">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 4 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>

                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber5">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 5 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>


                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber6">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 6 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>


                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber7">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 7 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>


                                            <xsl:for-each select="ED_SF424_Supplement_3_0:ExemptionNumber8">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='Y: Yes'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt"> 8 </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell height="17pt" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">&#160;</fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:IsHumanResearchExempt">
                                                <fo:inline font-size="10px">
                                                    <fo:inline padding-before="-3pt" padding-after="-2pt" text-decoration="underline" color="black">
                                                        <fo:inline>
                                                            <xsl:choose>
                                                                <xsl:when test=".='N: No'">
                                                                    <fo:inline font-family="Courier" font-size="12pt" padding-start="1.5pt" padding-end="1.5pt">&#x2022;</fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline text-decoration="underline" color="black">
                                                                        <fo:leader leader-length="7pt" leader-pattern="rule" />
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:inline>
                                                    </fo:inline>
                                                </fo:inline>
                                            </xsl:for-each>

                                            <fo:inline font-size="10px">No&#160;&#160; Provide Assurance #, if available: </fo:inline>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:AssuranceNumber">
                                                <fo:inline font-size="10px">
                                                    <xsl:apply-templates />
                                                </fo:inline>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>

                        <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="1pt">
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">c. If applicable, please attach your "Exempt Research" or "Nonexempt Research" narrative to this form as
                                                indicated in the definitions page in the attached instructions.</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>


                        <fo:table width="100%" space-before.optimum="1pt" space-after.optimum="1pt">
                            <fo:table-column />
                            <fo:table-column />
                            <fo:table-body>
                                <fo:table-row>
                                    <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">FileName</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <fo:inline font-size="10px">MimeType</fo:inline>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                                <fo:table-row>
                                    <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white">
                                        <fo:block>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:Attachment">
                                                <xsl:for-each select="att:FileName">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                    <fo:table-cell padding-start="1pt" padding-end="1pt" padding-before="1pt" padding-after="1pt" display-align="center" text-align="start" border-style="solid" border-width="1pt" border-color="white" hyphenate="true" language="en">
                                        <fo:block>
                                            <xsl:for-each select="ED_SF424_Supplement_3_0:Attachment">
                                                <xsl:for-each select="att:MimeType">
                                                    <fo:inline font-size="10px">
                                                        <xsl:apply-templates />
                                                    </fo:inline>
                                                </xsl:for-each>
                                            </xsl:for-each>
                                        </fo:block>
                                    </fo:table-cell>
                                </fo:table-row>
                            </fo:table-body>
                        </fo:table>





                    </fo:block>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="checkboxN">
        <xsl:param name="value" />
        <xsl:param name="schemaChoice">N: No</xsl:param>
        <xsl:if test="normalize-space($value) = normalize-space($schemaChoice)">
            <fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format"
                       xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema"
                       xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
                       xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats"
                       font-size="8pt">&#x2714;</fo:inline>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
