/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.budget;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetValidationService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.validate.S2SErrorHandlerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SBudgetValidationService")
public class S2SBudgetValidationServiceImpl
implements S2SBudgetValidationService {
    private static final String PARTICIPANT_COUNT_REQUIRED = "s2s.budget.participantcount.required";
    private static final String PARTICIPANT_COSTS_REQUIRED = "s2s.budget.participantcost.required";
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;
    @Autowired
    @Qualifier(value="s2SErrorHandlerService")
    protected S2SErrorHandlerService s2SErrorHandlerService;

    private String getParticipantSupportCategoryCode() {
        return this.s2SConfigurationService.getValueAsString("budgetCategoryType.participantSupport");
    }

    private List<? extends BudgetLineItemContract> getMatchingLineItems(List<? extends BudgetLineItemContract> lineItems, List<String> budgetCategoryType) {
        ArrayList<BudgetLineItemContract> result = new ArrayList<BudgetLineItemContract>();
        for (BudgetLineItemContract budgetLineItemContract : lineItems) {
            if (!budgetCategoryType.contains(budgetLineItemContract.getBudgetCategory().getBudgetCategoryType().getCode())) continue;
            result.add(budgetLineItemContract);
        }
        return result;
    }

    @Override
    public List<AuditError> validateBudgetForForm(ProposalDevelopmentDocumentContract pdDoc, String formName) {
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(pdDoc.getDevelopmentProposal());
        if (budget != null) {
            for (BudgetPeriodContract period : budget.getBudgetPeriods()) {
                int numberOfParticipants;
                ArrayList<String> participantSupportCode = new ArrayList<String>();
                participantSupportCode.add(this.getParticipantSupportCategoryCode());
                List<? extends BudgetLineItemContract> participantSupportLineItems = this.getMatchingLineItems(period.getBudgetLineItems(), participantSupportCode);
                int n = numberOfParticipants = period.getNumberOfParticipants() == null ? 0 : period.getNumberOfParticipants();
                if (!participantSupportLineItems.isEmpty() && numberOfParticipants == 0) {
                    AuditError auditError = this.s2SErrorHandlerService.getError(PARTICIPANT_COUNT_REQUIRED, formName);
                    AuditError error = new AuditError(auditError.getErrorKey(), auditError.getMessageKey() + period.getBudgetPeriod(), auditError.getLink(), new String[0]);
                    auditErrors.add(error);
                    continue;
                }
                if (numberOfParticipants <= 0 || !participantSupportLineItems.isEmpty()) continue;
                auditErrors.add(this.s2SErrorHandlerService.getError(PARTICIPANT_COSTS_REQUIRED, formName));
            }
        }
        return auditErrors;
    }
}

