/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_7Generator")
public class NSFCoverPageV1_7Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage17Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage17Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int GOALI = -1;
    private static final int RAISE = -2;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_1_7-V1.7")
    private String namespace;
    @Value(value="NSF_CoverPage_1_7-V1.7")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.7.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_7-V1.7.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private NSFCoverPage17Document getNSFCoverPage17() {
        AttachedFileDataType raise;
        AttachedFileDataType goali;
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage17Document nsfCoverPage17Document = (NSFCoverPage17Document)NSFCoverPage17Document.Factory.newInstance();
        NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17 = (NSFCoverPage17Document.NSFCoverPage17)NSFCoverPage17Document.NSFCoverPage17.Factory.newInstance();
        nsfCoverPage17.setFormVersion(FormVersion.v1_7.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage17);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage17.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage17.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage17);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage17.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage17.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage17.setMentoringPlan(mentoringPlan);
        }
        if ((goali = this.getAttachedNarrativeFile(-1)) != null) {
            nsfCoverPage17.setGOALILetter(goali);
        }
        if ((raise = this.getAttachedNarrativeFile(-2)) != null) {
            nsfCoverPage17.setRAISEEmails(raise);
        }
        nsfCoverPage17Document.setNSFCoverPage17(nsfCoverPage17);
        return nsfCoverPage17Document;
    }

    private void setFundingOpportunityNumber(NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17) {
        nsfCoverPage17.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17) {
        NSFCoverPage17Document.NSFCoverPage17.OtherInfo otherInfo = (NSFCoverPage17Document.NSFCoverPage17.OtherInfo)NSFCoverPage17Document.NSFCoverPage17.OtherInfo.Factory.newInstance();
        NSFCoverPage17Document.NSFCoverPage17.PIInfo pInfo = (NSFCoverPage17Document.NSFCoverPage17.PIInfo)NSFCoverPage17Document.NSFCoverPage17.PIInfo.Factory.newInstance();
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        int unansweredQuestions = questionnaireAnswers.size();
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage17, answer);
                    --unansweredQuestions;
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
            }
        }
        if (unansweredQuestions != 0) {
            nsfCoverPage17.setPIInfo(null);
            nsfCoverPage17.setOtherInfo(null);
        } else {
            nsfCoverPage17.setPIInfo(pInfo);
            nsfCoverPage17.setOtherInfo(otherInfo);
        }
    }

    private void setFundingMechanism(NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17, String answer) {
        NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.Enum fundingMechanism = StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.CONFERENCE.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.CONFERENCE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RAPID.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RAPID : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.EAGER.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.EAGER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.EQUIPMENT.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.EQUIPMENT : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RAISE.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RAISE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.FELLOWSHIP.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.FELLOWSHIP : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.IDEAS_LAB.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.IDEAS_LAB : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.GOALI.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.GOALI : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.FASED.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.FASED : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.TRAVEL.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.TRAVEL : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RESEARCH.toString()) ? NSFCoverPage17Document.NSFCoverPage17.FundingMechanism.RESEARCH : null)))))))))));
        nsfCoverPage17.setFundingMechanism(fundingMechanism);
    }

    private NSFCoverPage17Document.NSFCoverPage17.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage17Document.NSFCoverPage17.NSFUnitConsideration nsfConsideration = (NSFCoverPage17Document.NSFCoverPage17.NSFUnitConsideration)NSFCoverPage17Document.NSFCoverPage17.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public NSFCoverPage17Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage17();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage17Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage17().getSingleCopyDocuments() != null && form.getNSFCoverPage17().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage17().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_1_7_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage17().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_7_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage17().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_7_P1.optionalFile3", a);
            }
            AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage17().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_7_P1.optionalFile4", a);
            }
            AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage17().getRAISEEmails();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_7_P1.optionalFile5", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage17Document> factory() {
        return NSFCoverPage17Document.Factory;
    }
}

