/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage19V19.NSFCoverPage19Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_9Generator")
public class NSFCoverPageV1_9Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage19Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage19Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int FUNDING_INT_BRANCH_CAMPUS_QUESTION = 12;
    private static final int FUNDING_FOREIGN_ORG_QUESTION = 13;
    private static final int GOALI = -1;
    private static final int RAISE = -2;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_1_9-V1.9")
    private String namespace;
    @Value(value="NSF_CoverPage_1_9")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.9.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_9-V1.9.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;

    private NSFCoverPage19Document getNSFCoverPage19() {
        AttachedFileDataType raise;
        AttachedFileDataType goali;
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage19Document nsfCoverPage19Document = (NSFCoverPage19Document)NSFCoverPage19Document.Factory.newInstance();
        NSFCoverPage19Document.NSFCoverPage19 nsfCoverPage19 = (NSFCoverPage19Document.NSFCoverPage19)NSFCoverPage19Document.NSFCoverPage19.Factory.newInstance();
        nsfCoverPage19.setFormVersion(FormVersion.v1_9.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage19);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage19.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage19.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage19);
        this.setNsfId(nsfCoverPage19);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage19.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage19.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage19.setMentoringPlan(mentoringPlan);
        }
        if ((goali = this.getAttachedNarrativeFile(-1)) != null) {
            nsfCoverPage19.setGOALILetter(goali);
        }
        if ((raise = this.getAttachedNarrativeFile(-2)) != null) {
            nsfCoverPage19.setRAISEEmails(raise);
        }
        nsfCoverPage19Document.setNSFCoverPage19(nsfCoverPage19);
        return nsfCoverPage19Document;
    }

    private void setNsfId(NSFCoverPage19Document.NSFCoverPage19 nsfCoverPage19) {
        DepartmentalPersonDto person = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        nsfCoverPage19.setNSFID(person.getNsfId());
    }

    protected void setFundingMechanism(NSFCoverPage19Document.NSFCoverPage19 nsfCoverPage19, String answer) {
        NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.Enum fundingMechanism = StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.CONFERENCE.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.CONFERENCE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RAPID.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RAPID : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.EAGER.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.EAGER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.EQUIPMENT.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.EQUIPMENT : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RAISE.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RAISE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.FELLOWSHIP.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.FELLOWSHIP : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.IDEAS_LAB.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.IDEAS_LAB : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.GOALI.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.GOALI : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.FASED.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.FASED : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.TRAVEL.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.TRAVEL : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.CENTER.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.CENTER : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RESEARCH_INFRASTRUCTURE.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RESEARCH_INFRASTRUCTURE : (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RESEARCH.toString()) ? NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RESEARCH : null))))))))))));
        nsfCoverPage19.setFundingMechanism(fundingMechanism);
    }

    private void setFundingOpportunityNumber(NSFCoverPage19Document.NSFCoverPage19 nsfCoverPage19) {
        nsfCoverPage19.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage19Document.NSFCoverPage19 nsfCoverPage19) {
        nsfCoverPage19.setFundingMechanism(NSFCoverPage19Document.NSFCoverPage19.FundingMechanism.RESEARCH);
        NSFCoverPage19Document.NSFCoverPage19.OtherInfo otherInfo = (NSFCoverPage19Document.NSFCoverPage19.OtherInfo)NSFCoverPage19Document.NSFCoverPage19.OtherInfo.Factory.newInstance();
        NSFCoverPage19Document.NSFCoverPage19.PIInfo pInfo = (NSFCoverPage19Document.NSFCoverPage19.PIInfo)NSFCoverPage19Document.NSFCoverPage19.PIInfo.Factory.newInstance();
        List questionnaireAnswers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName());
        int unansweredQuestions = questionnaireAnswers.size();
        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage19, answer);
                    --unansweredQuestions;
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 12: {
                    otherInfo.setIsFundingInternationalBranch(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
                case 13: {
                    otherInfo.setIsFundingForeignOrganization(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    --unansweredQuestions;
                    break;
                }
            }
        }
        nsfCoverPage19.setOtherInfo(unansweredQuestions == 0 ? otherInfo : null);
        nsfCoverPage19.setPIInfo(pInfo);
    }

    @Override
    public NSFCoverPage19Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage19();
    }

    protected NSFCoverPage19Document.NSFCoverPage19.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage19Document.NSFCoverPage19.NSFUnitConsideration nsfConsideration = (NSFCoverPage19Document.NSFCoverPage19.NSFUnitConsideration)NSFCoverPage19Document.NSFCoverPage19.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage19Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage19().getSingleCopyDocuments() != null && form.getNSFCoverPage19().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage19().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_1_9_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage19().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_9_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage19().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_9_P1.optionalFile3", a);
            }
            AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage19().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_9_P1.optionalFile4", a);
            }
            AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage19().getRAISEEmails();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_9_P1.optionalFile5", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage19Document> factory() {
        return NSFCoverPage19Document.Factory;
    }
}

