/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.otherNarrativeAttachments12V12.OtherNarrativeAttachments12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.OtherBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="OtherV1_2Generator")
public class OtherV1_2Generator
extends OtherBaseGenerator<OtherNarrativeAttachments12Document> {
    @Value(value="http://apply.grants.gov/forms/OtherNarrativeAttachments_1_2-V1.2")
    private String namespace;
    @Value(value="Other-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/Other-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/OtherNarrativeAttachments_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="145")
    private int sortIndex;

    private OtherNarrativeAttachments12Document getOtherNarrativeAttachments() {
        OtherNarrativeAttachments12Document otherNarrativeAttachmentsDocument = (OtherNarrativeAttachments12Document)OtherNarrativeAttachments12Document.Factory.newInstance();
        OtherNarrativeAttachments12Document.OtherNarrativeAttachments12 otherNarrativeAttachments = (OtherNarrativeAttachments12Document.OtherNarrativeAttachments12)OtherNarrativeAttachments12Document.OtherNarrativeAttachments12.Factory.newInstance();
        otherNarrativeAttachments.setFormVersion(FormVersion.v1_2.getVersion());
        AttachmentGroupMin1Max100DataType attachmentGroupMin1Max100DataType = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroupMin1Max100DataType.setAttachedFileArray(this.getAttachedFileDataTypes());
        otherNarrativeAttachments.setAttachments(attachmentGroupMin1Max100DataType);
        otherNarrativeAttachmentsDocument.setOtherNarrativeAttachments12(otherNarrativeAttachments);
        return otherNarrativeAttachmentsDocument;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 19 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public OtherNarrativeAttachments12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getOtherNarrativeAttachments();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(OtherNarrativeAttachments12Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getOtherNarrativeAttachments12().getAttachments() != null && form.getOtherNarrativeAttachments12().getAttachments().getAttachedFileList() != null) {
                List<AttachedFileDataType> atts = form.getOtherNarrativeAttachments12().getAttachments().getAttachedFileList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att != null && i == 0 && a.getContentId().equals(att.getFileLocation().getHref())) {
                        return CollectionUtils.entry("OtherNarrativeAttachments_1_2_P1.mandatoryFile0", a);
                    }
                    if (att == null || i == 0 || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("OtherNarrativeAttachments_1_2_P1.optionalFile" + (i - 1), a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<OtherNarrativeAttachments12Document> factory() {
        return OtherNarrativeAttachments12Document.Factory;
    }
}

