/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.performanceSite30V30.PerformanceSite30Document;
import gov.grants.apply.forms.performanceSite30V30.SiteLocationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.CongressionalDistrictContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PerformanceSiteBaseGenerator;
import org.kuali.coeus.s2sgen.impl.validate.S2SErrorHandlerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PerformanceSiteV3_0Generator")
public class PerformanceSiteV3_0Generator
extends PerformanceSiteBaseGenerator<PerformanceSite30Document>
implements S2SFormGeneratorPdfFillable<PerformanceSite30Document> {
    private static final String QUESTION_ID_FOR_INDIVIDUAL_YNQ = "30";
    private static final int PROPOSAL_SITE_APPLICANT_ORGANIZATION = 1;
    private static final int PERFORMING_ORG_LOCATION_TYPE_CODE = 2;
    private static final int OTHER_ORG_LOCATION_TYPE_CODE = 3;
    private static final int PERFORMANCE_SITE_LOCATION_TYPE_CODE = 4;
    private final Map<Integer, Integer> locationTypeCodePriorityMap = Map.of(1, 0, 2, 1, 4, 2, 3, 3);
    @Value(value="http://apply.grants.gov/forms/PerformanceSite_3_0-V3.0")
    private String namespace;
    @Value(value="PerformanceSite_3_0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PerformanceSite-V3.0.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PerformanceSite_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="130")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="s2SErrorHandlerService")
    private S2SErrorHandlerService s2SErrorHandlerService;

    private PerformanceSite30Document getPerformanceSite() {
        PerformanceSite30Document performanceSite14Document = (PerformanceSite30Document)PerformanceSite30Document.Factory.newInstance();
        PerformanceSite30Document.PerformanceSite30 performanceSite30 = (PerformanceSite30Document.PerformanceSite30)PerformanceSite30Document.PerformanceSite30.Factory.newInstance();
        performanceSite30.setFormVersion(FormVersion.v3_0.getVersion());
        this.setOtherSites(performanceSite30);
        AttachedFileDataType attachedFile = this.getAttachedFileDataType("40");
        if (attachedFile != null) {
            performanceSite30.setAttachedFile(attachedFile);
        }
        performanceSite14Document.setPerformanceSite30(performanceSite30);
        return performanceSite14Document;
    }

    private void setSiteLocationDataType(SiteLocationDataType siteLocationDataType, OrganizationContract organization) {
        if (organization.getOrganizationYnqs() != null && !organization.getOrganizationYnqs().isEmpty()) {
            for (OrganizationYnqContract organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals(QUESTION_ID_FOR_INDIVIDUAL_YNQ)) continue;
                YesNoDataType.Enum answer = organizationYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                siteLocationDataType.setIndividual(answer);
            }
        }
    }

    private void setOtherSites(PerformanceSite30Document.PerformanceSite30 performanceSite) {
        List proposalSites = this.pdDoc.getDevelopmentProposal().getProposalSites().stream().sorted((o1, o2) -> this.locationTypeCodePriorityMap.get(o1.getLocationTypeCode()).compareTo(this.locationTypeCodePriorityMap.get(o2.getLocationTypeCode()))).collect(Collectors.toList());
        if (proposalSites != null) {
            OrganizationContract organization = null;
            SiteLocationDataType siteLocationDataType = null;
            for (ProposalSiteContract proposalSite : proposalSites) {
                String congressionalDistrict;
                organization = proposalSite.getOrganization();
                switch (proposalSite.getLocationTypeCode()) {
                    case 2: {
                        siteLocationDataType = performanceSite.addNewPrimarySite();
                        this.setSiteLocationDataType(siteLocationDataType, organization);
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                        break;
                    }
                    case 3: 
                    case 4: {
                        siteLocationDataType = performanceSite.addNewOtherSite();
                        siteLocationDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
                    }
                }
                if (siteLocationDataType == null) continue;
                siteLocationDataType.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)proposalSite));
                if (organization != null && organization.getDunsNumber() != null) {
                    siteLocationDataType.setDUNSNumber(organization.getDunsNumber());
                }
                if ((congressionalDistrict = this.getCongressionalDistrict(proposalSite)) == null) {
                    this.getAuditErrors().add(this.s2SErrorHandlerService.getError("performancesite.district.notfound", this.getFormName()));
                    siteLocationDataType.setCongressionalDistrictProgramProject(null);
                    continue;
                }
                siteLocationDataType.setCongressionalDistrictProgramProject(congressionalDistrict);
            }
        }
    }

    private String getCongressionalDistrict(ProposalSiteContract proposalSite) {
        String congDistrictProject = null;
        for (CongressionalDistrictContract congDistrict : proposalSite.getCongressionalDistricts()) {
            congDistrictProject = congDistrict.getCongressionalDistrict();
            if (congDistrictProject == null || congDistrictProject.length() <= 6) continue;
            congDistrictProject = congDistrictProject.substring(0, 6);
        }
        return congDistrictProject;
    }

    @Override
    public PerformanceSite30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPerformanceSite();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public S2SErrorHandlerService getS2SErrorHandlerService() {
        return this.s2SErrorHandlerService;
    }

    public void setS2SErrorHandlerService(S2SErrorHandlerService s2SErrorHandlerService) {
        this.s2SErrorHandlerService = s2SErrorHandlerService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PerformanceSite30Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<PerformanceSite30Document> factory() {
        return PerformanceSite30Document.Factory;
    }
}

