/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.coeus.additionalEquipment.AdditionalEquipmentListDocument;
import gov.grants.apply.coeus.extraKeyPerson.ExtraKeyPersonListDocument;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.BudgetTypeDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.BudgetYearDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.KeyPersonDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.OtherPersonnelDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.RRFedNonFedBudget20Document;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.SectBCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.SummaryDataType;
import gov.grants.apply.forms.rrFedNonFedBudget20V20.TotalDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetPeriodDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCompensationDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SEquipmentDto;
import org.kuali.coeus.s2sgen.api.budget.S2SIndirectCostDetailsDto;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherDirectCostInfoDto;
import org.kuali.coeus.s2sgen.api.budget.S2SOtherPersonnelDto;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.BudgetPeriodNum;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRFedNonFedBudgetBaseGenerator;
import org.kuali.coeus.s2sgen.impl.print.GenericPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.s2sgen.impl.util.UnsupportedOtherCostsErrorBuilder;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRFedNonFedBudgetV2_0Generator")
public class RRFedNonFedBudgetV2_0Generator
extends RRFedNonFedBudgetBaseGenerator<RRFedNonFedBudget20Document> {
    private static final Logger LOG = LogManager.getLogger(RRFedNonFedBudgetV2_0Generator.class);
    private static final String EXTRA_KEYPERSONS = "RRFEDNONFED_EXTRA_KEYPERSONS";
    private static final int EXTRA_KEYPERSONS_TYPE = 11;
    private static final String EXTRA_KEYPERSONS_COMMENT = "RRFEDNONFED_EXTRA_KEYPERSONS";
    private static final String ADDITIONAL_EQUIPMENT_NARRATIVE_TYPE_CODE = "12";
    private static final String ADDITIONAL_EQUIPMENT_NARRATIVE_COMMENT = "RRFEDNONFED_ADDITIONAL_EQUIPMENT";
    private static final int SUPPORTED_OTHER_COSTS = 3;
    private BudgetContract budget;
    @Value(value="http://apply.grants.gov/forms/RR_FedNonFedBudget_2_0-V2.0")
    private String namespace;
    @Value(value="RR_FedNonFedBudget_2_0-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_FedNonFedBudget-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_FedNonFedBudget_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="169")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SPrintingService")
    private S2SPrintingService s2SPrintingService;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/AdditionalEquipmentAttachmentNonFed.xsl")
    private Resource additionalEquipmentAttachmentNonFedStyleSheet;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ExtraKeyPersonAttachmentNonFed.xsl")
    private Resource extraKeyPersonAttachmentNonFedStyleSheet;

    private RRFedNonFedBudget20Document getRRFedNonFedBudget() {
        RRFedNonFedBudget20Document rrFedNonFedBudgetDocument = (RRFedNonFedBudget20Document)RRFedNonFedBudget20Document.Factory.newInstance();
        RRFedNonFedBudget20Document.RRFedNonFedBudget20 rrFedNonFedBudget = (RRFedNonFedBudget20Document.RRFedNonFedBudget20)RRFedNonFedBudget20Document.RRFedNonFedBudget20.Factory.newInstance();
        rrFedNonFedBudget.setFormVersion(FormVersion.v2_0.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrFedNonFedBudget.setSAMUEI(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getUei());
        }
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrFedNonFedBudget.setOrganizationName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
        rrFedNonFedBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        this.validateBudgetForForm(this.pdDoc);
        S2SBudgetDto budgetSummary = this.s2sBudgetInfoService.getBudgetInfo(this.pdDoc);
        List budgetPeriodList = budgetSummary.getBudgetPeriods();
        this.budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        rrFedNonFedBudget.setBudgetYearArray((BudgetYearDataType[])budgetPeriodList.stream().filter(budgetPeriodData -> Stream.of(BudgetPeriodNum.P1.getNum(), BudgetPeriodNum.P2.getNum(), BudgetPeriodNum.P3.getNum(), BudgetPeriodNum.P4.getNum(), BudgetPeriodNum.P5.getNum()).collect(Collectors.toSet()).contains(budgetPeriodData.getBudgetPeriod())).map(this::getBudgetYearDataType).toArray(BudgetYearDataType[]::new));
        AttachedFileDataType budgetJustification = this.getBudgetJustificationAttachment();
        if (budgetJustification != null) {
            rrFedNonFedBudget.setBudgetJustificationAttachment(budgetJustification);
        }
        rrFedNonFedBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrFedNonFedBudgetDocument.setRRFedNonFedBudget20(rrFedNonFedBudget);
        return rrFedNonFedBudgetDocument;
    }

    private BudgetYearDataType getBudgetYearDataType(S2SBudgetPeriodDto periodInfo) {
        ScaleTwoDecimal totalDirectCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal totalIndirectCostSharing = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal directCostsTotal = ScaleTwoDecimal.ZERO;
        BudgetYearDataType budgetYear = (BudgetYearDataType)BudgetYearDataType.Factory.newInstance();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2SDateTimeService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriodEnum = BudgetYearDataType.BudgetPeriod.Enum.forInt(periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriodEnum);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCompensation() != null) {
                summary.setFederalSummary(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            if (periodInfo.getTotalCompensationCostSharing() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    summary.setNonFederalSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                    if (periodInfo.getTotalCompensation() != null) {
                        summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getTotalCompensation().add((AbstractDecimal)periodInfo.getTotalCompensationCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                    }
                } else {
                    summary.setNonFederalSummary(BigDecimal.ZERO);
                    if (periodInfo.getTotalCompensation() != null) {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensation().bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(BigDecimal.ZERO);
                    }
                }
            }
            budgetYear.setTotalCompensation(summary);
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            SummaryDataType summaryDirect = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getDirectCostsTotal() != null) {
                directCostsTotal = periodInfo.getDirectCostsTotal();
                summaryDirect.setFederalSummary(directCostsTotal.bigDecimalValue());
            }
            if (periodInfo.getTotalDirectCostSharing() != null) {
                totalDirectCostSharing = periodInfo.getTotalDirectCostSharing();
            }
            summaryDirect.setNonFederalSummary(totalDirectCostSharing.bigDecimalValue());
            if (directCostsTotal != null) {
                summaryDirect.setTotalFedNonFedSummary(((ScaleTwoDecimal)directCostsTotal.add((AbstractDecimal)totalDirectCostSharing)).bigDecimalValue());
            } else {
                summaryDirect.setTotalFedNonFedSummary(totalDirectCostSharing.bigDecimalValue());
            }
            budgetYear.setDirectCosts(summaryDirect);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            if (periodInfo.getIndirectCosts().getTotalIndirectCostSharing() != null) {
                totalIndirectCostSharing = periodInfo.getIndirectCosts().getTotalIndirectCostSharing();
            }
            SummaryDataType summaryTotal = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCosts() != null) {
                summaryTotal.setFederalSummary(periodInfo.getTotalCosts().bigDecimalValue());
            }
            summaryTotal.setNonFederalSummary(totalDirectCostSharing.bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
            if (periodInfo.getTotalCosts() != null) {
                summaryTotal.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getTotalCosts().add((AbstractDecimal)totalDirectCostSharing)).bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
            } else {
                summaryTotal.setTotalFedNonFedSummary(totalDirectCostSharing.bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
            }
            budgetYear.setTotalCosts(summaryTotal);
        }
        SummaryDataType totalCostsFee = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetYear.getFee() != null) {
            totalCostsFee.setTotalFedNonFedSummary(budgetYear.getFee().add(budgetYear.getTotalCosts().getTotalFedNonFedSummary()));
            totalCostsFee.setFederalSummary(budgetYear.getTotalCosts().getFederalSummary());
            totalCostsFee.setNonFederalSummary(budgetYear.getTotalCosts().getNonFederalSummary());
        } else {
            totalCostsFee.setTotalFedNonFedSummary(budgetYear.getTotalCosts().getTotalFedNonFedSummary());
            totalCostsFee.setFederalSummary(budgetYear.getTotalCosts().getFederalSummary());
            totalCostsFee.setNonFederalSummary(budgetYear.getTotalCosts().getNonFederalSummary());
        }
        budgetYear.setTotalCostsFee(totalCostsFee);
        return budgetYear;
    }

    private RRFedNonFedBudget20Document.RRFedNonFedBudget20.BudgetSummary getBudgetSummary(S2SBudgetDto budgetSummaryData) {
        ScaleTwoDecimal cumTotalDirectCostSharing = ScaleTwoDecimal.ZERO;
        RRFedNonFedBudget20Document.RRFedNonFedBudget20.BudgetSummary budgetSummary = (RRFedNonFedBudget20Document.RRFedNonFedBudget20.BudgetSummary)RRFedNonFedBudget20Document.RRFedNonFedBudget20.BudgetSummary.Factory.newInstance();
        SummaryDataType summarySeniorKey = (SummaryDataType)SummaryDataType.Factory.newInstance();
        SummaryDataType summaryPersonnel = (SummaryDataType)SummaryDataType.Factory.newInstance();
        SummaryDataType directCosts = (SummaryDataType)SummaryDataType.Factory.newInstance();
        SummaryDataType directIndirectCosts = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                summarySeniorKey.setFederalSummary(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForSrPersonnel() != null) {
                summarySeniorKey.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                    summarySeniorKey.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumTotalFundsForSrPersonnel().add((AbstractDecimal)budgetSummaryData.getCumTotalNonFundsForSrPersonnel())).bigDecimalValue());
                } else {
                    summarySeniorKey.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                }
            }
            SummaryDataType summaryOtherPersonnel = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumTotalFundsForOtherPersonnel().add((AbstractDecimal)budgetSummaryData.getCumTotalNonFundsForOtherPersonnel())).bigDecimalValue());
                } else {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(summaryOtherPersonnel);
            if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
            }
            if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                summaryPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForPersonnel() != null) {
                summaryPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                    summaryPersonnel.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumTotalFundsForPersonnel().add((AbstractDecimal)budgetSummaryData.getCumTotalNonFundsForPersonnel())).bigDecimalValue());
                } else {
                    summaryPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTotalFundsRequestedEquipment(this.getCumulativeEquipments(budgetSummaryData));
            budgetSummary.setCumulativeTotalFundsRequestedTravel(this.getCumulativeTravels(budgetSummaryData));
            budgetSummary.setCumulativeDomesticTravelCosts(this.getCumulativeDomesticTravelCosts(budgetSummaryData));
            budgetSummary.setCumulativeForeignTravelCosts(this.getCumulativeForeignTravelCosts(budgetSummaryData));
            budgetSummary.setCumulativeTotalFundsRequestedTraineeCosts(this.getCumulativeTrainee(budgetSummaryData));
            budgetSummary.setCumulativeTraineeTuitionFeesHealthInsurance(this.getCumulativeTraineeTuitionFeesHealthInsurance(budgetSummaryData));
            budgetSummary.setCumulativeTraineeStipends(this.getCumulativeTraineeStipends(budgetSummaryData));
            budgetSummary.setCumulativeTraineeTravel(this.getCumulativeTraineeTravel(budgetSummaryData));
            budgetSummary.setCumulativeTraineeSubsistence(this.getCumulativeTraineeSubsistence(budgetSummaryData));
            budgetSummary.setCumulativeOtherTraineeCost(this.getCumulativeOtherTraineeCost(budgetSummaryData));
            budgetSummary.setCumulativeNoofTrainees(this.getCumulativeNoofTrainees(budgetSummaryData));
            budgetSummary.setCumulativeTotalFundsRequestedOtherDirectCosts(this.getCumulativeOtherDirect(budgetSummaryData));
            for (S2SOtherDirectCostInfoDto odci : budgetSummaryData.getOtherDirectCosts()) {
                List cvOthers = odci.getOtherCosts();
                boolean hasHumanFetalTissueCost = cvOthers.stream().anyMatch(cost -> "Human Fetal Tissue Costs".equals(cost.getDescription()));
                if (hasHumanFetalTissueCost) {
                    this.getAuditErrors().add(new AuditError("noField", "This form does not support Human Fetal Tissue costs.", "grantsGov.Opportunity", new String[0]));
                    break;
                }
                if (cvOthers.size() > 3) {
                    this.getAuditErrors().add(UnsupportedOtherCostsErrorBuilder.build(3));
                    break;
                }
                for (int j = 0; j < cvOthers.size(); ++j) {
                    S2SOtherCostDto hmCosts = (S2SOtherCostDto)cvOthers.get(j);
                    TotalDataType totalOther = (TotalDataType)TotalDataType.Factory.newInstance();
                    totalOther.setFederal(hmCosts.getCost().bigDecimalValue());
                    totalOther.setNonFederal(hmCosts.getCostSharing().bigDecimalValue());
                    totalOther.setTotalFedNonFed(((ScaleTwoDecimal)hmCosts.getCost().add((AbstractDecimal)hmCosts.getCostSharing())).bigDecimalValue());
                    if (j == 0) {
                        budgetSummary.setCumulativeOther1DirectCost(totalOther);
                        continue;
                    }
                    if (j == 1) {
                        budgetSummary.setCumulativeOther2DirectCost(totalOther);
                        continue;
                    }
                    budgetSummary.setCumulativeOther3DirectCost(totalOther);
                }
            }
            budgetSummary.setCumulativeAlterationsAndRenovations(this.getCumulativeAlterationsAndRenovations(budgetSummaryData));
            budgetSummary.setCumulativeEquipmentFacilityRentalFees(this.getCumulativeEquipmentFacilityRentalFees(budgetSummaryData));
            budgetSummary.setCumulativeSubawardConsortiumContractualCosts(this.getCumulativeSubawardConsortiumContractualCosts(budgetSummaryData));
            budgetSummary.setCumulativeADPComputerServices(this.getCumulativeADPComputerServices(budgetSummaryData));
            budgetSummary.setCumulativeConsultantServices(this.getCumulativeConsultantServices(budgetSummaryData));
            budgetSummary.setCumulativeMaterialAndSupplies(this.getCumulativeMaterialAndSupplies(budgetSummaryData));
            budgetSummary.setCumulativePublicationCosts(this.getCumulativePublicationCosts(budgetSummaryData));
            if (budgetSummaryData.getCumTotalDirectCosts() != null && budgetSummaryData.getCumTotalDirectCostSharing() != null) {
                if (budgetSummaryData.getCumFee() != null) {
                    budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
                }
                cumTotalDirectCostSharing = (ScaleTwoDecimal)((ScaleTwoDecimal)((ScaleTwoDecimal)budgetSummaryData.getCumTotalNonFundsForPersonnel().add((AbstractDecimal)budgetSummaryData.getCumEquipmentNonFunds())).add((AbstractDecimal)budgetSummaryData.getCumTravelNonFund())).add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartOtherCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartStipendCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTravelCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartSubsistenceCostSharing().add((AbstractDecimal)budgetSummaryData.getPartTuitionCostSharing())))))))));
                for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                    if (cumOtherDirect.getTotalOtherDirectCostSharing() == null) continue;
                    cumTotalDirectCostSharing = (ScaleTwoDecimal)cumTotalDirectCostSharing.add((AbstractDecimal)cumOtherDirect.getTotalOtherDirectCostSharing());
                }
                directCosts.setFederalSummary(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
                directCosts.setNonFederalSummary(cumTotalDirectCostSharing.bigDecimalValue());
                directCosts.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue().add(cumTotalDirectCostSharing.bigDecimalValue()));
            }
            if (budgetSummaryData.getCumTotalIndirectCosts() != null && budgetSummaryData.getCumTotalIndirectCostSharing() != null) {
                SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
                summary.setFederalSummary(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
                summary.setNonFederalSummary(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue());
                summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumTotalIndirectCosts().add((AbstractDecimal)budgetSummaryData.getCumTotalIndirectCostSharing())).bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(summary);
            }
            if (budgetSummaryData.getCumTotalCosts() != null && budgetSummaryData.getCumTotalDirectCostSharing() != null) {
                directIndirectCosts.setFederalSummary(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
                directIndirectCosts.setNonFederalSummary(cumTotalDirectCostSharing.bigDecimalValue().add(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue()));
                directIndirectCosts.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalCosts().bigDecimalValue().add(cumTotalDirectCostSharing.bigDecimalValue()).add(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue()));
            }
        }
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(summarySeniorKey);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(summaryPersonnel);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(directCosts);
        budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(directIndirectCosts);
        SummaryDataType cumulativeTotalCostsFee = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummary.getCumulativeFee() != null) {
            cumulativeTotalCostsFee.setTotalFedNonFedSummary(budgetSummary.getCumulativeFee().add(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getTotalFedNonFedSummary()));
            cumulativeTotalCostsFee.setFederalSummary(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getFederalSummary());
            cumulativeTotalCostsFee.setNonFederalSummary(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getNonFederalSummary());
        } else {
            cumulativeTotalCostsFee.setTotalFedNonFedSummary(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getTotalFedNonFedSummary());
            cumulativeTotalCostsFee.setFederalSummary(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getFederalSummary());
            cumulativeTotalCostsFee.setNonFederalSummary(budgetSummary.getCumulativeTotalFundsRequestedDirectIndirectCosts().getNonFederalSummary());
        }
        budgetSummary.setCumulativeTotalCostsFee(cumulativeTotalCostsFee);
        return budgetSummary;
    }

    private SummaryDataType getCumulativeOtherDirect(S2SBudgetDto budgetSummaryData) {
        SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getTotalOtherDirect() != null) {
                    summary.setFederalSummary(cumOtherDirect.getTotalOtherDirect().bigDecimalValue());
                }
                if (cumOtherDirect.getTotalOtherDirectCostSharing() == null) continue;
                summary.setNonFederalSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
                if (cumOtherDirect.getTotalOtherDirect() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)cumOtherDirect.getTotalOtherDirect().add((AbstractDecimal)cumOtherDirect.getTotalOtherDirectCostSharing())).bigDecimalValue());
                    continue;
                }
                summary.setTotalFedNonFedSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
            }
        }
        return summary;
    }

    private TotalDataType getCumulativeAlterationsAndRenovations(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalAlterations = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getAlterations() != null) {
                    totalAlterations.setFederal(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterationsCostSharing() == null) continue;
                totalAlterations.setNonFederal(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
                if (cumOtherDirect.getAlterations() != null) {
                    totalAlterations.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getAlterations().add((AbstractDecimal)cumOtherDirect.getAlterationsCostSharing())).bigDecimalValue());
                    continue;
                }
                totalAlterations.setTotalFedNonFed(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
            }
        }
        return totalAlterations;
    }

    private TotalDataType getCumulativeEquipmentFacilityRentalFees(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalEquipment = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getEquipRental() != null) {
                    totalEquipment.setFederal(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRentalCostSharing() == null) continue;
                totalEquipment.setNonFederal(cumOtherDirect.getEquipRentalCostSharing().bigDecimalValue());
                totalEquipment.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getEquipRental().add((AbstractDecimal)cumOtherDirect.getEquipRentalCostSharing())).bigDecimalValue());
            }
        }
        return totalEquipment;
    }

    private TotalDataType getCumulativeSubawardConsortiumContractualCosts(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalSubaward = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getSubAwards() != null) {
                    totalSubaward.setFederal(cumOtherDirect.getSubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getSubAwardsCostSharing() == null) continue;
                totalSubaward.setNonFederal(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
                if (cumOtherDirect.getSubAwards() != null) {
                    totalSubaward.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getSubAwards().add((AbstractDecimal)cumOtherDirect.getSubAwardsCostSharing())).bigDecimalValue());
                    continue;
                }
                totalSubaward.setTotalFedNonFed(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
            }
        }
        return totalSubaward;
    }

    private TotalDataType getCumulativeADPComputerServices(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalComputer = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getComputer() != null) {
                    totalComputer.setFederal(cumOtherDirect.getComputer().bigDecimalValue());
                }
                if (cumOtherDirect.getComputerCostSharing() == null) continue;
                totalComputer.setNonFederal(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
                if (cumOtherDirect.getComputer() != null) {
                    totalComputer.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getComputer().add((AbstractDecimal)cumOtherDirect.getComputerCostSharing())).bigDecimalValue());
                    continue;
                }
                totalComputer.setTotalFedNonFed(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
            }
        }
        return totalComputer;
    }

    private TotalDataType getCumulativeConsultantServices(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalConsultant = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getConsultants() != null) {
                    totalConsultant.setFederal(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultantsCostSharing() == null) continue;
                totalConsultant.setNonFederal(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
                if (cumOtherDirect.getConsultants() != null) {
                    totalConsultant.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getConsultants().add((AbstractDecimal)cumOtherDirect.getConsultantsCostSharing())).bigDecimalValue());
                    continue;
                }
                totalConsultant.setTotalFedNonFed(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
            }
        }
        return totalConsultant;
    }

    private TotalDataType getCumulativeMaterialAndSupplies(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalMaterial = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getMaterials() != null) {
                    totalMaterial.setFederal(cumOtherDirect.getMaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getMaterialsCostSharing() == null) continue;
                totalMaterial.setNonFederal(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
                if (cumOtherDirect.getMaterials() != null) {
                    totalMaterial.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getMaterials().add((AbstractDecimal)cumOtherDirect.getMaterialsCostSharing())).bigDecimalValue());
                    continue;
                }
                totalMaterial.setTotalFedNonFed(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
            }
        }
        return totalMaterial;
    }

    private TotalDataType getCumulativePublicationCosts(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalPublication = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            for (S2SOtherDirectCostInfoDto cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.getPublications() != null) {
                    totalPublication.setFederal(cumOtherDirect.getPublications().bigDecimalValue());
                }
                if (cumOtherDirect.getPublicationsCostSharing() == null) continue;
                totalPublication.setNonFederal(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
                if (cumOtherDirect.getPublications() != null) {
                    totalPublication.setTotalFedNonFed(((ScaleTwoDecimal)cumOtherDirect.getPublications().add((AbstractDecimal)cumOtherDirect.getPublicationsCostSharing())).bigDecimalValue());
                    continue;
                }
                totalPublication.setTotalFedNonFed(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
            }
        }
        return totalPublication;
    }

    private SummaryDataType getCumulativeTrainee(S2SBudgetDto budgetSummaryData) {
        SummaryDataType summaryTraineeCosts = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartOtherCost() != null && budgetSummaryData.getPartStipendCost() != null && budgetSummaryData.getPartTravelCost() != null && budgetSummaryData.getPartSubsistence() != null && budgetSummaryData.getPartTuition() != null) {
                summaryTraineeCosts.setFederalSummary(((ScaleTwoDecimal)budgetSummaryData.getPartOtherCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartStipendCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTravelCost().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartSubsistence().add((AbstractDecimal)budgetSummaryData.getPartTuition())))))))).bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null && budgetSummaryData.getPartStipendCostSharing() != null && budgetSummaryData.getPartTravelCostSharing() != null && budgetSummaryData.getPartSubsistenceCostSharing() != null && budgetSummaryData.getPartTuitionCostSharing() != null) {
                summaryTraineeCosts.setNonFederalSummary(((ScaleTwoDecimal)budgetSummaryData.getPartOtherCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartStipendCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartTravelCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)budgetSummaryData.getPartSubsistenceCostSharing().add((AbstractDecimal)budgetSummaryData.getPartTuitionCostSharing())))))))).bigDecimalValue());
            }
            if (summaryTraineeCosts.getNonFederalSummary() != null) {
                if (summaryTraineeCosts.getFederalSummary() != null) {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getFederalSummary().add(summaryTraineeCosts.getNonFederalSummary()));
                } else {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getNonFederalSummary());
                }
            }
        }
        return summaryTraineeCosts;
    }

    private TotalDataType getCumulativeTraineeTuitionFeesHealthInsurance(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalTuition = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartTuition() != null) {
                totalTuition.setFederal(budgetSummaryData.getPartTuition().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTuitionCostSharing() != null) {
                totalTuition.setNonFederal(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartTuition() != null) {
                    totalTuition.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getPartTuition().add((AbstractDecimal)budgetSummaryData.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTuition.setTotalFedNonFed(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
        }
        return totalTuition;
    }

    private TotalDataType getCumulativeTraineeStipends(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalStipends = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartStipendCost() != null) {
                totalStipends.setFederal(budgetSummaryData.getPartStipendCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getPartStipendCost().add((AbstractDecimal)budgetSummaryData.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                }
            }
        }
        return totalStipends;
    }

    private TotalDataType getCumulativeTraineeTravel(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalTravel = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartTravelCost() != null) {
                totalTravel.setFederal(budgetSummaryData.getPartTravelCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getPartTravelCost().add((AbstractDecimal)budgetSummaryData.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                }
            }
        }
        return totalTravel;
    }

    private TotalDataType getCumulativeTraineeSubsistence(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalSubsistence = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartSubsistence() != null) {
                totalSubsistence.setFederal(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            }
            if (budgetSummaryData.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getPartSubsistence().add((AbstractDecimal)budgetSummaryData.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
        }
        return totalSubsistence;
    }

    private TotalDataType getCumulativeOtherTraineeCost(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalOtherTrainee = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getPartOtherCost() != null) {
                totalOtherTrainee.setFederal(budgetSummaryData.getPartOtherCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null) {
                totalOtherTrainee.setNonFederal(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartOtherCost() != null) {
                    totalOtherTrainee.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getPartOtherCost().add((AbstractDecimal)budgetSummaryData.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    totalOtherTrainee.setTotalFedNonFed(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                }
            }
        }
        return totalOtherTrainee;
    }

    private int getCumulativeNoofTrainees(S2SBudgetDto budgetSummaryData) {
        return budgetSummaryData != null ? budgetSummaryData.getParticipantCount() : 0;
    }

    private SummaryDataType getCumulativeEquipments(S2SBudgetDto budgetSummaryData) {
        SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumEquipmentFunds() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
            }
            if (budgetSummaryData.getCumEquipmentNonFunds() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                if (budgetSummaryData.getCumEquipmentFunds() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumEquipmentFunds().add((AbstractDecimal)budgetSummaryData.getCumEquipmentNonFunds())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                }
            }
        }
        return summary;
    }

    private SummaryDataType getCumulativeTravels(S2SBudgetDto budgetSummaryData) {
        SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTravel() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTravelNonFund() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumTravel() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)budgetSummaryData.getCumTravel().add((AbstractDecimal)budgetSummaryData.getCumTravelNonFund())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                }
            }
        }
        return summary;
    }

    private TotalDataType getCumulativeDomesticTravelCosts(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalDomestic = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumDomesticTravel() != null) {
                totalDomestic.setFederal(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumDomesticTravelNonFund() != null) {
                totalDomestic.setNonFederal(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumDomesticTravel() != null) {
                    totalDomestic.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getCumDomesticTravel().add((AbstractDecimal)budgetSummaryData.getCumDomesticTravelNonFund())).bigDecimalValue());
                } else {
                    totalDomestic.setTotalFedNonFed(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                }
            }
        }
        return totalDomestic;
    }

    private TotalDataType getCumulativeForeignTravelCosts(S2SBudgetDto budgetSummaryData) {
        TotalDataType totalForeign = (TotalDataType)TotalDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumForeignTravel() != null) {
                totalForeign.setFederal(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumForeignTravelNonFund() != null) {
                totalForeign.setNonFederal(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumForeignTravel() != null) {
                    totalForeign.setTotalFedNonFed(((ScaleTwoDecimal)budgetSummaryData.getCumForeignTravel().add((AbstractDecimal)budgetSummaryData.getCumForeignTravelNonFund())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                }
            }
        }
        return totalForeign;
    }

    private AttachedFileDataType getBudgetJustificationAttachment() {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 131 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            return attachedFileDataType;
        }
        return null;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            int IndirectCostCount = 0;
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            for (S2SIndirectCostDetailsDto indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = (BudgetYearDataType.IndirectCosts.IndirectCost)BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                TotalDataType total = (TotalDataType)TotalDataType.Factory.newInstance();
                if (indirectCostDetails.getFunds() != null) {
                    total.setFederal(indirectCostDetails.getFunds().bigDecimalValue());
                } else {
                    total.setFederal(new BigDecimal(0.0));
                }
                if (indirectCostDetails.getCostSharing() != null) {
                    total.setNonFederal(indirectCostDetails.getCostSharing().bigDecimalValue());
                    if (indirectCostDetails.getFunds() != null) {
                        total.setTotalFedNonFed(((ScaleTwoDecimal)indirectCostDetails.getFunds().add((AbstractDecimal)indirectCostDetails.getCostSharing())).bigDecimalValue());
                    } else {
                        total.setTotalFedNonFed(indirectCostDetails.getCostSharing().bigDecimalValue());
                    }
                } else if (indirectCostDetails.getFunds() != null) {
                    total.setTotalFedNonFed(indirectCostDetails.getFunds().bigDecimalValue());
                    total.setNonFederal(new BigDecimal(0.0));
                } else {
                    total.setNonFederal(new BigDecimal(0.0));
                    total.setTotalFedNonFed(new BigDecimal(0.0));
                }
                indirectCost.setFundRequested(total);
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn("Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = (BudgetYearDataType.IndirectCosts)BudgetYearDataType.IndirectCosts.Factory.newInstance();
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(new BudgetYearDataType.IndirectCosts.IndirectCost[0]));
                SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    summary.setFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
                if (periodInfo.getIndirectCosts().getTotalIndirectCostSharing() != null) {
                    summary.setNonFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                        summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getIndirectCosts().getTotalIndirectCosts().add((AbstractDecimal)periodInfo.getIndirectCosts().getTotalIndirectCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    }
                }
                indirectCosts.setTotalIndirectCosts(summary);
            }
        }
        return indirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = (BudgetYearDataType.OtherDirectCosts)BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        TotalDataType totalMaterials = (TotalDataType)TotalDataType.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials() != null) {
                totalMaterials.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing() != null) {
                totalMaterials.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials() != null) {
                    totalMaterials.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterials().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing())).bigDecimalValue());
                } else {
                    totalMaterials.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getMaterialsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setMaterialsSupplies(totalMaterials);
            TotalDataType totalPublication = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications() != null) {
                totalPublication.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing() != null) {
                totalPublication.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications() != null) {
                    totalPublication.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublications().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing())).bigDecimalValue());
                } else {
                    totalPublication.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getPublicationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setPublicationCosts(totalPublication);
            TotalDataType totalConsultant = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                totalConsultant.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing() != null) {
                totalConsultant.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants() != null) {
                    totalConsultant.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultants().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing())).bigDecimalValue());
                } else {
                    totalConsultant.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getConsultantsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setConsultantServices(totalConsultant);
            TotalDataType totalADP = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer() != null) {
                totalADP.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing() != null) {
                totalADP.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer() != null) {
                    totalADP.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputer().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing())).bigDecimalValue());
                } else {
                    totalADP.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getComputerCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setADPComputerServices(totalADP);
            TotalDataType totalSubaward = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards() != null) {
                totalSubaward.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing() != null) {
                totalSubaward.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards() != null) {
                    totalSubaward.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwards().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing())).bigDecimalValue());
                } else {
                    totalSubaward.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getSubAwardsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setSubawardConsortiumContractualCosts(totalSubaward);
            TotalDataType totalEquipment = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                totalEquipment.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing() != null) {
                totalEquipment.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental() != null) {
                    totalEquipment.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRental().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing())).bigDecimalValue());
                } else {
                    totalEquipment.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getEquipRentalCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setEquipmentRentalFee(totalEquipment);
            TotalDataType totalAlterations = (TotalDataType)TotalDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                totalAlterations.setFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing() != null) {
                totalAlterations.setNonFederal(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations() != null) {
                    totalAlterations.setTotalFedNonFed(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterations().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing())).bigDecimalValue());
                } else {
                    totalAlterations.setTotalFedNonFed(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getAlterationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setAlterationsRenovations(totalAlterations);
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect() != null) {
                summary.setFederalSummary(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect().bigDecimalValue());
            }
            if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing() != null) {
                summary.setNonFederalSummary(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing().bigDecimalValue());
                if (((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirect().add((AbstractDecimal)((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(((S2SOtherDirectCostInfoDto)periodInfo.getOtherDirectCosts().get(0)).getTotalOtherDirectCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setTotalOtherDirectCost(summary);
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others othersDirect = (BudgetYearDataType.OtherDirectCosts.Others)BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            for (S2SOtherDirectCostInfoDto otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty((Collection)otherDirectCostInfo.getOtherCosts())) continue;
                for (S2SOtherCostDto oc : otherDirectCostInfo.getOtherCosts()) {
                    BudgetYearDataType.OtherDirectCosts.Others.Other other = othersDirect.addNewOther();
                    TotalDataType total = (TotalDataType)TotalDataType.Factory.newInstance();
                    total.setFederal(oc.getCost().bigDecimalValue());
                    total.setNonFederal(oc.getCostSharing().bigDecimalValue());
                    total.setTotalFedNonFed(((ScaleTwoDecimal)oc.getCost().add((AbstractDecimal)oc.getCostSharing())).bigDecimalValue());
                    other.setCost(total);
                    other.setDescription(oc.getDescription());
                }
            }
        }
        return othersDirect;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = (BudgetYearDataType.ParticipantTraineeSupportCosts)BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            TotalDataType totalTution = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getPartTuition() != null) {
                totalTution.setFederal(periodInfo.getPartTuition().bigDecimalValue());
            }
            if (periodInfo.getPartTuitionCostSharing() != null) {
                totalTution.setNonFederal(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                if (periodInfo.getPartTuition() != null) {
                    totalTution.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getPartTuition().add((AbstractDecimal)periodInfo.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTution.setTotalFedNonFed(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setTuitionFeeHealthInsurance(totalTution);
            TotalDataType totalStipends = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getPartStipendCost() != null) {
                totalStipends.setFederal(periodInfo.getPartStipendCost().bigDecimalValue());
            }
            if (periodInfo.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                if (periodInfo.getPartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getPartStipendCost().add((AbstractDecimal)periodInfo.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setStipends(totalStipends);
            TotalDataType totalTravel = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getPartTravelCost() != null) {
                totalTravel.setFederal(periodInfo.getPartTravelCost().bigDecimalValue());
            }
            if (periodInfo.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                if (periodInfo.getPartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getPartTravelCost().add((AbstractDecimal)periodInfo.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setParticipantTravel(totalTravel);
            TotalDataType totalSubsistence = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getPartSubsistence() != null) {
                totalSubsistence.setFederal(periodInfo.getPartSubsistence().bigDecimalValue());
            }
            if (periodInfo.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                if (periodInfo.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getPartSubsistence().add((AbstractDecimal)periodInfo.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setSubsistence(totalSubsistence);
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getParticipantCount());
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            summary.setFederalSummary(((ScaleTwoDecimal)periodInfo.getPartOtherCost().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartStipendCost().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartTravelCost().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartSubsistence().add((AbstractDecimal)periodInfo.getPartTuition())))))))).bigDecimalValue());
            summary.setNonFederalSummary(((ScaleTwoDecimal)periodInfo.getPartOtherCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartStipendCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartTravelCostSharing().add((AbstractDecimal)((ScaleTwoDecimal)periodInfo.getPartSubsistenceCostSharing().add((AbstractDecimal)periodInfo.getPartTuitionCostSharing())))))))).bigDecimalValue());
            if (summary.getNonFederalSummary() != null) {
                if (summary.getFederalSummary() != null) {
                    summary.setTotalFedNonFedSummary(summary.getFederalSummary().add(summary.getNonFederalSummary()));
                } else {
                    summary.setTotalFedNonFedSummary(summary.getNonFederalSummary());
                }
            }
            traineeSupportCosts.setTotalCost(summary);
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = (BudgetYearDataType.ParticipantTraineeSupportCosts.Other)BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        TotalDataType total = (TotalDataType)TotalDataType.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getPartOtherCost() != null) {
                total.setFederal(periodInfo.getPartOtherCost().bigDecimalValue());
            }
            if (periodInfo.getPartOtherCostSharing() != null) {
                total.setNonFederal(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                if (periodInfo.getPartOtherCost() != null) {
                    total.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getPartOtherCost().add((AbstractDecimal)periodInfo.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                }
            }
        }
        other.setCost(total);
        return other;
    }

    private BudgetYearDataType.Equipment getEquipment(S2SBudgetPeriodDto periodInfo) {
        AttachedFileDataType attachedFileDataType;
        NarrativeContract narrative;
        BudgetYearDataType.Equipment equipment = (BudgetYearDataType.Equipment)BudgetYearDataType.Equipment.Factory.newInstance();
        ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
        if (periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            SummaryDataType totalFund = (SummaryDataType)SummaryDataType.Factory.newInstance();
            totalFund.setFederalSummary(BigDecimal.ZERO);
            totalFund.setNonFederalSummary(BigDecimal.ZERO);
            totalFund.setTotalFedNonFedSummary(BigDecimal.ZERO);
            for (S2SCostDto costInfo : ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = (BudgetYearDataType.Equipment.EquipmentList)BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                TotalDataType fundsRequested = (TotalDataType)TotalDataType.Factory.newInstance();
                fundsRequested.setFederal(costInfo.getCost().bigDecimalValue());
                fundsRequested.setNonFederal(costInfo.getCostSharing().bigDecimalValue());
                fundsRequested.setTotalFedNonFed(((ScaleTwoDecimal)costInfo.getCost().add((AbstractDecimal)costInfo.getCostSharing())).bigDecimalValue());
                totalFund.setFederalSummary(totalFund.getFederalSummary().add(costInfo.getCost().bigDecimalValue()));
                totalFund.setNonFederalSummary(totalFund.getNonFederalSummary().add(costInfo.getCostSharing().bigDecimalValue()));
                equipmentList.setFundsRequested(fundsRequested);
                equipmentArrayList.add(equipmentList);
            }
            totalFund.setTotalFedNonFedSummary(totalFund.getFederalSummary().add(totalFund.getNonFederalSummary()));
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = equipmentArrayList.toArray(new BudgetYearDataType.Equipment.EquipmentList[0]);
            equipment.setEquipmentListArray(equipmentArray);
            equipment.setTotalFund(totalFund);
            S2SEquipmentDto equipmentInfo = (S2SEquipmentDto)periodInfo.getEquipment().get(0);
            TotalDataType totalFundForExtraEquipment = (TotalDataType)TotalDataType.Factory.newInstance();
            totalFundForExtraEquipment.setFederal(equipmentInfo.getTotalExtraFund().bigDecimalValue());
            totalFundForExtraEquipment.setNonFederal(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
            if (equipmentInfo.getTotalExtraFund() != null) {
                totalFundForExtraEquipment.setTotalFedNonFed(((ScaleTwoDecimal)equipmentInfo.getTotalExtraFund().add((AbstractDecimal)equipmentInfo.getTotalExtraNonFund())).bigDecimalValue());
            } else {
                totalFundForExtraEquipment.setTotalFedNonFed(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
            }
            equipment.setTotalFundForAttachedEquipment(totalFundForExtraEquipment);
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (equipmentInfo.getTotalFund() != null) {
                summary.setFederalSummary(equipmentInfo.getTotalFund().bigDecimalValue());
            }
            if (equipmentInfo.getTotalNonFund() != null) {
                summary.setNonFederalSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                if (equipmentInfo.getTotalFund() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)equipmentInfo.getTotalFund().add((AbstractDecimal)equipmentInfo.getTotalNonFund())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                }
            }
            equipment.setTotalFund(summary);
        }
        if ((narrative = this.saveExtraEquipment(periodInfo)) != null && (attachedFileDataType = this.addAttachedFileType(narrative)) != null) {
            equipment.setAdditionalEquipmentsAttachment(attachedFileDataType);
        }
        return equipment;
    }

    private NarrativeContract saveExtraEquipment(S2SBudgetPeriodDto periodInfo) {
        NarrativeContract narrative = null;
        List extraEquipmentList = ((S2SEquipmentDto)periodInfo.getEquipment().get(0)).getExtraEquipmentList();
        if (extraEquipmentList.size() > 0) {
            AdditionalEquipmentListDocument.AdditionalEquipmentList additionalEquipmentList = (AdditionalEquipmentListDocument.AdditionalEquipmentList)AdditionalEquipmentListDocument.AdditionalEquipmentList.Factory.newInstance();
            additionalEquipmentList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            additionalEquipmentList.setBudgetPeriod(new BigInteger(Integer.toString(periodInfo.getBudgetPeriod())));
            additionalEquipmentList.setEquipmentListArray(this.getEquipmentListArray(extraEquipmentList));
            AdditionalEquipmentListDocument additionalEquipmentDoc = (AdditionalEquipmentListDocument)AdditionalEquipmentListDocument.Factory.newInstance();
            additionalEquipmentDoc.setAdditionalEquipmentList(additionalEquipmentList);
            String xmlData = additionalEquipmentDoc.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.additionalEquipmentAttachmentNonFedStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_ADDITIONAL_EQUIPMENT.pdf";
                narrative = this.saveNarrative(printData.getData(), ADDITIONAL_EQUIPMENT_NARRATIVE_TYPE_CODE, fileName, ADDITIONAL_EQUIPMENT_NARRATIVE_COMMENT);
            }
            catch (S2SException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return narrative;
    }

    private AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[] getEquipmentListArray(List<S2SCostDto> extraEquipmentArrayList) {
        ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList> additionalEquipmentListList = new ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList>();
        for (S2SCostDto costInfo : extraEquipmentArrayList) {
            AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList equipmentList = (AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList)AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList.Factory.newInstance();
            equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
            equipmentList.setNonFederal(costInfo.getCostSharing().bigDecimalValue());
            equipmentList.setTotalFedNonFed(((ScaleTwoDecimal)costInfo.getCost().add((AbstractDecimal)costInfo.getCostSharing())).bigDecimalValue());
            equipmentList.setEquipmentItem(costInfo.getDescription() != null ? costInfo.getDescription() : costInfo.getCategory());
            additionalEquipmentListList.add(equipmentList);
        }
        return additionalEquipmentListList.toArray(new AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[0]);
    }

    private NarrativeContract saveExtraKeyPersons(S2SBudgetPeriodDto periodInfo) {
        NarrativeContract extraKPNarrative = null;
        if (periodInfo.getExtraKeyPersons() != null && !periodInfo.getExtraKeyPersons().isEmpty()) {
            ExtraKeyPersonListDocument extraKeyPersonListDocument = (ExtraKeyPersonListDocument)ExtraKeyPersonListDocument.Factory.newInstance();
            ExtraKeyPersonListDocument.ExtraKeyPersonList extraKeyPersonList = (ExtraKeyPersonListDocument.ExtraKeyPersonList)ExtraKeyPersonListDocument.ExtraKeyPersonList.Factory.newInstance();
            extraKeyPersonList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraKeyPersonList.setBudgetPeriod(new BigInteger("" + periodInfo.getBudgetPeriod()));
            extraKeyPersonList.setKeyPersonsArray(this.getExtraKeyPersons(periodInfo.getExtraKeyPersons()));
            extraKeyPersonListDocument.setExtraKeyPersonList(extraKeyPersonList);
            String xmlData = extraKeyPersonListDocument.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.extraKeyPersonAttachmentNonFedStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_" + periodInfo.getBudgetPeriod() + "_RRFEDNONFED_EXTRA_KEYPERSONS.pdf";
                extraKPNarrative = this.saveNarrative(printData.getData(), "11", fileName, "RRFEDNONFED_EXTRA_KEYPERSONS");
            }
            catch (S2SException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return extraKPNarrative;
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[] getExtraKeyPersons(List<S2SKeyPersonDto> keyPersonList) {
        ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons> keypersonslist = new ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons>();
        for (S2SKeyPersonDto keyPersonInfo : keyPersonList) {
            ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons keyPerson = (ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons)ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Factory.newInstance();
            keyPerson.setFirstName(keyPersonInfo.getFirstName());
            keyPerson.setMiddleName(keyPersonInfo.getMiddleName());
            keyPerson.setLastName(keyPersonInfo.getLastName());
            keyPerson.setProjectRole(keyPersonInfo.getRole());
            keyPerson.setCompensation(this.getExtraKeyPersonCompensation(keyPersonInfo));
            keypersonslist.add(keyPerson);
        }
        return keypersonslist.toArray(new ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[0]);
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation getExtraKeyPersonCompensation(S2SKeyPersonDto keyPersonInfo) {
        ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation compensation = (ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation)ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation.Factory.newInstance();
        compensation.setAcademicMonths(keyPersonInfo.getCompensation().getAcademicMonths().bigDecimalValue());
        compensation.setCalendarMonths(keyPersonInfo.getCompensation().getCalendarMonths().bigDecimalValue());
        compensation.setSummerMonths(keyPersonInfo.getCompensation().getSummerMonths().bigDecimalValue());
        compensation.setBaseSalary(keyPersonInfo.getCompensation().getBaseSalary().bigDecimalValue());
        compensation.setFringeBenefits(((ScaleTwoDecimal)keyPersonInfo.getCompensation().getFringe().add((AbstractDecimal)(keyPersonInfo.getCompensation().getFringeCostSharing() != null ? keyPersonInfo.getCompensation().getFringeCostSharing() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
        compensation.setFundsRequested(keyPersonInfo.getCompensation().getFundsRequested().bigDecimalValue());
        compensation.setRequestedSalary(((ScaleTwoDecimal)keyPersonInfo.getCompensation().getRequestedSalary().add((AbstractDecimal)(keyPersonInfo.getCompensation().getCostSharingAmount() != null ? keyPersonInfo.getCompensation().getCostSharingAmount() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
        compensation.setNonFederal(keyPersonInfo.getCompensation().getNonFundsRequested().bigDecimalValue());
        if (keyPersonInfo.getCompensation().getFundsRequested() != null) {
            compensation.setTotalFedNonFed(((ScaleTwoDecimal)keyPersonInfo.getCompensation().getFundsRequested().add((AbstractDecimal)keyPersonInfo.getCompensation().getNonFundsRequested())).bigDecimalValue());
        } else {
            compensation.setTotalFedNonFed(keyPersonInfo.getCompensation().getNonFundsRequested().bigDecimalValue());
        }
        return compensation;
    }

    private BudgetYearDataType.Travel getTravel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.Travel travel = (BudgetYearDataType.Travel)BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            TotalDataType total = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getDomesticTravelCost() != null) {
                total.setFederal(periodInfo.getDomesticTravelCost().bigDecimalValue());
            }
            if (periodInfo.getDomesticTravelCostSharing() != null) {
                total.setNonFederal(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                if (periodInfo.getDomesticTravelCost() != null) {
                    total.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getDomesticTravelCost().add((AbstractDecimal)periodInfo.getDomesticTravelCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setDomesticTravelCost(total);
            TotalDataType totalForeign = (TotalDataType)TotalDataType.Factory.newInstance();
            if (periodInfo.getForeignTravelCost() != null) {
                totalForeign.setFederal(periodInfo.getForeignTravelCost().bigDecimalValue());
            }
            if (periodInfo.getForeignTravelCostSharing() != null) {
                totalForeign.setNonFederal(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                if (periodInfo.getForeignTravelCost() != null) {
                    totalForeign.setTotalFedNonFed(((ScaleTwoDecimal)periodInfo.getForeignTravelCost().add((AbstractDecimal)periodInfo.getForeignTravelCostSharing())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setForeignTravelCost(totalForeign);
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalTravelCost() != null) {
                summary.setFederalSummary(periodInfo.getTotalTravelCost().bigDecimalValue());
            }
            if (periodInfo.getTotalTravelCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                if (periodInfo.getTotalTravelCost() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getTotalTravelCost().add((AbstractDecimal)periodInfo.getTotalTravelCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setTotalTravelCost(summary);
        }
        return travel;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(S2SBudgetPeriodDto periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = (BudgetYearDataType.OtherPersonnel)BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        if (periodInfo != null) {
            if (periodInfo.getOtherPersonnel() != null) {
                for (S2SOtherPersonnelDto otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                    if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                        continue;
                    }
                    if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                        continue;
                    }
                    if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                        continue;
                    }
                    if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                        continue;
                    }
                    if (OtherpersonalCount >= 6) continue;
                    S2SCompensationDto compensation = otherPersonnelInfo.getCompensation();
                    OtherPersonnelDataType otherPersonnelDataType = (OtherPersonnelDataType)OtherPersonnelDataType.Factory.newInstance();
                    otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                    otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                    if (compensation != null) {
                        if (compensation.getAcademicMonths() != null) {
                            otherPersonnelDataType.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
                        }
                        if (compensation.getCalendarMonths() != null) {
                            otherPersonnelDataType.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
                        }
                        if (compensation.getSummerMonths() != null) {
                            otherPersonnelDataType.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
                        }
                        if (compensation.getFringe() != null) {
                            otherPersonnelDataType.setFringeBenefits(((ScaleTwoDecimal)compensation.getFringe().add((AbstractDecimal)(compensation.getFringeCostSharing() != null ? compensation.getFringeCostSharing() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
                        }
                        if (compensation.getRequestedSalary() != null) {
                            otherPersonnelDataType.setRequestedSalary(((ScaleTwoDecimal)compensation.getRequestedSalary().add((AbstractDecimal)(compensation.getCostSharingAmount() != null ? compensation.getCostSharingAmount() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
                        }
                        otherPersonnelDataType.setOtherTotal(this.getCompensationTotalDataType(compensation));
                    }
                    otherPersonnelList.add(otherPersonnelDataType);
                    ++OtherpersonalCount;
                }
                OtherPersonnelDataType[] otherPersonnelDataTypeArray = otherPersonnelList.toArray(new OtherPersonnelDataType[0]);
                otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
                if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                    otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
                }
            }
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                summary.setFederalSummary(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
            if (periodInfo.getTotalOtherPersonnelNonFunds() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    summary.setNonFederalSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                    if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                        summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getTotalOtherPersonnelFunds().add((AbstractDecimal)periodInfo.getTotalOtherPersonnelNonFunds())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                    }
                } else {
                    summary.setNonFederalSummary(BigDecimal.ZERO);
                    if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(BigDecimal.ZERO);
                    }
                }
            }
            otherPersonnel.setTotalOtherPersonnelFund(summary);
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDoc = (BudgetYearDataType.OtherPersonnel.PostDocAssociates)BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDoc.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDoc.setProjectRole(otherPersonnel.getRole());
            postDoc.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDoc;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = (BudgetYearDataType.OtherPersonnel.GraduateStudents)BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = (BudgetYearDataType.OtherPersonnel.UndergraduateStudents)BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(S2SOtherPersonnelDto otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarial = (BudgetYearDataType.OtherPersonnel.SecretarialClerical)BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarial.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarial.setProjectRole(otherPersonnel.getRole());
            secretarial.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarial;
    }

    private SectBCompensationDataType getSectBCompensationDataType(S2SCompensationDto compensation) {
        SectBCompensationDataType sectBCompensation = (SectBCompensationDataType)SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            if (compensation.getAcademicMonths() != null) {
                sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            }
            if (compensation.getCalendarMonths() != null) {
                sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            }
            if (compensation.getSummerMonths() != null) {
                sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            }
            if (compensation.getFringe() != null) {
                sectBCompensation.setFringeBenefits(((ScaleTwoDecimal)compensation.getFringe().add((AbstractDecimal)(compensation.getFringeCostSharing() != null ? compensation.getFringeCostSharing() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
            }
            if (compensation.getRequestedSalary() != null) {
                sectBCompensation.setRequestedSalary(((ScaleTwoDecimal)compensation.getRequestedSalary().add((AbstractDecimal)(compensation.getCostSharingAmount() != null ? compensation.getCostSharingAmount() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
            }
            sectBCompensation.setOtherTotal(this.getCompensationTotalDataType(compensation));
        }
        return sectBCompensation;
    }

    private TotalDataType getCompensationTotalDataType(S2SCompensationDto compensation) {
        TotalDataType totalDataType = (TotalDataType)TotalDataType.Factory.newInstance();
        if (compensation.getFundsRequested() != null) {
            totalDataType.setFederal(compensation.getFundsRequested().bigDecimalValue());
        }
        if (compensation.getNonFundsRequested() != null) {
            if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                totalDataType.setNonFederal(compensation.getNonFundsRequested().bigDecimalValue());
                if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                    totalDataType.setTotalFedNonFed(((ScaleTwoDecimal)compensation.getFundsRequested().add((AbstractDecimal)compensation.getNonFundsRequested())).bigDecimalValue());
                }
            } else {
                totalDataType.setNonFederal(BigDecimal.ZERO);
                if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                    totalDataType.setTotalFedNonFed(compensation.getFundsRequested().bigDecimalValue());
                }
            }
        }
        return totalDataType;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(S2SBudgetPeriodDto periodInfo) {
        AttachedFileDataType attachedFileDataType;
        NarrativeContract extraKeyPersonNarr;
        BudgetYearDataType.KeyPersons keyPersons = (BudgetYearDataType.KeyPersons)BudgetYearDataType.KeyPersons.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList<KeyPersonDataType> keyPersonList = new ArrayList<KeyPersonDataType>();
                int keyPersonCount = 0;
                for (S2SKeyPersonDto keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    KeyPersonDataType keyPersonDataType = (KeyPersonDataType)KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson, periodInfo.getBudgetPeriod()));
                    keyPersonList.add(keyPersonDataType);
                    LOG.info("keyPersonCount:" + ++keyPersonCount);
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new KeyPersonDataType[0]));
            }
            SummaryDataType summary = (SummaryDataType)SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                summary.setFederalSummary(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            if (periodInfo.getTotalNonFundsKeyPersons() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                if (periodInfo.getTotalFundsKeyPersons() != null) {
                    summary.setTotalFedNonFedSummary(((ScaleTwoDecimal)periodInfo.getTotalFundsKeyPersons().add((AbstractDecimal)periodInfo.getTotalNonFundsKeyPersons())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                }
            }
            keyPersons.setTotalFundForKeyPersons(summary);
            SummaryDataType summaryAttachedKey = (SummaryDataType)SummaryDataType.Factory.newInstance();
            BigDecimal totalFederalSummary = BigDecimal.ZERO;
            BigDecimal totalNonFederalSummary = BigDecimal.ZERO;
            for (S2SKeyPersonDto keyPersonInfo : periodInfo.getExtraKeyPersons()) {
                totalFederalSummary = totalFederalSummary.add(keyPersonInfo.getCompensation().getFundsRequested().bigDecimalValue());
                totalNonFederalSummary = totalNonFederalSummary.add(keyPersonInfo.getCompensation().getNonFundsRequested().bigDecimalValue());
            }
            summaryAttachedKey.setFederalSummary(totalFederalSummary);
            summaryAttachedKey.setNonFederalSummary(totalNonFederalSummary);
            summaryAttachedKey.setTotalFedNonFedSummary(totalFederalSummary.add(totalNonFederalSummary));
            keyPersons.setTotalFundForAttachedKeyPersons(summaryAttachedKey);
        }
        if ((extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo)) != null && (attachedFileDataType = this.addAttachedFileType(extraKeyPersonNarr)) != null) {
            keyPersons.setAttachedKeyPersons(attachedFileDataType);
        }
        return keyPersons;
    }

    private KeyPersonCompensationDataType getCompensation(S2SKeyPersonDto keyPerson, int budgetPeriod) {
        KeyPersonCompensationDataType keyPersonCompensation = (KeyPersonCompensationDataType)KeyPersonCompensationDataType.Factory.newInstance();
        if (keyPerson != null) {
            if (keyPerson.getCompensation().getAcademicMonths() != null) {
                keyPersonCompensation.setAcademicMonths(keyPerson.getCompensation().getAcademicMonths().bigDecimalValue());
            }
            if (keyPerson.getCompensation().getCalendarMonths() != null) {
                keyPersonCompensation.setCalendarMonths(keyPerson.getCompensation().getCalendarMonths().bigDecimalValue());
            }
            if (keyPerson.getCompensation().getSummerMonths() != null) {
                keyPersonCompensation.setSummerMonths(keyPerson.getCompensation().getSummerMonths().bigDecimalValue());
            }
            if (keyPerson.getCompensation().getFringe() != null) {
                keyPersonCompensation.setFringeBenefits(((ScaleTwoDecimal)keyPerson.getCompensation().getFringe().add((AbstractDecimal)(keyPerson.getCompensation().getFringeCostSharing() != null ? keyPerson.getCompensation().getFringeCostSharing() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
            }
            if (keyPerson.getCompensation().getRequestedSalary() != null) {
                keyPersonCompensation.setRequestedSalary(((ScaleTwoDecimal)keyPerson.getCompensation().getRequestedSalary().add((AbstractDecimal)(keyPerson.getCompensation().getCostSharingAmount() != null ? keyPerson.getCompensation().getCostSharingAmount() : ScaleTwoDecimal.ZERO))).bigDecimalValue());
            }
            TotalDataType totalDataType = (TotalDataType)TotalDataType.Factory.newInstance();
            if (keyPerson.getCompensation().getFundsRequested() != null) {
                totalDataType.setFederal(keyPerson.getCompensation().getFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getCompensation().getNonFundsRequested() != null) {
                totalDataType.setNonFederal(keyPerson.getCompensation().getNonFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getCompensation().getFundsRequested() != null && keyPerson.getCompensation().getNonFundsRequested() != null) {
                totalDataType.setTotalFedNonFed(((ScaleTwoDecimal)keyPerson.getCompensation().getFundsRequested().add((AbstractDecimal)keyPerson.getCompensation().getNonFundsRequested())).bigDecimalValue());
            }
            keyPersonCompensation.setTotal(totalDataType);
            if (this.pdDoc.getDevelopmentProposal().getBudgets() != null) {
                ScaleTwoDecimal baseSalaryByPeriod = keyPerson.getCompensation().getBaseSalary();
                if (baseSalaryByPeriod != null) {
                    keyPersonCompensation.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                }
            } else if (keyPerson.getCompensation().getBaseSalary() != null) {
                keyPersonCompensation.setBaseSalary(keyPerson.getCompensation().getBaseSalary().bigDecimalValue());
            }
        }
        return keyPersonCompensation;
    }

    @Override
    public RRFedNonFedBudget20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRFedNonFedBudget();
    }

    public S2SPrintingService getS2SPrintingService() {
        return this.s2SPrintingService;
    }

    public void setS2SPrintingService(S2SPrintingService s2SPrintingService) {
        this.s2SPrintingService = s2SPrintingService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public Resource getAdditionalEquipmentAttachmentNonFedStyleSheet() {
        return this.additionalEquipmentAttachmentNonFedStyleSheet;
    }

    public void setAdditionalEquipmentAttachmentNonFedStyleSheet(Resource additionalEquipmentAttachmentNonFedStyleSheet) {
        this.additionalEquipmentAttachmentNonFedStyleSheet = additionalEquipmentAttachmentNonFedStyleSheet;
    }

    public Resource getExtraKeyPersonAttachmentNonFedStyleSheet() {
        return this.extraKeyPersonAttachmentNonFedStyleSheet;
    }

    public void setExtraKeyPersonAttachmentNonFedStyleSheet(Resource extraKeyPersonAttachmentNonFedStyleSheet) {
        this.extraKeyPersonAttachmentNonFedStyleSheet = extraKeyPersonAttachmentNonFedStyleSheet;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRFedNonFedBudget20Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType budgetJustificationAttachment = form.getRRFedNonFedBudget20().getBudgetJustificationAttachment();
            if (budgetJustificationAttachment != null && a.getContentId().equals(budgetJustificationAttachment.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_FedNonFedBudget_2_0_P4.optionalFile", a);
            }
            List<BudgetYearDataType> budgets = form.getRRFedNonFedBudget20().getBudgetYearList();
            if (budgets != null) {
                for (int i = 0; i < budgets.size(); ++i) {
                    BudgetYearDataType budget = budgets.get(i);
                    if (budget == null) continue;
                    BudgetYearDataType.KeyPersons keyPersons = budget.getKeyPersons();
                    if (keyPersons != null && keyPersons.getAttachedKeyPersons() != null && a.getContentId().equals(keyPersons.getAttachedKeyPersons().getFileLocation().getHref())) {
                        return CollectionUtils.entry("RR_FedNonFedBudget_2_0_P1.BudgetYear[" + i + "].P1.optionalFile", a);
                    }
                    BudgetYearDataType.Equipment equipment = budget.getEquipment();
                    if (equipment == null || equipment.getAdditionalEquipmentsAttachment() == null || !a.getContentId().equals(equipment.getAdditionalEquipmentsAttachment().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_FedNonFedBudget_2_0_P1.BudgetYear[" + i + "].P2.optionalFile", a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRFedNonFedBudget20Document> factory() {
        return RRFedNonFedBudget20Document.Factory;
    }
}

