/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardAttachmentContract;
import org.kuali.coeus.propdev.api.budget.subaward.BudgetSubAwardsContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.util.SafeXmlUtils;
import org.kuali.coeus.s2sgen.impl.validate.S2SErrorHandlerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class S2SAdobeFormAttachmentBaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    protected static final String RR_BUDGET_11_NAMESPACE_URI = "http://apply.grants.gov/forms/RR_Budget-V1.1";
    protected static final String LOCAL_NAME = "RR_Budget";
    private static final String SUB_AWARD_BUDGET_NOT_FOUND = "budget.subaward.notfound";
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final String REGEX_TITLE_FILENAME_PATTERN = "([^0-9a-zA-Z\\.\\-_])";
    public final ArrayList<String> attachmentList = new ArrayList();
    public final ArrayList<String> budgetIdList = new ArrayList();
    public final ArrayList<String> budgetSubawardNumberList = new ArrayList();
    @Autowired
    @Qualifier(value="s2SErrorHandlerService")
    protected S2SErrorHandlerService s2SErrorHandlerService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;

    public Document nodeToDom(Node node) throws S2SException {
        try {
            TransformerFactory tf = SafeXmlUtils.safeTransformerFactory();
            Transformer xf = tf.newTransformer();
            DOMResult dr = new DOMResult();
            xf.transform(new DOMSource(node), dr);
            return (Document)dr.getNode();
        }
        catch (TransformerException ex) {
            throw new S2SException(ex.getMessage());
        }
    }

    public Document stringToDom(String xmlSource) throws S2SException {
        StringReader reader = new StringReader(xmlSource);
        try {
            DocumentBuilderFactory factory = SafeXmlUtils.safeDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            reader.close();
            return document;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new S2SException(ex.getMessage(), ex);
            }
        }
    }

    public byte[] docToBytes(Document node) throws S2SException {
        try {
            return this.docToString(node).getBytes(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String docToString(Document node) throws S2SException {
        String string;
        StringWriter writer = new StringWriter();
        try {
            DOMSource domSource = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = SafeXmlUtils.safeTransformerFactory();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new S2SException(e.getMessage(), e);
            }
        }
        writer.close();
        return string;
    }

    protected String prepareAttName(BudgetSubAwardsContract budgetSubAwards) {
        StringBuilder attachmentName = new StringBuilder();
        boolean hasSameFileName = false;
        boolean isAlreadyprinted = false;
        int attachmentCount = 0;
        int suffix = 1;
        int index = 0;
        for (String budgetId : this.budgetIdList) {
            if (budgetSubAwards.getBudgetId().toString().equals(budgetId) && this.budgetSubawardNumberList.get(index).equals(budgetSubAwards.getSubAwardNumber().toString())) {
                this.attachmentList.clear();
                isAlreadyprinted = true;
                break;
            }
            ++index;
        }
        if (isAlreadyprinted) {
            this.budgetIdList.clear();
            this.budgetSubawardNumberList.clear();
        }
        String cleanSubAwardOrganizationName = this.checkAndReplaceInvalidCharacters(budgetSubAwards.getOrganizationName());
        attachmentName.append(cleanSubAwardOrganizationName);
        BudgetContract budget = this.findBudgetFromProposal();
        List budgetSubAwardsList = budget.getBudgetSubAwards();
        ArrayList<String> attachments = new ArrayList<String>();
        for (BudgetSubAwardsContract budgetSubAward : budgetSubAwardsList) {
            StringBuilder existingAttachmentName = new StringBuilder();
            String subAward_OrganizationName = this.checkAndReplaceInvalidCharacters(budgetSubAward.getOrganizationName());
            existingAttachmentName.append(subAward_OrganizationName);
            attachments.add(existingAttachmentName.toString());
        }
        for (String attachment : attachments) {
            if (!attachment.equals(attachmentName.toString())) continue;
            ++attachmentCount;
        }
        if (attachmentCount > 1 && !this.attachmentList.contains(attachmentName.toString())) {
            this.attachmentList.add(attachmentName.toString());
            if (attachmentName.length() > 49) {
                attachmentName.delete(49, attachmentName.length());
            }
            attachmentName.append(1);
            hasSameFileName = true;
        } else {
            for (String attachment : this.attachmentList) {
                if (!attachment.equals(attachmentName.toString())) continue;
                ++suffix;
            }
        }
        if (this.attachmentList.contains(attachmentName.toString()) && !hasSameFileName) {
            this.attachmentList.add(attachmentName.toString());
            if (attachmentName.length() > 49) {
                attachmentName.delete(49, attachmentName.length());
            }
            attachmentName.append(suffix);
        } else {
            this.attachmentList.add(attachmentName.toString());
        }
        this.budgetIdList.add(budgetSubAwards.getBudgetId().toString());
        this.budgetSubawardNumberList.add(budgetSubAwards.getSubAwardNumber().toString());
        return attachmentName.toString();
    }

    public String checkAndReplaceInvalidCharacters(String text) {
        Pattern pattern;
        Matcher matcher;
        String cleanText = text;
        if (text != null && (cleanText = (matcher = (pattern = Pattern.compile(REGEX_TITLE_FILENAME_PATTERN)).matcher(text)).replaceAll(REPLACEMENT_CHARACTER)).length() > 50) {
            cleanText = cleanText.substring(0, 50);
        }
        return cleanText;
    }

    protected void addSubAwdAttachments(BudgetSubAwardsContract budgetSubAwards) {
        List subAwardAttachments = budgetSubAwards.getBudgetSubAwardAttachments();
        for (BudgetSubAwardAttachmentContract budgetSubAwardAttachment : subAwardAttachments) {
            String hash = this.getGrantApplicationHashService().computeAttachmentHash(budgetSubAwardAttachment.getData());
            this.addAttachment(new AttachmentData(budgetSubAwardAttachment.getFileDataId(), budgetSubAwardAttachment.getName(), budgetSubAwardAttachment.getName(), budgetSubAwardAttachment.getData(), budgetSubAwardAttachment.getType(), "SHA-1", hash, budgetSubAwardAttachment.getUploadUser(), budgetSubAwardAttachment.getUploadTimestamp()));
        }
    }

    protected List<BudgetSubAwardsContract> getBudgetSubAwards(ProposalDevelopmentDocumentContract proposalDevelopmentDocument, String namespace, boolean checkNull) {
        List<Object> budgetSubAwardsList = new ArrayList();
        BudgetContract budget = this.findBudgetFromProposal();
        if (budget == null) {
            this.getAuditErrors().add(this.s2SErrorHandlerService.getError(SUB_AWARD_BUDGET_NOT_FOUND, this.getFormName()));
        } else {
            budgetSubAwardsList = this.findBudgetSubawards(namespace, budget, checkNull);
            if (budgetSubAwardsList.isEmpty()) {
                this.getAuditErrors().add(this.s2SErrorHandlerService.getError(SUB_AWARD_BUDGET_NOT_FOUND, this.getFormName()));
            }
        }
        return budgetSubAwardsList;
    }

    private List<BudgetSubAwardsContract> findBudgetSubawards(String namespace, BudgetContract budget, boolean checkNull) {
        ArrayList<BudgetSubAwardsContract> budgetSubAwardsList = new ArrayList<BudgetSubAwardsContract>();
        for (BudgetSubAwardsContract subAwards : budget.getBudgetSubAwards()) {
            if (!StringUtils.equals((CharSequence)namespace, (CharSequence)subAwards.getNamespace()) && (!checkNull || !StringUtils.isBlank((CharSequence)subAwards.getNamespace()))) continue;
            budgetSubAwardsList.add(subAwards);
        }
        return budgetSubAwardsList;
    }

    private BudgetContract findBudgetFromProposal() {
        return this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
    }

    public S2SErrorHandlerService getS2SErrorHandlerService() {
        return this.s2SErrorHandlerService;
    }

    public void setS2SErrorHandlerService(S2SErrorHandlerService s2SErrorHandlerService) {
        this.s2SErrorHandlerService = s2SErrorHandlerService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }
}

