/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf424BV11.AssuranceType;
import gov.grants.apply.forms.sf424BV11.AssurancesDocument;
import gov.grants.apply.forms.sf424BV11.AuthorizedRepresentativeDocument;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424BV1_1Generator")
public class SF424BV1_1Generator
extends SF424BaseGenerator<AssurancesDocument>
implements S2SFormGeneratorPdfFillable<AssurancesDocument> {
    private static final String CORE_SCHEMA_VERSION_1_1 = "1.1";
    @Value(value="http://apply.grants.gov/forms/SF424B-V1.1")
    private String namespace;
    @Value(value="SF424B-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SF424B-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SF424B-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private AssurancesDocument getAssurance() {
        AssurancesDocument assuranceDocument = (AssurancesDocument)AssurancesDocument.Factory.newInstance();
        assuranceDocument.setAssurances(this.getAssuranceType());
        return assuranceDocument;
    }

    private AssuranceType getAssuranceType() {
        AssuranceType assuranceType = (AssuranceType)AssuranceType.Factory.newInstance();
        assuranceType.setFormVersionIdentifier(FormVersion.v1_1.getVersion());
        assuranceType.setProgramType("Non-Construction");
        assuranceType.setCoreSchemaVersion(CORE_SCHEMA_VERSION_1_1);
        DepartmentalPersonDto aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        assuranceType.setAuthorizedRepresentative(this.getAuthorizedRepresentative(aorInfo));
        assuranceType.setSubmittedDate(aorInfo.getSubmittedDate());
        ProposalSiteContract proposalSiteContract = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        assuranceType.setApplicantOrganizationName(StringUtils.substring((String)proposalSiteContract.getLocationName(), (int)0, (int)60));
        return assuranceType;
    }

    private AuthorizedRepresentativeDocument.AuthorizedRepresentative getAuthorizedRepresentative(DepartmentalPersonDto aorInfo) {
        AuthorizedRepresentativeDocument.AuthorizedRepresentative authorizedRepresentative = (AuthorizedRepresentativeDocument.AuthorizedRepresentative)AuthorizedRepresentativeDocument.AuthorizedRepresentative.Factory.newInstance();
        if (aorInfo.getPrimaryTitle() != null) {
            authorizedRepresentative.setRepresentativeTitle(StringUtils.substring((String)aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        authorizedRepresentative.setRepresentativeName(aorInfo.getFullName());
        return authorizedRepresentative;
    }

    @Override
    public AssurancesDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getAssurance();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(AssurancesDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<AssurancesDocument> factory() {
        return AssurancesDocument.Factory;
    }
}

