/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sflll12V12.AwardeeDataType;
import gov.grants.apply.forms.sflll12V12.LobbyingActivitiesDisclosure12Document;
import gov.grants.apply.forms.sflll12V12.ReportDataType;
import gov.grants.apply.forms.sflll12V12.ReportEntityDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SFLLLBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SFLLL1_2V1_2Generator")
public class SFLLL1_2V1_2Generator
extends SFLLLBaseGenerator<LobbyingActivitiesDisclosure12Document>
implements S2SFormGeneratorPdfFillable<LobbyingActivitiesDisclosure12Document> {
    private DepartmentalPersonDto aorInfo;
    @Value(value="http://apply.grants.gov/forms/SFLLL_1_2-V1.2")
    private String namespace;
    @Value(value="SFLLL1_2V1_2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SFLLL_1_2-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SFLLL_1_2-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    private LobbyingActivitiesDisclosure12Document getLobbyingActivitiesDisclosure() {
        LobbyingActivitiesDisclosure12Document lobbyinADDocument = (LobbyingActivitiesDisclosure12Document)LobbyingActivitiesDisclosure12Document.Factory.newInstance();
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12 lobbyingDisclosure = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.Factory.newInstance();
        lobbyingDisclosure.setFormVersion(FormVersion.v1_2.getVersion());
        lobbyingDisclosure.setFederalActionType(LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalActionType.GRANT);
        lobbyingDisclosure.setFederalActionStatus(LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalActionStatus.BID_OFFER);
        lobbyingDisclosure.setReportType(ReportDataType.INITIAL_FILING);
        lobbyingDisclosure.setReportEntity(this.getReportEntity());
        lobbyingDisclosure.setFederalAgencyDepartment("");
        SponsorContract sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            if (sponsor.getSponsorName() != null) {
                lobbyingDisclosure.setFederalAgencyDepartment(StringUtils.substring((String)sponsor.getSponsorName(), (int)0, (int)40));
            }
        } else {
            SponsorContract primeSponsor;
            String primeSponsorCode = this.pdDoc.getDevelopmentProposal().getPrimeSponsor().getSponsorCode();
            if (primeSponsorCode != null && (primeSponsor = this.pdDoc.getDevelopmentProposal().getPrimeSponsor()).getSponsorName() != null) {
                lobbyingDisclosure.setFederalAgencyDepartment(StringUtils.substring((String)primeSponsor.getSponsorName(), (int)0, (int)40));
            }
        }
        lobbyingDisclosure.setFederalProgramName(this.getFedProgramName());
        lobbyingDisclosure.setLobbyingRegistrant(this.getLobbyingRegistrant());
        lobbyingDisclosure.setIndividualsPerformingServices(this.getIndividualsPerformingServices());
        lobbyingDisclosure.setSignatureBlock(this.getSignatureBlock());
        lobbyinADDocument.setLobbyingActivitiesDisclosure12(lobbyingDisclosure);
        return lobbyinADDocument;
    }

    private LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.SignatureBlock getSignatureBlock() {
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.SignatureBlock signatureBlock = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.SignatureBlock)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.SignatureBlock.Factory.newInstance();
        signatureBlock.setName(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            signatureBlock.setTitle(StringUtils.substring((String)this.aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        if (this.aorInfo.getOfficePhone() != null) {
            signatureBlock.setTelephone(StringUtils.substring((String)this.aorInfo.getOfficePhone(), (int)0, (int)25));
        }
        signatureBlock.setSignature(this.aorInfo.getFullName());
        signatureBlock.setSignedDate(this.aorInfo.getSubmittedDate());
        return signatureBlock;
    }

    private LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant getLobbyingRegistrant() {
        RolodexContract rolodex;
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant lobbyingRegistrant = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant.Factory.newInstance();
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        RolodexContract rolodexContract = rolodex = organization != null && organization.getLobbyingRegistrant() != null ? this.rolodexService.getRolodex(organization.getLobbyingRegistrant()) : null;
        if (rolodex != null) {
            HumanNameDataType individualName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant.Address address = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant.Address)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.LobbyingRegistrant.Address.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                individualName.setFirstName(StringUtils.substring((String)rolodex.getFirstName(), (int)0, (int)35));
            }
            if (rolodex.getMiddleName() != null) {
                individualName.setMiddleName(StringUtils.substring((String)rolodex.getMiddleName(), (int)0, (int)25));
            }
            if (rolodex.getLastName() != null) {
                individualName.setLastName(StringUtils.substring((String)rolodex.getLastName(), (int)0, (int)60));
            }
            if (rolodex.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)rolodex.getAddressLine1(), (int)0, (int)55));
            }
            if (rolodex.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)rolodex.getAddressLine2(), (int)0, (int)55));
            }
            if (rolodex.getCity() != null) {
                address.setCity(StringUtils.substring((String)rolodex.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataType(rolodex.getCountryCode(), rolodex.getState()).ifPresent(address::setState);
            address.setZipPostalCode(rolodex.getPostalCode());
            lobbyingRegistrant.setIndividualName(individualName);
            lobbyingRegistrant.setAddress(address);
        } else {
            HumanNameDataType naName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            naName.setFirstName("N/A");
            naName.setLastName("N/A");
            lobbyingRegistrant.setIndividualName(naName);
        }
        return lobbyingRegistrant;
    }

    private LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices getIndividualsPerformingServices() {
        RolodexContract rolodex;
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices individualServices = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Factory.newInstance();
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual individual = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual.Factory.newInstance();
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        RolodexContract rolodexContract = rolodex = organization != null && organization.getLobbyingIndividual() != null ? this.rolodexService.getRolodex(organization.getLobbyingIndividual()) : null;
        if (rolodex != null) {
            HumanNameDataType name = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual.Address address = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual.Address)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual.Address.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                name.setFirstName(StringUtils.substring((String)rolodex.getFirstName(), (int)0, (int)35));
            }
            if (rolodex.getMiddleName() != null) {
                name.setMiddleName(StringUtils.substring((String)rolodex.getMiddleName(), (int)0, (int)25));
            }
            if (rolodex.getLastName() != null) {
                name.setLastName(StringUtils.substring((String)rolodex.getLastName(), (int)0, (int)60));
            }
            if (rolodex.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)rolodex.getAddressLine1(), (int)0, (int)55));
            }
            if (rolodex.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)rolodex.getAddressLine2(), (int)0, (int)55));
            }
            if (rolodex.getCity() != null) {
                address.setCity(StringUtils.substring((String)rolodex.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataType(rolodex.getCountryCode(), rolodex.getState()).ifPresent(address::setState);
            address.setZipPostalCode(rolodex.getPostalCode());
            individual.setName(name);
            individual.setAddress(address);
        } else {
            HumanNameDataType naName = (HumanNameDataType)HumanNameDataType.Factory.newInstance();
            naName.setFirstName("N/A");
            naName.setLastName("N/A");
            individual.setName(naName);
        }
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual[] individualArray = new LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.IndividualsPerformingServices.Individual[]{individual};
        individualServices.setIndividualArray(individualArray);
        return individualServices;
    }

    private LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalProgramName getFedProgramName() {
        String cfdaNumber;
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalProgramName federalProgramName = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalProgramName)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.FederalProgramName.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            federalProgramName.setFederalProgramName(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle(), (int)0, (int)120));
        }
        if ((cfdaNumber = this.getFirstCfdaNumber()) != null) {
            federalProgramName.setCFDANumber(cfdaNumber);
        }
        return federalProgramName;
    }

    private LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.ReportEntity getReportEntity() {
        LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.ReportEntity reportEntity = (LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.ReportEntity)LobbyingActivitiesDisclosure12Document.LobbyingActivitiesDisclosure12.ReportEntity.Factory.newInstance();
        reportEntity.setReportEntityType(ReportEntityDataType.PRIME);
        reportEntity.setReportEntityIsPrime(YesNoDataType.Y_YES);
        AwardeeDataType awardeeDataType = (AwardeeDataType)AwardeeDataType.Factory.newInstance();
        awardeeDataType.setEntityType(ReportEntityDataType.PRIME);
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            if (proposalSite.getLocationName() != null) {
                awardeeDataType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            }
            if (organization.getCongressionalDistrict() != null) {
                awardeeDataType.setCongressionalDistrict(StringUtils.substring((String)organization.getCongressionalDistrict(), (int)0, (int)6));
            }
        }
        AwardeeDataType.Address address = (AwardeeDataType.Address)AwardeeDataType.Address.Factory.newInstance();
        if (proposalSite != null) {
            if (proposalSite.getAddressLine1() != null) {
                address.setStreet1(StringUtils.substring((String)proposalSite.getAddressLine1(), (int)0, (int)55));
            }
            if (proposalSite.getAddressLine2() != null) {
                address.setStreet2(StringUtils.substring((String)proposalSite.getAddressLine2(), (int)0, (int)55));
            }
            if (proposalSite.getCity() != null) {
                address.setCity(StringUtils.substring((String)proposalSite.getCity(), (int)0, (int)35));
            }
            this.globLibV20Generator.getStateCodeDataType(proposalSite.getCountryCode(), proposalSite.getState()).ifPresent(address::setState);
            address.setZipPostalCode(proposalSite.getPostalCode());
        }
        awardeeDataType.setAddress(address);
        reportEntity.setReportingEntity(awardeeDataType);
        return reportEntity;
    }

    @Override
    public LobbyingActivitiesDisclosure12Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        return this.getLobbyingActivitiesDisclosure();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(LobbyingActivitiesDisclosure12Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<LobbyingActivitiesDisclosure12Document> factory() {
        return LobbyingActivitiesDisclosure12Document.Factory;
    }
}

