/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate;

import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.springframework.core.io.Resource;

import java.util.List;

/**
 * 
 * This interface defines the core methods for the Form Generator classes and is meant to be implemented by all generators
 * 
 * @author Kuali Research Administration Team (kualidev@oncourse.iu.edu)
 */
public interface S2SFormGenerator<T extends XmlObject> extends Named, Factory<T> {

    String getNamespace();

    String getFormName();

    int getSortIndex();

    List<Resource> getStylesheets();

    boolean supportsPdfFilling();

    boolean supportsXslTransform();
    /**
     * 
     * This method creates an XML document using the APIs generated using XMLBeans by compiling the form's schema and returns it
     * as XmlObject.
     */
    T getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException;

    List<AttachmentData> getAttachments();

    List<AuditError> getAuditErrors();
}
