/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document;
import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document.NSFCoverPage17;
import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document.NSFCoverPage17.FundingMechanism;
import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document.NSFCoverPage17.NSFUnitConsideration;
import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document.NSFCoverPage17.OtherInfo;
import gov.grants.apply.forms.nsfCoverPage17V17.NSFCoverPage17Document.NSFCoverPage17.PIInfo;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entriesToMap;
import static org.kuali.coeus.s2sgen.impl.util.CollectionUtils.entry;

@FormGenerator("NSFCoverPageV1_7Generator")
public class NSFCoverPageV1_7Generator extends NSFCoverPageBaseGenerator<NSFCoverPage17Document> implements S2SFormGeneratorPdfFillable<NSFCoverPage17Document> {

    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    private static final int GOALI = -1;
    private static final int RAISE = -2;

    @Value("http://apply.grants.gov/forms/NSF_CoverPage_1_7-V1.7")
    private String namespace;

    @Value("NSF_CoverPage_1_7-V1.7")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.7.xsl")
    private List<Resource> stylesheets;

    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_7-V1.7.pdf")
    private Resource pdfForm;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    private NSFCoverPage17Document getNSFCoverPage17() {
        NSFCoverPage17Document nsfCoverPage17Document = NSFCoverPage17Document.Factory.newInstance();
        NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17 = NSFCoverPage17.Factory.newInstance();
        nsfCoverPage17.setFormVersion(FormVersion.v1_7.getVersion());
        setFundingOpportunityNumber(nsfCoverPage17);

        if (pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage17.setDueDate(pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage17.setNSFUnitConsideration(getNSFUnitConsideration());
        setOtherInfo(nsfCoverPage17);
        AttachmentGroupMin1Max100DataType attachmentGroup = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage17.setSingleCopyDocuments(attachmentGroup);
        }
        final AttachedFileDataType dataManagementPlan = getAttachedNarrativeFile(DATA_MANAGEMENT_PLAN);
        if (dataManagementPlan != null) {
            nsfCoverPage17.setDataManagementPlan(dataManagementPlan);
        }

        final AttachedFileDataType mentoringPlan = getAttachedNarrativeFile(MENTORING_PLAN);
        if (mentoringPlan != null) {
            nsfCoverPage17.setMentoringPlan(mentoringPlan);
        }

        final AttachedFileDataType goali = getAttachedNarrativeFile(GOALI);
        if (goali != null) {
            nsfCoverPage17.setGOALILetter(goali);
        }

        final AttachedFileDataType raise = getAttachedNarrativeFile(RAISE);
        if (raise != null) {
            nsfCoverPage17.setRAISEEmails(raise);
        }
        nsfCoverPage17Document.setNSFCoverPage17(nsfCoverPage17);
        return nsfCoverPage17Document;
    }


    private void setFundingOpportunityNumber(NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17) {
        nsfCoverPage17.setFundingOpportunityNumber(StringUtils.substring(pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), 0, PROGRAM_ANNOUNCEMENT_NUMBER_MAX_LENGTH));
    }

    private void setOtherInfo(NSFCoverPage17Document.NSFCoverPage17 nsfCoverPage17) {
        OtherInfo otherInfo = OtherInfo.Factory.newInstance();

        PIInfo pInfo = PIInfo.Factory.newInstance();
        final List<? extends AnswerContract> questionnaireAnswers = getPropDevQuestionAnswerService().getQuestionnaireAnswers(pdDoc.getDevelopmentProposal().getProposalNumber(), getNamespace(), getFormName());
        int unansweredQuestions = questionnaireAnswers.size();

        for (AnswerContract questionnaireAnswer : questionnaireAnswers) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer != null) {
                switch (questionId) {
                    case QUESTION_CURRENT_PI:
                        pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case QUESTION_BEGIN_INVESTIGATOR:
                        otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case QUESTION_ACCOMPLISHMENT_RENEWAL:
                        otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    case FUNDING_MECHANISM_QUESTION:
                        setFundingMechanism(nsfCoverPage17, answer);
                        unansweredQuestions--;
                        break;
                    case LOBBYING_ACTIVITIES_QUESTION:
                        otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                        unansweredQuestions--;
                        break;
                    default:
                        break;
                }
            }
        }
        if (unansweredQuestions != 0) {
            nsfCoverPage17.setPIInfo(null);
            nsfCoverPage17.setOtherInfo(null);
        }
        else {
            nsfCoverPage17.setPIInfo(pInfo);
            nsfCoverPage17.setOtherInfo(otherInfo);
        }
    }

    private void setFundingMechanism(NSFCoverPage17 nsfCoverPage17, String answer) {
        FundingMechanism.Enum fundingMechanism;
        if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.CONFERENCE.toString())) {
            fundingMechanism = FundingMechanism.CONFERENCE;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.RAPID.toString())) {
            fundingMechanism = FundingMechanism.RAPID;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.EAGER.toString())) {
            fundingMechanism = FundingMechanism.EAGER;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.EQUIPMENT.toString())) {
            fundingMechanism = FundingMechanism.EQUIPMENT;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.RAISE.toString())) {
            fundingMechanism = FundingMechanism.RAISE;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.FELLOWSHIP.toString())) {
            fundingMechanism = FundingMechanism.FELLOWSHIP;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.IDEAS_LAB.toString())) {
            fundingMechanism = FundingMechanism.IDEAS_LAB;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.GOALI.toString())) {
            fundingMechanism = FundingMechanism.GOALI;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.FASED.toString())) {
            fundingMechanism = FundingMechanism.FASED;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.TRAVEL.toString())) {
            fundingMechanism = FundingMechanism.TRAVEL;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE.toString())) {
            fundingMechanism = FundingMechanism.CENTER_RESEARCH_INFRASTRUCTURE;
        } else if (StringUtils.equalsIgnoreCase(answer, FundingMechanism.RESEARCH.toString())) {
            fundingMechanism = FundingMechanism.RESEARCH;
        }
        else {
            fundingMechanism = null;
        }
        nsfCoverPage17.setFundingMechanism(fundingMechanism);
    }

    private NSFUnitConsideration getNSFUnitConsideration() {
        NSFUnitConsideration nsfConsideration = NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public NSFCoverPage17Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return getNSFCoverPage17();
    }

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public Attachments getMappedAttachments(NSFCoverPage17Document form, List<AttachmentData> attachments) {
        final Map<Boolean, List<Map.Entry<String, AttachmentData>>> attachmentPartition = attachments.stream().map(a -> {
            if (form.getNSFCoverPage17().getSingleCopyDocuments() != null && form.getNSFCoverPage17().getSingleCopyDocuments().getAttachedFileList() != null) {
                final List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage17().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); i++) {
                    final AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (a.getContentId().equals(attachedFile.getFileLocation().getHref())){
                        return entry("NSF_CoverPage_1_7_P1.optionalFile1_" + i, a);
                    }
                }
            }

            final AttachedFileDataType dataManagementPlanAttachedFile = form.getNSFCoverPage17().getDataManagementPlan();
            if (dataManagementPlanAttachedFile != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_7_P1.optionalFile2", a);
            }

            final AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage17().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_7_P1.optionalFile3", a);
            }

            final AttachedFileDataType goaliLetterAttachedFile = form.getNSFCoverPage17().getGOALILetter();
            if (goaliLetterAttachedFile != null && a.getContentId().equals(goaliLetterAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_7_P1.optionalFile4", a);
            }

            final AttachedFileDataType raiseAttachedFile = form.getNSFCoverPage17().getRAISEEmails();
            if (raiseAttachedFile != null && a.getContentId().equals(raiseAttachedFile.getFileLocation().getHref())) {
                return entry("NSF_CoverPage_1_7_P1.optionalFile5", a);
            }

            return entry((String) null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank(a.getKey())));

        return new Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(entriesToMap()),
                attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage17Document> factory() {
        return NSFCoverPage17Document.Factory;
    }
}
