/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.ProjFieldCodeType;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ApplicationInfoGroup;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.OrganizationType;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.PDMajorField;
import gov.grants.apply.forms.supplementaryCoverSheetforNEHGrantPrograms30V30.SupplementaryCoverSheetforNEHGrantPrograms30Document.SupplementaryCoverSheetforNEHGrantPrograms30.ProjectFundingGroup;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetDto;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.math.BigDecimal;
import java.util.List;


@FormGenerator("SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0Generator")
public class SupplementaryCoverSheetforNEHGrantPrograms_3_0V3_0 extends S2SBaseFormGenerator<SupplementaryCoverSheetforNEHGrantPrograms30Document> {

    private static final int MAJOR_FIELD_OF_STUDY = 1;
    private static final int INSTITUTION_TYPE = 2;
    private static final int FEDERAL_MATCH = 3;
    private static final int NEH_DIVISION = 4;
    private static final int NEH_DIVISION_EXPLANATION = 5;
    private static final int FUNDING = 6;
    private static final int PRIMARY_PROJECT_DISCIPLINE = 7;
    private static final int SECONDARY_PROJECT_DISCIPLINE_EXISTS = 8;
    private static final int SECONDARY_PROJECT_DISCIPLINE = 9;
    private static final int TERTIARY_PROJECT_DISCIPLINE_EXISTS = 10;
    private static final int TERTIARY_PROJECT_DISCIPLINE = 11;

    @Value("http://apply.grants.gov/forms/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0")
    private String namespace;

    @Value("SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0")
    private String formName;

    @FormStylesheet
    @Value("classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0.xsl")
    private List<Resource> stylesheets;

    @Value(DEFAULT_SORT_INDEX)
    private int sortIndex;

    @Autowired
    @Qualifier("s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;

    @Override
    public String getNamespace() {
        return namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public SupplementaryCoverSheetforNEHGrantPrograms30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        this.pdDoc = proposalDevelopmentDocument;

        final SupplementaryCoverSheetforNEHGrantPrograms30Document document = SupplementaryCoverSheetforNEHGrantPrograms30Document.Factory.newInstance();
        final SupplementaryCoverSheetforNEHGrantPrograms30 cs = SupplementaryCoverSheetforNEHGrantPrograms30.Factory.newInstance();
        final ProjectFundingGroup projectFundingGroup = ProjectFundingGroup.Factory.newInstance();
        final ApplicationInfoGroup applicationInfoGroup = ApplicationInfoGroup.Factory.newInstance();

        cs.setFormVersion(FormVersion.v3_0.getVersion());

        final List<? extends AnswerContract> questionnaireAnswers = getPropDevQuestionAnswerService().getQuestionnaireAnswers(pdDoc.getDevelopmentProposal().getProposalNumber(), getNamespace(), getFormName());

        questionnaireAnswers.stream()
                .filter(qa -> qa.getAnswer() != null)
                .forEach(qa -> {
                    final String answer = qa.getAnswer();
                    if (qa.getQuestionNumber() == MAJOR_FIELD_OF_STUDY) {
                        cs.setPDMajorField(PDMajorField.Enum.forString(answer));
                    } else if (qa.getQuestionNumber() == INSTITUTION_TYPE) {
                        cs.setOrganizationType(OrganizationType.Enum.forString(answer));
                    } else if (qa.getQuestionNumber() == FEDERAL_MATCH) {
                        projectFundingGroup.setReqMatchAmount(new BigDecimal(answer));
                    } else if (qa.getQuestionNumber() == NEH_DIVISION) {
                        if (answer.equals(YnqConstant.YES.code())) {
                            applicationInfoGroup.setAdditionalFunding(ApplicationInfoGroup.AdditionalFunding.YES);

                            questionnaireAnswers.stream()
                                    .filter(subQa -> subQa.getAnswer() != null)
                                    .filter(subQa -> subQa.getQuestionNumber() == NEH_DIVISION_EXPLANATION)
                                    .findFirst()
                                    .ifPresent(subQa -> applicationInfoGroup.setAddFundingExplanation(subQa.getAnswer()));
                        } else {
                            applicationInfoGroup.setAdditionalFunding(ApplicationInfoGroup.AdditionalFunding.NO);
                        }
                    } else if (qa.getQuestionNumber() == FUNDING) {
                        if (answer.equals(YnqConstant.YES.code())) {
                            applicationInfoGroup.setTypeofApplication(ApplicationInfoGroup.TypeofApplication.SUPPLEMENT);

                            if (StringUtils.isNotBlank(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorProposalNumber())) {
                                applicationInfoGroup.setSupGrantNumber(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorProposalNumber());
                            }
                        } else {
                            applicationInfoGroup.setTypeofApplication(ApplicationInfoGroup.TypeofApplication.NEW);
                        }
                    } else if (qa.getQuestionNumber() == PRIMARY_PROJECT_DISCIPLINE) {
                        applicationInfoGroup.setProjFieldCode(ProjFieldCodeType.Enum.forString(answer));
                    } else if (qa.getQuestionNumber() == SECONDARY_PROJECT_DISCIPLINE_EXISTS) {
                        if (answer.equals(YnqConstant.YES.code())) {
                            questionnaireAnswers.stream()
                                    .filter(subQa -> subQa.getAnswer() != null)
                                    .filter(subQa -> subQa.getQuestionNumber() == SECONDARY_PROJECT_DISCIPLINE)
                                    .findFirst()
                                    .ifPresent(subQa -> applicationInfoGroup.setProjFieldCode2(ProjFieldCodeType.Enum.forString(subQa.getAnswer())));
                        }
                    } else if (qa.getQuestionNumber() == TERTIARY_PROJECT_DISCIPLINE_EXISTS) {
                        if (answer.equals(YnqConstant.YES.code())) {
                            questionnaireAnswers.stream()
                                    .filter(subQa -> subQa.getAnswer() != null)
                                    .filter(subQa -> subQa.getQuestionNumber() == TERTIARY_PROJECT_DISCIPLINE)
                                    .findFirst()
                                    .ifPresent(subQa -> applicationInfoGroup.setProjFieldCode3(ProjFieldCodeType.Enum.forString(subQa.getAnswer())));
                        }
                    }
                });



        final S2SBudgetDto budgetSummary = s2sBudgetInfoService.getBudgetInfo(pdDoc);

        if (budgetSummary.getCumTotalCosts() != null) {
            projectFundingGroup.setReqOutrightAmount(budgetSummary.getCumTotalCosts().bigDecimalValue());
        }

        final ScaleTwoDecimal totalFromNEH = getTotalFromNeh(projectFundingGroup.getReqMatchAmount(), budgetSummary.getCumTotalCosts());
        if (totalFromNEH != null) {
            projectFundingGroup.setTotalFromNEH(totalFromNEH.bigDecimalValue());
        }

        if (budgetSummary.getCumTotalCostSharing() != null) {
            projectFundingGroup.setCostSharing(budgetSummary.getCumTotalCostSharing().bigDecimalValue());
        }

        final ScaleTwoDecimal totalProject = getTotalProject(budgetSummary.getCumTotalCostSharing(), totalFromNEH);
        if (totalProject != null) {
            projectFundingGroup.setTotalProjectCosts(totalProject.bigDecimalValue());
        }

        cs.setProjectFundingGroup(projectFundingGroup);
        cs.setApplicationInfoGroup(applicationInfoGroup);

        document.setSupplementaryCoverSheetforNEHGrantPrograms30(cs);

        return document;
    }

    private ScaleTwoDecimal getTotalProject(ScaleTwoDecimal cumTotalCostSharing, ScaleTwoDecimal totalFromNEH) {
        final ScaleTwoDecimal totalProject;
        if (totalFromNEH != null && cumTotalCostSharing != null) {
            totalProject = totalFromNEH.add(cumTotalCostSharing);
        } else if (totalFromNEH != null) {
            totalProject = totalFromNEH;
        } else {
            totalProject = cumTotalCostSharing;
        }
        return totalProject;
    }

    private ScaleTwoDecimal getTotalFromNeh(BigDecimal reqMatchAmount, ScaleTwoDecimal cumTotalCosts) {
        final ScaleTwoDecimal totalFromNEH;
        if (cumTotalCosts != null && reqMatchAmount != null) {
            totalFromNEH = cumTotalCosts.add(new ScaleTwoDecimal(reqMatchAmount));
        } else if (reqMatchAmount != null) {
            totalFromNEH = new ScaleTwoDecimal(reqMatchAmount);
        } else {
            totalFromNEH = cumTotalCosts;
        }
        return totalFromNEH;
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    @Override
    public DocumentFactory<SupplementaryCoverSheetforNEHGrantPrograms30Document> factory() {
        return SupplementaryCoverSheetforNEHGrantPrograms30Document.Factory;
    }
}
