/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.api.s2s.UserAttachedFormService;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.generate.DynamicForm;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.s2sgen.impl.util.XmlBeansUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="s2SFormGeneratorRetrievalService")
public class S2SFormGeneratorRetrievalServiceImpl
implements S2SFormGeneratorRetrievalService,
InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="userAttachedFormService")
    private UserAttachedFormService userAttachedFormService;
    private Map<String, String> namespaceToGenerator;

    @Override
    public <T extends XmlObject> S2SFormGenerator<T> getS2SGenerator(String namespace) throws S2SException {
        String generatorName = this.namespaceToGenerator.get(namespace);
        if (StringUtils.isNotBlank((CharSequence)generatorName)) {
            try {
                return (S2SFormGenerator)this.applicationContext.getBean(generatorName);
            }
            catch (NoSuchBeanDefinitionException e) {
                throw new S2SException("Generator not found for namespace: " + namespace, (Exception)((Object)e));
            }
        }
        throw new S2SException("Generator not found for namespace: " + namespace);
    }

    @Override
    public final <T extends XmlObject> S2SFormGenerator<T> getS2SGenerator(String namespace, String proposalNumber) throws S2SException {
        S2SFormGenerator supportedFormGenerator;
        try {
            supportedFormGenerator = this.getS2SGenerator(namespace);
        }
        catch (S2SException e) {
            supportedFormGenerator = null;
        }
        S2sUserAttachedFormContract s2sUserAttachedForm = this.getUserAttachedFormService().findFormByProposalNumberAndNamespace(proposalNumber, namespace);
        try {
            S2SFormGenerator formGenerator;
            S2SFormGenerator s2SFormGenerator = formGenerator = s2sUserAttachedForm != null ? (S2SFormGenerator)this.applicationContext.getBean("UserAttachedFormGenerator") : supportedFormGenerator;
            if (formGenerator instanceof DynamicForm) {
                ((DynamicForm)((Object)formGenerator)).setS2sUserAttachedForm(s2sUserAttachedForm);
                ((DynamicForm)((Object)formGenerator)).setSupportedS2SFormGenerator(Optional.ofNullable(supportedFormGenerator));
            }
            return formGenerator;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new S2SException("Generator not found for namespace: " + namespace, (Exception)((Object)e));
        }
    }

    @Override
    public <T extends XmlObject> List<S2SFormGenerator<T>> getS2SGenerators(Set<String> namespaces, String proposalNumber) throws S2SException {
        return namespaces.stream().map(namespace -> this.getS2SGenerator((String)namespace, proposalNumber)).sorted(Comparator.comparingInt(S2SFormGenerator::getSortIndex)).toList();
    }

    @Override
    public <T extends XmlObject> List<S2SFormGenerator<T>> getS2SGenerators() throws S2SException {
        return this.applicationContext.getBeansOfType(S2SFormGenerator.class).values().stream().map(s2SFormGenerator -> s2SFormGenerator).filter(s2SFormGenerator -> !(s2SFormGenerator instanceof DynamicForm)).toList();
    }

    @Override
    public XmlOptions getXmlOptionsPrefixes() {
        return XmlBeansUtils.getXmlOptionsPrefixes();
    }

    public UserAttachedFormService getUserAttachedFormService() {
        return this.userAttachedFormService;
    }

    public void setUserAttachedFormService(UserAttachedFormService userAttachedFormService) {
        this.userAttachedFormService = userAttachedFormService;
    }

    public void afterPropertiesSet() {
        this.namespaceToGenerator = Arrays.stream(this.applicationContext.getBeanNamesForType(S2SFormGenerator.class)).map(beanName -> {
            S2SFormGenerator s2SFormGenerator = (S2SFormGenerator)this.applicationContext.getBean(beanName);
            return !(s2SFormGenerator instanceof DynamicForm) ? CollectionUtils.entry(s2SFormGenerator.getNamespace(), s2SFormGenerator.getBeanName()) : null;
        }).filter(Objects::nonNull).collect(CollectionUtils.entriesToMap());
    }
}

