/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nasaOtherProjectInformationV10.FYDataType;
import gov.grants.apply.forms.nasaOtherProjectInformationV10.NASAOtherProjectInformationDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NASAOtherProjectInformationV1_0Generator")
public class NASAOtherProjectInformationV1_0Generator
extends S2SBaseFormGenerator<NASAOtherProjectInformationDocument>
implements S2SFormGeneratorPdfFillable<NASAOtherProjectInformationDocument> {
    private static final String PRINCIPAL_INVESTIGATOR = "PI";
    private static final String COLLABORATOR_ROLE = "Collaborator";
    private static final String C0_INVESTIGATOR = "Co-I";
    private static final String EQUIPMENT = "Equipment";
    private static final String FACILITY = "Facility";
    private static final Integer HISTORICAL_IMPACT = 106;
    private static final Integer CIVIL_SERVICE_PERSONNEL = 101;
    private static final Integer EXPLATATION = 107;
    private static final Integer INTERNATIONAL_PARTICIPATION = 108;
    private static final Integer INTERNATIONAL_PARTICIPATION_SUPPORT = 109;
    private static final Integer FTE = 104;
    private static final Integer FISCAL_YEAR = 103;
    private static final int PROGRAM_SPECIFIC_DATA = 47;
    private static final int APPENDICES = 48;
    private static final int NON_US_ORGANIZATION_LETTERS_OF_ENDORSEMENT = 49;
    private static final int NARRATIVE_IRB_ACUC_LETTERS = 50;
    private static final int MAX_EXPLANATION_LENGTH = 2000;
    private static final String NOT_ANSWERED = "No";
    private static final int FISCAL_YEAR_2006 = 2006;
    private static final int FISCAL_YEAR_2007 = 2007;
    private static final int FISCAL_YEAR_2008 = 2008;
    private static final int FISCAL_YEAR_2009 = 2009;
    private static final int FISCAL_YEAR_2010 = 2010;
    private static final int FISCAL_YEAR_2011 = 2011;
    private static final int FISCAL_YEAR_2012 = 2012;
    private static final int FISCAL_YEAR_2013 = 2013;
    private static final int FISCAL_YEAR_2014 = 2014;
    private static final int FISCAL_YEAR_2015 = 2015;
    private static final int FISCAL_YEAR_2016 = 2016;
    private static final int FISCAL_YEAR_2017 = 2017;
    private static final int FISCAL_YEAR_2018 = 2018;
    private static final int FISCAL_YEAR_2019 = 2019;
    private static final int FISCAL_YEAR_2020 = 2020;
    private static final int FISCAL_YEAR_2021 = 2021;
    private static final int FISCAL_YEAR_1 = 0;
    private static final int FISCAL_YEAR_2 = 1;
    private static final int FISCAL_YEAR_3 = 2;
    private static final int FISCAL_YEAR_4 = 3;
    private static final int FISCAL_YEAR_5 = 4;
    private static final int FISCAL_YEAR_6 = 5;
    @Value(value="http://apply.grants.gov/forms/NASA_OtherProjectInformation-V1.0")
    private String namespace;
    @Value(value="NASA_OtherProjectInformation-V1.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NASA_OtherProjectInformation-V1.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NASA_OtherProjectInformation-V1.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;
    List<? extends AnswerHeaderContract> answerHeaders;

    private NASAOtherProjectInformationDocument getNasaOtherProjectInformation() {
        NASAOtherProjectInformationDocument nasaOtherInformationDocument = (NASAOtherProjectInformationDocument)NASAOtherProjectInformationDocument.Factory.newInstance();
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation nasaOtherProjectInformation = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.Factory.newInstance();
        nasaOtherProjectInformation.setFormVersion(FormVersion.v1_0.getVersion());
        nasaOtherProjectInformation.setNASACivilServicePersonnel(this.getNasaCivilServicePersonnel());
        nasaOtherProjectInformation.setHistoricImpact(this.getHistoricImpact());
        nasaOtherProjectInformation.setInternationalParticipation(this.getInternationalParticipation());
        nasaOtherInformationDocument.setNASAOtherProjectInformation(nasaOtherProjectInformation);
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 47 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            nasaOtherProjectInformation.setPSDataAttach(attachedFileDataType);
            break;
        }
        AttachmentGroupMin0Max100DataType attachmentAppendix = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentAppendix.setAttachedFileArray(this.getAppendixFileDataTypes());
        nasaOtherProjectInformation.setAppendAttach(attachmentAppendix);
        AttachmentGroupMin0Max100DataType attachmentEndorsement = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentEndorsement.setAttachedFileArray(this.getEndorsementFileDataTypes());
        nasaOtherProjectInformation.setLetterEndorsAttach(attachmentEndorsement);
        AttachmentGroupMin0Max100DataType attachmentIRBACUC = (AttachmentGroupMin0Max100DataType)AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachmentIRBACUC.setAttachedFileArray(this.getIRBACUCLettersFileDataTypes());
        nasaOtherProjectInformation.setIRBACUCLettersAttach(attachmentIRBACUC);
        nasaOtherInformationDocument.setNASAOtherProjectInformation(nasaOtherProjectInformation);
        return nasaOtherInformationDocument;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel getNasaCivilServicePersonnel() {
        FYDataType.Enum fyscalYear;
        String fiscalYear;
        String fte;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel nasaCivilServicePersonnel = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.Factory.newInstance();
        String answerDetails = this.getAnswer(CIVIL_SERVICE_PERSONNEL, this.answerHeaders);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            nasaCivilServicePersonnel.setCivilServicePersonnel(answer);
        }
        List<String> fteAnswerDetails = this.getAnswerList(FTE);
        List<String> fiscalYearDetails = this.getAnswerList(FISCAL_YEAR);
        if (fteAnswerDetails.size() > 0) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE1 fyfte1 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE1)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE1.Factory.newInstance();
            fte = fteAnswerDetails.get(0);
            BigDecimal fte1 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte1.setFTE1(fte1);
            if (fiscalYearDetails.size() > 0) {
                fiscalYear = fiscalYearDetails.get(0);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte1.setFY1(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE1(fyfte1);
            }
        } else if (answerDetails != null && answerDetails.equals(YnqConstant.YES.code())) {
            nasaCivilServicePersonnel.setFYFTE1(null);
        }
        if (fteAnswerDetails.size() > 1) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE2 fyfte2 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE2)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE2.Factory.newInstance();
            fte = fteAnswerDetails.get(1);
            BigDecimal fte2 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte2.setFTE2(fte2);
            if (fiscalYearDetails.size() > 1) {
                fiscalYear = fiscalYearDetails.get(1);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte2.setFY2(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE2(fyfte2);
            }
        }
        if (fteAnswerDetails.size() > 2) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE3 fyfte3 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE3)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE3.Factory.newInstance();
            fte = fteAnswerDetails.get(2);
            BigDecimal fte3 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte3.setFTE3(fte3);
            if (fiscalYearDetails.size() > 2) {
                fiscalYear = fiscalYearDetails.get(2);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte3.setFY3(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE3(fyfte3);
            }
        }
        if (fteAnswerDetails.size() > 3) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE4 fyfte4 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE4)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE4.Factory.newInstance();
            fte = fteAnswerDetails.get(3);
            BigDecimal fte4 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte4.setFTE4(fte4);
            if (fiscalYearDetails.size() > 3) {
                fiscalYear = fiscalYearDetails.get(3);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte4.setFY4(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE4(fyfte4);
            }
        }
        if (fteAnswerDetails.size() > 4) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE5 fyfte5 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE5)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE5.Factory.newInstance();
            fte = fteAnswerDetails.get(4);
            BigDecimal fte5 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte5.setFTE5(fte5);
            if (fiscalYearDetails.size() > 4) {
                fiscalYear = fiscalYearDetails.get(4);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte5.setFY5(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE5(fyfte5);
            }
        }
        if (fteAnswerDetails.size() > 5) {
            NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE6 fyfte6 = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE6)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.NASACivilServicePersonnel.FYFTE6.Factory.newInstance();
            fte = fteAnswerDetails.get(5);
            BigDecimal fte6 = BigDecimal.valueOf(Double.parseDouble(fte));
            fyfte6.setFTE6(fte6);
            if (fiscalYearDetails.size() > 5) {
                fiscalYear = fiscalYearDetails.get(5);
                fyscalYear = this.getFisaclYear(fiscalYear);
                fyfte6.setFY6(fyscalYear);
                nasaCivilServicePersonnel.setFYFTE6(fyfte6);
            }
        }
        if (fteAnswerDetails.size() != fiscalYearDetails.size()) {
            nasaCivilServicePersonnel.setFYFTE1(null);
        }
        return nasaCivilServicePersonnel;
    }

    private FYDataType.Enum getFisaclYear(String fiscalYear) {
        FYDataType.Enum fyscalYear = null;
        switch (Integer.parseInt(fiscalYear)) {
            case 2006: {
                fyscalYear = FYDataType.X_2006;
                break;
            }
            case 2007: {
                fyscalYear = FYDataType.X_2007;
                break;
            }
            case 2008: {
                fyscalYear = FYDataType.X_2008;
                break;
            }
            case 2009: {
                fyscalYear = FYDataType.X_2009;
                break;
            }
            case 2010: {
                fyscalYear = FYDataType.X_2010;
                break;
            }
            case 2011: {
                fyscalYear = FYDataType.X_2011;
                break;
            }
            case 2012: {
                fyscalYear = FYDataType.X_2012;
                break;
            }
            case 2013: {
                fyscalYear = FYDataType.X_2013;
                break;
            }
            case 2014: {
                fyscalYear = FYDataType.X_2014;
                break;
            }
            case 2015: {
                fyscalYear = FYDataType.X_2015;
                break;
            }
            case 2016: {
                fyscalYear = FYDataType.X_2016;
                break;
            }
            case 2017: {
                fyscalYear = FYDataType.X_2017;
                break;
            }
            case 2018: {
                fyscalYear = FYDataType.X_2018;
                break;
            }
            case 2019: {
                fyscalYear = FYDataType.X_2019;
                break;
            }
            case 2020: {
                fyscalYear = FYDataType.X_2020;
                break;
            }
            case 2021: {
                fyscalYear = FYDataType.X_2021;
            }
        }
        return fyscalYear;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact getHistoricImpact() {
        String childAnswerrDetails;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact historicImpact = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.HistoricImpact.Factory.newInstance();
        String answerDetails = this.getAnswer(HISTORICAL_IMPACT, this.answerHeaders);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            historicImpact.setHistoricImpactQ(answer);
        }
        if ((childAnswerrDetails = this.getChildQuestionAnswer(HISTORICAL_IMPACT, EXPLATATION, this.answerHeaders)) != null && !childAnswerrDetails.equals(NOT_ANSWERED)) {
            if (childAnswerrDetails.length() > 2000) {
                historicImpact.setHistoricImpactEx(childAnswerrDetails.substring(0, 2000));
            } else {
                historicImpact.setHistoricImpactEx(childAnswerrDetails);
            }
        } else if (answerDetails != null && answerDetails.equals(YnqConstant.YES.code())) {
            historicImpact.setHistoricImpactEx(null);
        }
        return historicImpact;
    }

    private NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation getInternationalParticipation() {
        List<String> answerList;
        String childAnswerDetails;
        NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation inParticipation = (NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation)NASAOtherProjectInformationDocument.NASAOtherProjectInformation.InternationalParticipation.Factory.newInstance();
        String answerDetails = this.getAnswer(INTERNATIONAL_PARTICIPATION, this.answerHeaders);
        if (answerDetails != null && !answerDetails.equals(NOT_ANSWERED)) {
            YesNoDataType.Enum answer = answerDetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            inParticipation.setInternationalParticipationQ(answer);
        }
        if ((childAnswerDetails = this.getChildQuestionAnswer(INTERNATIONAL_PARTICIPATION, EXPLATATION, this.answerHeaders)) != null) {
            if (inParticipation.getInternationalParticipationQ() != null && ((Object)((Object)inParticipation.getInternationalParticipationQ())).equals((Object)YesNoDataType.Y_YES)) {
                if (childAnswerDetails.length() > 2000) {
                    inParticipation.setInternationalParticipatioEx(childAnswerDetails.substring(0, 2000));
                } else {
                    inParticipation.setInternationalParticipatioEx(childAnswerDetails);
                }
            }
        } else if (answerDetails != null && answerDetails.equals(YnqConstant.YES.code())) {
            inParticipation.setInternationalParticipatioEx(null);
        }
        if ((answerList = this.getAnswerList(INTERNATIONAL_PARTICIPATION_SUPPORT)).size() > 0) {
            if (answerList.contains(PRINCIPAL_INVESTIGATOR)) {
                inParticipation.setInternationalParticipationPI(YesNoDataType.Y_YES);
            }
            if (answerList.contains(C0_INVESTIGATOR)) {
                inParticipation.setInternationalParticipationCoI(YesNoDataType.Y_YES);
            }
            if (answerList.contains(COLLABORATOR_ROLE)) {
                inParticipation.setInternationalParticipationCollaborator(YesNoDataType.Y_YES);
            }
            if (answerList.contains(EQUIPMENT)) {
                inParticipation.setInternationalParticipationEquipment(YesNoDataType.Y_YES);
            }
            if (answerList.contains(FACILITY)) {
                inParticipation.setInternationalParticipationFacility(YesNoDataType.Y_YES);
            }
        } else if (answerDetails != null && answerDetails.equals(YnqConstant.YES.code())) {
            inParticipation.setInternationalParticipationPI(null);
        }
        return inParticipation;
    }

    private List<String> getAnswerList(Integer questionSeqId) {
        ArrayList<String> answerList = new ArrayList<String>();
        for (AnswerHeaderContract answerHeaderContract : this.answerHeaders) {
            List answerDetails = answerHeaderContract.getAnswers();
            for (AnswerContract answers : answerDetails) {
                if (!questionSeqId.equals(this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId()) || answers.getAnswer() == null) continue;
                answerList.add(answers.getAnswer());
            }
        }
        return answerList;
    }

    private AttachedFileDataType[] getAppendixFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 48 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    private AttachedFileDataType[] getEndorsementFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 49 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    private AttachedFileDataType[] getIRBACUCLettersFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 50 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public NASAOtherProjectInformationDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        return this.getNasaOtherProjectInformation();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NASAOtherProjectInformationDocument form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType attachedFile;
            int i;
            String contentId = a.getContentId();
            if (form.getNASAOtherProjectInformation().getPSDataAttach() != null && contentId.equals(form.getNASAOtherProjectInformation().getPSDataAttach().getFileLocation().getHref())) {
                return CollectionUtils.entry("NASA_OtherProjectInformation_P2.optionalFile0", a);
            }
            if (form.getNASAOtherProjectInformation().getAppendAttach() != null && form.getNASAOtherProjectInformation().getAppendAttach().getAttachedFileList() != null) {
                List<AttachedFileDataType> appendAttachedFileList = form.getNASAOtherProjectInformation().getAppendAttach().getAttachedFileList();
                for (i = 0; i < appendAttachedFileList.size(); ++i) {
                    attachedFile = appendAttachedFileList.get(i);
                    if (!contentId.equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NASA_OtherProjectInformation_P2.optionalFile_1_" + i, a);
                }
            }
            if (form.getNASAOtherProjectInformation().getLetterEndorsAttach() != null && form.getNASAOtherProjectInformation().getLetterEndorsAttach().getAttachedFileList() != null) {
                List<AttachedFileDataType> letterEndorsAttachedFileList = form.getNASAOtherProjectInformation().getLetterEndorsAttach().getAttachedFileList();
                for (i = 0; i < letterEndorsAttachedFileList.size(); ++i) {
                    attachedFile = letterEndorsAttachedFileList.get(i);
                    if (!contentId.equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NASA_OtherProjectInformation_P2.optionalFile_2_" + i, a);
                }
            }
            if (form.getNASAOtherProjectInformation().getIRBACUCLettersAttach() != null && form.getNASAOtherProjectInformation().getIRBACUCLettersAttach().getAttachedFileList() != null) {
                List<AttachedFileDataType> irbACUCLettersAttachedFileList = form.getNASAOtherProjectInformation().getIRBACUCLettersAttach().getAttachedFileList();
                for (i = 0; i < irbACUCLettersAttachedFileList.size(); ++i) {
                    attachedFile = irbACUCLettersAttachedFileList.get(i);
                    if (!contentId.equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NASA_OtherProjectInformation_P2.optionalFile_3_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NASAOtherProjectInformationDocument> factory() {
        return NASAOtherProjectInformationDocument.Factory;
    }
}

