/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPageV11.DegreeTypeDataType;
import gov.grants.apply.forms.nsfCoverPageV11.NSFCoverPageDocument;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.type.ProposalTypeContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonYnqContract;
import org.kuali.coeus.propdev.api.ynq.ProposalYnqContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_1Generator")
public class NSFCoverPageV1_1Generator
extends NSFCoverPageBaseGenerator<NSFCoverPageDocument> {
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage-V1.1")
    private String namespace;
    @Value(value="NSF_CoverPage-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;
    private static final String QUESTION_ID_ACCOMPLISHMENT_RENEWAL = "5";
    private static final String QUESTION_ID_ISCURRENT_PI = "19";
    private static final int PROGRAM_ANNOUNCEMENT_NUMBER_MAX_LENGTH = 40;
    private static final DegreeTypeDataType.Enum DEFAULT_DEGREE_TYPE = DegreeTypeDataType.UKNW_NO_DEGREE_INFORMATION_SPECIFIED;

    private NSFCoverPageDocument getNSFCoverPage() {
        NSFCoverPageDocument nsfCoverPageDocument = (NSFCoverPageDocument)NSFCoverPageDocument.Factory.newInstance();
        NSFCoverPageDocument.NSFCoverPage nsfCoverPage = (NSFCoverPageDocument.NSFCoverPage)NSFCoverPageDocument.NSFCoverPage.Factory.newInstance();
        nsfCoverPage.setFormVersion(FormVersion.v1_1.getVersion());
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().length() > 40) {
                nsfCoverPage.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().substring(0, 40));
            } else {
                nsfCoverPage.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
            }
        }
        nsfCoverPage.setNSFUnitConsideration(this.getNSFUnitConsideration());
        nsfCoverPage.setPIInfo(this.getPIInfo());
        nsfCoverPage.setCoPIInfo(this.getCoPI());
        nsfCoverPage.setOtherInfo(this.getOtherInfo());
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        nsfCoverPage.setSingleCopyDocuments(attachmentGroup);
        nsfCoverPageDocument.setNSFCoverPage(nsfCoverPage);
        return nsfCoverPageDocument;
    }

    private NSFCoverPageDocument.NSFCoverPage.PIInfo getPIInfo() {
        NSFCoverPageDocument.NSFCoverPage.PIInfo pInfo = (NSFCoverPageDocument.NSFCoverPage.PIInfo)NSFCoverPageDocument.NSFCoverPage.PIInfo.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            for (ProposalPersonDegreeContract personDegree : PI.getProposalPersonDegrees()) {
                DegreeTypeDataType.Enum degreeType = DEFAULT_DEGREE_TYPE;
                if (personDegree.getDegreeType() != null && personDegree.getDegreeType().getCode() != null) {
                    StringBuilder degreeTypeDetail = new StringBuilder();
                    degreeTypeDetail.append(personDegree.getDegreeType().getCode());
                    degreeTypeDetail.append(": ");
                    degreeTypeDetail.append(personDegree.getDegreeType().getDescription());
                    degreeType = DegreeTypeDataType.Enum.forString(degreeTypeDetail.toString());
                    if (degreeType == null) {
                        degreeType = DEFAULT_DEGREE_TYPE;
                    }
                } else {
                    degreeType = DEFAULT_DEGREE_TYPE;
                }
                pInfo.setDegreeType(degreeType);
                if (personDegree.getGraduationYear() == null) continue;
                pInfo.setDegreeYear(this.getYearAsCalendar(personDegree.getGraduationYear()));
            }
            pInfo.setIsCurrentPI(this.getYNQAnswer(QUESTION_ID_ISCURRENT_PI));
        }
        return pInfo;
    }

    private NSFCoverPageDocument.NSFCoverPage.CoPIInfo getCoPI() {
        NSFCoverPageDocument.NSFCoverPage.CoPIInfo coPIInfo = (NSFCoverPageDocument.NSFCoverPage.CoPIInfo)NSFCoverPageDocument.NSFCoverPage.CoPIInfo.Factory.newInstance();
        int count = 0;
        ProposalPersonContract coInvestigator = null;
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            ++count;
        }
        NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI[] coPIArray = new NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI[count];
        count = 0;
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            coInvestigator = proposalPerson;
            NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI coPI = (NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI)NSFCoverPageDocument.NSFCoverPage.CoPIInfo.CoPI.Factory.newInstance();
            coPI.setName(this.globLibV20Generator.getHumanNameDataType(coInvestigator));
            for (ProposalPersonDegreeContract personDegree : coInvestigator.getProposalPersonDegrees()) {
                DegreeTypeDataType.Enum degreeType = DEFAULT_DEGREE_TYPE;
                if (personDegree != null && personDegree.getDegreeType() != null && personDegree.getDegreeType().getCode() != null) {
                    StringBuilder degreeTypeDetail = new StringBuilder();
                    degreeTypeDetail.append(personDegree.getDegreeType().getCode());
                    degreeTypeDetail.append(": ");
                    degreeTypeDetail.append(personDegree.getDegreeType().getDescription());
                    degreeType = DegreeTypeDataType.Enum.forString(degreeTypeDetail.toString());
                    if (degreeType == null) {
                        degreeType = DEFAULT_DEGREE_TYPE;
                    }
                }
                coPI.setDegreeType(degreeType);
                if (personDegree.getGraduationYear() == null) continue;
                coPI.setDegreeYear(this.getYearAsCalendar(personDegree.getGraduationYear()));
            }
            coPIArray[count] = coPI;
            ++count;
        }
        coPIInfo.setCoPIArray(coPIArray);
        return coPIInfo;
    }

    private NSFCoverPageDocument.NSFCoverPage.OtherInfo getOtherInfo() {
        ProposalTypeContract proposalType;
        NSFCoverPageDocument.NSFCoverPage.OtherInfo otherInfo = (NSFCoverPageDocument.NSFCoverPage.OtherInfo)NSFCoverPageDocument.NSFCoverPage.OtherInfo.Factory.newInstance();
        YesNoDataType.Enum yesNoDataType = this.getYNQAnswer("12");
        if (yesNoDataType != null) {
            otherInfo.setIsBeginInvestigator(yesNoDataType);
        }
        if ((yesNoDataType = this.getLobbyingAnswer()) != null) {
            otherInfo.setIsDisclosureLobbyingActivities(yesNoDataType);
        }
        if ((yesNoDataType = this.getYNQAnswer("14")) != null) {
            otherInfo.setIsExploratoryResearch(yesNoDataType);
        }
        if ((yesNoDataType = this.getYNQAnswer("G6")) != null) {
            otherInfo.setIsHistoricPlaces(yesNoDataType);
        }
        if ((proposalType = this.pdDoc.getDevelopmentProposal().getProposalType()) != null && proposalType.getCode() != null) {
            otherInfo.setIsAccomplishmentRenewal(proposalType.getCode().equals(QUESTION_ID_ACCOMPLISHMENT_RENEWAL) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
        }
        if ((yesNoDataType = this.getYNQAnswer("20")) != null) {
            otherInfo.setIsHighResolutionGraphics(yesNoDataType);
        }
        return otherInfo;
    }

    private YesNoDataType.Enum getYNQAnswer(String questionId) {
        YesNoDataType.Enum answer = null;
        for (ProposalYnqContract proposalYnq : this.pdDoc.getDevelopmentProposal().getProposalYnqs()) {
            if (proposalYnq.getYnq() == null || !proposalYnq.getYnq().getQuestionId().equals(questionId) || proposalYnq.getAnswer() == null) continue;
            answer = proposalYnq.getAnswer().equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        }
        return answer;
    }

    private YesNoDataType.Enum getLobbyingAnswer() {
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if ((proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("PI")) && !"COI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            for (ProposalPersonYnqContract personYnq : proposalPerson.getProposalPersonYnqs()) {
                if (personYnq == null || personYnq.getQuestionId() == null || !personYnq.getQuestionId().equals("-10088") || personYnq.getAnswer() == null || !personYnq.getAnswer().equals(YnqConstant.YES.code())) continue;
                return YesNoDataType.Y_YES;
            }
        }
        return answer;
    }

    private NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration nsfConsideration = (NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration)NSFCoverPageDocument.NSFCoverPage.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public NSFCoverPageDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<NSFCoverPageDocument> factory() {
        return NSFCoverPageDocument.Factory;
    }
}

