/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage16V16.NSFCoverPage16Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_6Generator")
public class NSFCoverPageV1_6Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage16Document>
implements S2SFormGeneratorPdfFillable<NSFCoverPage16Document> {
    private static final int MENTORING_PLAN = 147;
    private static final int DATA_MANAGEMENT_PLAN = 146;
    private static final int LOBBYING_ACTIVITIES_QUESTION = 11;
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_1_6-V1.6")
    private String namespace;
    @Value(value="NSF_CoverPage_1_6-V1.6")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.6.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_CoverPage_1_6-V1.6.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private NSFCoverPage16Document getNSFCoverPage16() {
        AttachedFileDataType mentoringPlan;
        AttachedFileDataType dataManagementPlan;
        NSFCoverPage16Document nsfCoverPage16Document = (NSFCoverPage16Document)NSFCoverPage16Document.Factory.newInstance();
        NSFCoverPage16Document.NSFCoverPage16 nsfCoverPage16 = (NSFCoverPage16Document.NSFCoverPage16)NSFCoverPage16Document.NSFCoverPage16.Factory.newInstance();
        nsfCoverPage16.setFormVersion(FormVersion.v1_6.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage16);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage16.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage16.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage16);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage16.setSingleCopyDocuments(attachmentGroup);
        }
        if ((dataManagementPlan = this.getAttachedNarrativeFile(146)) != null) {
            nsfCoverPage16.setDataManagementPlan(dataManagementPlan);
        }
        if ((mentoringPlan = this.getAttachedNarrativeFile(147)) != null) {
            nsfCoverPage16.setMentoringPlan(mentoringPlan);
        }
        nsfCoverPage16Document.setNSFCoverPage16(nsfCoverPage16);
        return nsfCoverPage16Document;
    }

    private void setFundingOpportunityNumber(NSFCoverPage16Document.NSFCoverPage16 nsfCoverPage16) {
        nsfCoverPage16.setFundingOpportunityNumber(StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber(), (int)0, (int)40));
    }

    private void setOtherInfo(NSFCoverPage16Document.NSFCoverPage16 nsfCoverPage16) {
        NSFCoverPage16Document.NSFCoverPage16.OtherInfo otherInfo = (NSFCoverPage16Document.NSFCoverPage16.OtherInfo)NSFCoverPage16Document.NSFCoverPage16.OtherInfo.Factory.newInstance();
        NSFCoverPage16Document.NSFCoverPage16.PIInfo pInfo = (NSFCoverPage16Document.NSFCoverPage16.PIInfo)NSFCoverPage16Document.NSFCoverPage16.PIInfo.Factory.newInstance();
        for (AnswerContract questionnaireAnswer : this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 10: {
                    this.setFundingMechanism(nsfCoverPage16, answer);
                    break;
                }
                case 11: {
                    otherInfo.setIsDisclosureLobbyingActivities(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
            }
        }
        nsfCoverPage16.setPIInfo(pInfo);
        nsfCoverPage16.setOtherInfo(otherInfo);
    }

    private void setFundingMechanism(NSFCoverPage16Document.NSFCoverPage16 nsfCoverPage16, String answer) {
        NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.Enum fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.RAPID;
        if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.CONFERENCE.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.CONFERENCE;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.EAGER.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.EAGER;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.EQUIPMENT.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.EQUIPMENT;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.FACILITY_CENTER.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.FACILITY_CENTER;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.FELLOWSHIP.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.FELLOWSHIP;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.IDEAS_LAB.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.IDEAS_LAB;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.INTERNATIONAL_TRAVEL.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.INTERNATIONAL_TRAVEL;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)answer, (CharSequence)NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.RESEARCH_OTHER_THAN_RAPID_OR_EAGER.toString())) {
            fundingMechanism = NSFCoverPage16Document.NSFCoverPage16.FundingMechanism.RESEARCH_OTHER_THAN_RAPID_OR_EAGER;
        }
        nsfCoverPage16.setFundingMechanism(fundingMechanism);
    }

    private NSFCoverPage16Document.NSFCoverPage16.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage16Document.NSFCoverPage16.NSFUnitConsideration nsfConsideration = (NSFCoverPage16Document.NSFCoverPage16.NSFUnitConsideration)NSFCoverPage16Document.NSFCoverPage16.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public NSFCoverPage16Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage16();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFCoverPage16Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType dataManagementPlanAttachedFile;
            if (form.getNSFCoverPage16().getSingleCopyDocuments() != null && form.getNSFCoverPage16().getSingleCopyDocuments().getAttachedFileList() != null) {
                List<AttachedFileDataType> attachedFileList = form.getNSFCoverPage16().getSingleCopyDocuments().getAttachedFileList();
                for (int i = 0; i < attachedFileList.size(); ++i) {
                    AttachedFileDataType attachedFile = attachedFileList.get(i);
                    if (!a.getContentId().equals(attachedFile.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_CoverPage_1_6_P1.optionalFile1_" + i, a);
                }
            }
            if ((dataManagementPlanAttachedFile = form.getNSFCoverPage16().getDataManagementPlan()) != null && a.getContentId().equals(dataManagementPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_6_P1.optionalFile2", a);
            }
            AttachedFileDataType mentoringPlanAttachedFile = form.getNSFCoverPage16().getMentoringPlan();
            if (mentoringPlanAttachedFile != null && a.getContentId().equals(mentoringPlanAttachedFile.getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_CoverPage_1_6_P1.optionalFile3", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFCoverPage16Document> factory() {
        return NSFCoverPage16Document.Factory;
    }
}

