/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrOtherProjectInfoV11.RROtherProjectInfoDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RROtherProjectInfoBaseGenerator;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RROtherProjectInfoV1_1Generator")
public class RROtherProjectInfoV1_1Generator
extends RROtherProjectInfoBaseGenerator<RROtherProjectInfoDocument>
implements S2SFormGeneratorPdfFillable<RROtherProjectInfoDocument> {
    @Value(value="http://apply.grants.gov/forms/RR_OtherProjectInfo-V1.1")
    private String namespace;
    @Value(value="RR_OtherProjectInfo-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_OtherProjectInfo-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_OtherProjectInfo-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="140")
    private int sortIndex;
    private static final Logger LOG = LogManager.getLogger(RROtherProjectInfoV1_1Generator.class);
    List<? extends AnswerHeaderContract> answerHeaders;

    private RROtherProjectInfoDocument getRROtherProjectInfo() {
        LOG.info("Inside RROtherProjectInfo");
        RROtherProjectInfoDocument rrOtherProjectInfoDocument = (RROtherProjectInfoDocument)RROtherProjectInfoDocument.Factory.newInstance();
        RROtherProjectInfoDocument.RROtherProjectInfo rrOtherProjectInfo = (RROtherProjectInfoDocument.RROtherProjectInfo)RROtherProjectInfoDocument.RROtherProjectInfo.Factory.newInstance();
        rrOtherProjectInfo.setFormVersion(FormVersion.v1_1.getVersion());
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        this.setHumanSubjAndVertebrateAnimals(rrOtherProjectInfo);
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        String answerExplanation = " ";
        RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact environmentalImpact = (RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact)RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact.Factory.newInstance();
        RROtherProjectInfoDocument.RROtherProjectInfo.InternationalActivities internationalActivities = (RROtherProjectInfoDocument.RROtherProjectInfo.InternationalActivities)RROtherProjectInfoDocument.RROtherProjectInfo.InternationalActivities.Factory.newInstance();
        String propertyInformationAnswer = this.getAnswer(PROPRIETARY_INFORMATION_INDICATOR, this.answerHeaders);
        if (propertyInformationAnswer != null && !propertyInformationAnswer.equals("No")) {
            answer = YnqConstant.YES.code().equals(propertyInformationAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            rrOtherProjectInfo.setProprietaryInformationIndicator(answer);
        } else {
            rrOtherProjectInfo.setProprietaryInformationIndicator(null);
        }
        String environmentalImpactAnswer = this.getAnswer(ENVIRONMENTAL_IMPACT_YNQ, this.answerHeaders);
        answer = YnqConstant.YES.code().equals(environmentalImpactAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_IMPACT_YNQ, EXPLANATION, this.answerHeaders);
        environmentalImpact.setEnvironmentalImpactIndicator(answer);
        if (environmentalImpactAnswer != null && !environmentalImpactAnswer.equals("No")) {
            if (answerExplanation != null) {
                environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation);
            } else {
                environmentalImpact.setEnvironmentalImpactIndicator(YesNoDataType.N_NO);
            }
        } else {
            environmentalImpact.setEnvironmentalImpactIndicator(null);
        }
        if (YnqConstant.YES.code().equals(environmentalImpactAnswer) && answerExplanation == null) {
            environmentalImpact.setEnvironmentalImpactExplanation(answerExplanation);
        }
        if (((Object)((Object)answer)).equals((Object)YesNoDataType.Y_YES)) {
            answerExplanation = this.getChildQuestionAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, EXPLANATION, this.answerHeaders);
            String ynqAnswer = this.getAnswer(ENVIRONMENTAL_EXEMPTION_YNQ, this.answerHeaders);
            answer = YnqConstant.YES.code().equals(ynqAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact.EnvironmentalExemption environmentalExemption = (RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact.EnvironmentalExemption)RROtherProjectInfoDocument.RROtherProjectInfo.EnvironmentalImpact.EnvironmentalExemption.Factory.newInstance();
            if (ynqAnswer != null && !ynqAnswer.equals("No")) {
                if (!YnqConstant.NA.code().equals(ynqAnswer)) {
                    environmentalExemption.setEnvironmentalExemptionIndicator(answer);
                    if (YnqConstant.YES.code().equals(ynqAnswer)) {
                        environmentalExemption.setEnvironmentalExemptionExplanation(answerExplanation);
                    }
                }
            } else {
                environmentalExemption.setEnvironmentalExemptionIndicator(null);
            }
            environmentalImpact.setEnvironmentalExemption(environmentalExemption);
        }
        rrOtherProjectInfo.setEnvironmentalImpact(environmentalImpact);
        String internationalActivitiesAnswer = this.getAnswer(INTERNATIONAL_ACTIVITIES_YNQ, this.answerHeaders);
        if (internationalActivitiesAnswer != null && !internationalActivitiesAnswer.equals("No")) {
            answer = YnqConstant.YES.code().equals(internationalActivitiesAnswer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            answerExplanation = this.getAnswer(INTERNATIONAL_ACTIVITIES_EXPL, this.answerHeaders);
            internationalActivities.setInternationalActivitiesIndicator(answer);
            if (answerExplanation != null && !answerExplanation.equals("No")) {
                internationalActivities.setActivitiesPartnershipsCountries(answerExplanation);
                if (this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders) != null) {
                    internationalActivities.setInternationalActivitiesExplanation(this.getChildQuestionAnswer(INTERNATIONAL_ACTIVITIES_YNQ, EXPLANATION, this.answerHeaders));
                }
            }
            if (YnqConstant.YES.code().equals(internationalActivitiesAnswer) && answerExplanation == null) {
                internationalActivities.setActivitiesPartnershipsCountries(answerExplanation);
            }
        } else {
            internationalActivities.setInternationalActivitiesIndicator(null);
        }
        rrOtherProjectInfo.setInternationalActivities(internationalActivities);
        this.setAttachments(rrOtherProjectInfo);
        rrOtherProjectInfoDocument.setRROtherProjectInfo(rrOtherProjectInfo);
        return rrOtherProjectInfoDocument;
    }

    private void setAttachments(RROtherProjectInfoDocument.RROtherProjectInfo rrOtherProjectInfo) {
        Boolean isOtherAttachmentsExists = false;
        RROtherProjectInfoDocument.RROtherProjectInfo.ProjectNarrativeAttachments projectNarrativeAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.ProjectNarrativeAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.ProjectNarrativeAttachments.Factory.newInstance();
        RROtherProjectInfoDocument.RROtherProjectInfo.AbstractAttachments abstractAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.AbstractAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.AbstractAttachments.Factory.newInstance();
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null) continue;
            switch (Integer.parseInt(narrative.getNarrativeType().getCode())) {
                case 3: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfoDocument.RROtherProjectInfo.EquipmentAttachments equipmentAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.EquipmentAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.EquipmentAttachments.Factory.newInstance();
                    equipmentAttachments.setEquipmentAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setEquipmentAttachments(equipmentAttachments);
                    break;
                }
                case 2: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfoDocument.RROtherProjectInfo.FacilitiesAttachments facilitiesAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.FacilitiesAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.FacilitiesAttachments.Factory.newInstance();
                    facilitiesAttachments.setFacilitiesAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setFacilitiesAttachments(facilitiesAttachments);
                    break;
                }
                case 1: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    projectNarrativeAttachments.setProjectNarrativeAttachment(attachedFileDataType);
                    break;
                }
                case 4: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    RROtherProjectInfoDocument.RROtherProjectInfo.BibliographyAttachments bibliographyAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.BibliographyAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.BibliographyAttachments.Factory.newInstance();
                    bibliographyAttachments.setBibliographyAttachment(attachedFileDataType);
                    rrOtherProjectInfo.setBibliographyAttachments(bibliographyAttachments);
                    break;
                }
                case 5: {
                    AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    abstractAttachments.setAbstractAttachment(attachedFileDataType);
                    break;
                }
                case 8: 
                case 15: {
                    isOtherAttachmentsExists = true;
                }
            }
        }
        rrOtherProjectInfo.setProjectNarrativeAttachments(projectNarrativeAttachments);
        rrOtherProjectInfo.setAbstractAttachments(abstractAttachments);
        if (isOtherAttachmentsExists.booleanValue()) {
            this.setOtherAttachments(rrOtherProjectInfo);
        }
    }

    private void setOtherAttachments(RROtherProjectInfoDocument.RROtherProjectInfo rrOtherProjectInfo) {
        RROtherProjectInfoDocument.RROtherProjectInfo.OtherAttachments otherAttachments = (RROtherProjectInfoDocument.RROtherProjectInfo.OtherAttachments)RROtherProjectInfoDocument.RROtherProjectInfo.OtherAttachments.Factory.newInstance();
        otherAttachments.setOtherAttachmentArray(this.getAttachedFileDataTypes());
        rrOtherProjectInfo.setOtherAttachments(otherAttachments);
    }

    private void setHumanSubjAndVertebrateAnimals(RROtherProjectInfoDocument.RROtherProjectInfo rrOtherProjectInfo) {
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.N_NO);
        rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.N_NO);
        for (ProposalSpecialReviewContract proposalSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (proposalSpecialReview.getSpecialReviewType() == null) continue;
            if ("1".equals(proposalSpecialReview.getSpecialReviewType().getCode())) {
                RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement humanSubjectsSupplement = this.getHumanSubjectsIndicator(rrOtherProjectInfo, proposalSpecialReview);
                if (organization != null && organization.getHumanSubAssurance() != null) {
                    humanSubjectsSupplement.setHumanSubjectAssuranceNumber(organization.getHumanSubAssurance().substring(3));
                }
                if (humanSubjectsSupplement == null) continue;
                rrOtherProjectInfo.setHumanSubjectsSupplement(humanSubjectsSupplement);
                continue;
            }
            if (!"2".equals(proposalSpecialReview.getSpecialReviewType().getCode())) continue;
            rrOtherProjectInfo.setVertebrateAnimalsIndicator(YesNoDataType.Y_YES);
            RROtherProjectInfoDocument.RROtherProjectInfo.VertebrateAnimalsSupplement vertebrateAnimalsSupplement = (RROtherProjectInfoDocument.RROtherProjectInfo.VertebrateAnimalsSupplement)RROtherProjectInfoDocument.RROtherProjectInfo.VertebrateAnimalsSupplement.Factory.newInstance();
            if ("1".equals(proposalSpecialReview.getApprovalType().getCode())) {
                vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.Y_YES);
            } else {
                vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCReviewIndicator(YesNoDataType.N_NO);
                if (proposalSpecialReview.getApprovalDate() != null) {
                    vertebrateAnimalsSupplement.setVertebrateAnimalsIACUCApprovalDateReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
                }
            }
            if (organization != null && organization.getHumanSubAssurance() != null) {
                vertebrateAnimalsSupplement.setAssuranceNumber(organization.getAnimalWelfareAssurance());
            }
            rrOtherProjectInfo.setVertebrateAnimalsSupplement(vertebrateAnimalsSupplement);
        }
    }

    private RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement getHumanSubjectsIndicator(RROtherProjectInfoDocument.RROtherProjectInfo rrOtherProjectInfo, ProposalSpecialReviewContract proposalSpecialReview) {
        rrOtherProjectInfo.setHumanSubjectsIndicator(YesNoDataType.Y_YES);
        RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement humanSubjectsSupplement = (RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement)RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.Factory.newInstance();
        RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers exemptionNumbers = (RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers)RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers.Factory.newInstance();
        if (proposalSpecialReview.getApprovalType() != null) {
            if (Integer.parseInt(proposalSpecialReview.getApprovalType().getCode()) == 4 && proposalSpecialReview.getSpecialReviewExemptions() != null) {
                exemptionNumbers.setExemptionNumberArray((RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[])proposalSpecialReview.getSpecialReviewExemptions().stream().filter(Objects::nonNull).map(e -> e.getExemptionType().getCode()).map(Integer::parseInt).filter(c -> c > 0 && c < 7).map(RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum::forInt).toArray(RROtherProjectInfoDocument.RROtherProjectInfo.HumanSubjectsSupplement.ExemptionNumbers.ExemptionNumber.Enum[]::new));
                humanSubjectsSupplement.setExemptionNumbers(exemptionNumbers);
            }
            if ("1".equals(proposalSpecialReview.getApprovalType().getCode()) || "3".equals(proposalSpecialReview.getApprovalType().getCode())) {
                humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.Y_YES);
            } else {
                humanSubjectsSupplement.setHumanSubjectIRBReviewIndicator(YesNoDataType.N_NO);
                if (proposalSpecialReview.getApprovalDate() != null) {
                    humanSubjectsSupplement.setHumanSubjectIRBReviewDate(this.s2SDateTimeService.convertDateToCalendar(proposalSpecialReview.getApprovalDate()));
                }
            }
        }
        return humanSubjectsSupplement;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        LOG.info("Getting AttachedFileDataType ");
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 8 && Integer.parseInt(narrative.getNarrativeType().getCode()) != 15) continue;
            attachedFileDataType = this.addAttachedFileType(narrative);
            if (attachedFileDataType != null) {
                attachedFileDataTypeList.add(attachedFileDataType);
            }
            LOG.info("Attachmentcount" + attachedFileDataTypeList.size());
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public RROtherProjectInfoDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRROtherProjectInfo();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RROtherProjectInfoDocument form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            RROtherProjectInfoDocument.RROtherProjectInfo.AbstractAttachments abstractAttachments = form.getRROtherProjectInfo().getAbstractAttachments();
            if (abstractAttachments != null && abstractAttachments.getAbstractAttachment() != null && a.getContentId().equals(abstractAttachments.getAbstractAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_P1.mandatoryFile0", a);
            }
            RROtherProjectInfoDocument.RROtherProjectInfo.ProjectNarrativeAttachments projectNarrativeAttachments = form.getRROtherProjectInfo().getProjectNarrativeAttachments();
            if (projectNarrativeAttachments != null && projectNarrativeAttachments.getProjectNarrativeAttachment() != null && a.getContentId().equals(projectNarrativeAttachments.getProjectNarrativeAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_P1.mandatoryFile1", a);
            }
            RROtherProjectInfoDocument.RROtherProjectInfo.BibliographyAttachments bibliographyAttachments = form.getRROtherProjectInfo().getBibliographyAttachments();
            if (bibliographyAttachments != null && bibliographyAttachments.getBibliographyAttachment() != null && a.getContentId().equals(bibliographyAttachments.getBibliographyAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_P1.optionalFile0", a);
            }
            RROtherProjectInfoDocument.RROtherProjectInfo.FacilitiesAttachments facilitiesAttachments = form.getRROtherProjectInfo().getFacilitiesAttachments();
            if (facilitiesAttachments != null && facilitiesAttachments.getFacilitiesAttachment() != null && a.getContentId().equals(facilitiesAttachments.getFacilitiesAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_P1.optionalFile1", a);
            }
            RROtherProjectInfoDocument.RROtherProjectInfo.EquipmentAttachments equipmentAttachments = form.getRROtherProjectInfo().getEquipmentAttachments();
            if (equipmentAttachments != null && equipmentAttachments.getEquipmentAttachment() != null && a.getContentId().equals(equipmentAttachments.getEquipmentAttachment().getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_OtherProjectInfo_P1.optionalFile2", a);
            }
            RROtherProjectInfoDocument.RROtherProjectInfo.OtherAttachments otherAttachments = form.getRROtherProjectInfo().getOtherAttachments();
            if (otherAttachments != null && otherAttachments.getOtherAttachmentList() != null) {
                List<AttachedFileDataType> atts = otherAttachments.getOtherAttachmentList();
                for (int i = 0; i < atts.size(); ++i) {
                    AttachedFileDataType att = atts.get(i);
                    if (att == null || !a.getContentId().equals(att.getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("RR_OtherProjectInfo_P1.optionalFile3_" + i, a);
                }
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RROtherProjectInfoDocument> factory() {
        return RROtherProjectInfoDocument.Factory;
    }
}

