/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrSF42412V12.AORInfoType;
import gov.grants.apply.forms.rrSF42412V12.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF42412V12.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF42412V12.RRSF42412Document;
import gov.grants.apply.forms.rrSF42412V12.RevisionTypeCodeDataType;
import gov.grants.apply.forms.rrSF42412V12.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF42412V12.SubmissionTypeDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.OrganizationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.RRSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.validate.S2SErrorHandlerService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRSF424V1_2Generator")
public class RRSF424V1_2Generator
extends RRSF424BaseGenerator<RRSF42412Document> {
    private static final String MODULAR_BUDGET_REQUIRED = "s2s.budget.modularbudget.required";
    @Value(value="http://apply.grants.gov/forms/RR_SF424_1_2-V1.2")
    private String namespace;
    @Value(value="RR_SF424_1_2-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SF424-V1.2.xsl")
    private List<Resource> stylesheets;
    @Value(value="120")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SErrorHandlerService")
    protected S2SErrorHandlerService s2SErrorHandlerService;
    private DepartmentalPersonDto departmentalPerson;
    private List<? extends AnswerHeaderContract> answerHeaders;

    private RRSF42412Document getRRSF424() {
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        RRSF42412Document rrSF424Document = (RRSF42412Document)RRSF42412Document.Factory.newInstance();
        RRSF42412Document.RRSF42412 rrsf42412 = (RRSF42412Document.RRSF42412)RRSF42412Document.RRSF42412.Factory.newInstance();
        rrsf42412.setFormVersion(FormVersion.v1_2.getVersion());
        rrsf42412.setSubmittedDate(this.departmentalPerson.getSubmittedDate());
        if (this.getSubmissionTypeCode() != null) {
            rrsf42412.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forInt(Integer.parseInt(this.getSubmissionTypeCode())));
        }
        rrsf42412.setStateID(this.getProposalSiteState());
        rrsf42412.setApplicantInfo(this.getApplicationInfo());
        rrsf42412.setEmployerID(this.getEmployerId());
        rrsf42412.setApplicantType(this.getApplicantType());
        if (this.getAgencyRoutingNumber() != null) {
            rrsf42412.setAgencyRoutingNumber(this.getAgencyRoutingNumber());
        }
        rrsf42412.setApplicationType(this.getApplicationType());
        rrsf42412.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        rrsf42412.setFederalAgencyName(this.getFederalAgencyName());
        rrsf42412.setProjectTitle(this.getProjectTitle());
        rrsf42412.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf42412.setCongressionalDistrict(this.getCongDistrict());
        String cfdaNumber = this.getFirstCfdaNumber();
        if (cfdaNumber != null) {
            rrsf42412.setCFDANumber(cfdaNumber);
        }
        rrsf42412.setActivityTitle(this.getActivityTitle());
        this.setFederalId(rrsf42412);
        rrsf42412.setPDPIContactInfo(this.getPDPI());
        rrsf42412.setEstimatedProjectFunding(this.getProjectFunding());
        rrsf42412.setTrustAgree(YesNoDataType.Y_YES);
        rrsf42412.setStateReview(this.getStateReview());
        rrsf42412.setAORInfo(this.getAORInfoType());
        rrsf42412.setAORSignature(this.getAORSignature());
        rrsf42412.setAORSignedDate(this.departmentalPerson.getSubmittedDate());
        this.setPreApplicationAttachment(rrsf42412);
        this.setSFLLLAttachment(rrsf42412);
        rrSF424Document.setRRSF42412(rrsf42412);
        return rrSF424Document;
    }

    private RRSF42412Document.RRSF42412.EstimatedProjectFunding getProjectFunding() {
        RRSF42412Document.RRSF42412.EstimatedProjectFunding funding = (RRSF42412Document.RRSF42412.EstimatedProjectFunding)RRSF42412Document.RRSF42412.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalNonfedrequested(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        boolean hasBudgetLineItem = false;
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
            if (budget.getModularBudgetFlag().booleanValue()) {
                List allModularAmounts = this.modularBudgetService.getModularBudgetAmounts((BudgetContract)budget);
                ScaleTwoDecimal fundsRequested = ScaleTwoDecimal.ZERO;
                ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
                for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                    BudgetModularContract modularAmounts = this.modularBudgetService.getModularBudgetForPeriod(allModularAmounts, budgetPeriod);
                    if (modularAmounts == null) {
                        this.getAuditErrors().add(this.s2SErrorHandlerService.getError(MODULAR_BUDGET_REQUIRED, this.getFormName()));
                        break;
                    }
                    totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)modularAmounts.getTotalDirectCost());
                    for (BudgetModularIdcContract budgetModularIdc : modularAmounts.getBudgetModularIdcs()) {
                        fundsRequested = (ScaleTwoDecimal)fundsRequested.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)totalDirectCost);
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)fundsRequested);
            } else {
                totalCost = budget.getTotalCost();
            }
            ScaleTwoDecimal fedNonFedCost = totalCost;
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)costSharingAmount);
            funding = (RRSF42412Document.RRSF42412.EstimatedProjectFunding)RRSF42412Document.RRSF42412.EstimatedProjectFunding.Factory.newInstance();
            funding.setTotalEstimatedAmount(totalCost.bigDecimalValue());
            funding.setTotalNonfedrequested(costSharingAmount.bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(this.getTotalProjectIncome((BudgetContract)budget));
        }
        return funding;
    }

    private BigDecimal getTotalProjectIncome(BudgetContract budget) {
        BigDecimal totalProjectIncome = BigDecimal.ZERO;
        for (BudgetProjectIncomeContract budgetProjectIncome : budget.getBudgetProjectIncomes()) {
            totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
        }
        return totalProjectIncome;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo getApplicationInfo() {
        RRSF42412Document.RRSF42412.ApplicantInfo appInfo = (RRSF42412Document.RRSF42412.ApplicantInfo)RRSF42412Document.RRSF42412.ApplicantInfo.Factory.newInstance();
        appInfo.setContactPersonInfo(this.getContactPersonInfo());
        appInfo.setOrganizationInfo(this.getOrganizationDataType());
        return appInfo;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo getContactPersonInfo() {
        String contactType = this.getContactType();
        RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo)RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        if (contactType.equals("I")) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                contactInfo = this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex());
            }
        } else {
            DepartmentalPersonDto depPerson = this.getContactPerson(this.pdDoc);
            if (depPerson != null) {
                contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (StringUtils.isNotEmpty((CharSequence)depPerson.getFaxNumber())) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
            }
        }
        return contactInfo;
    }

    private OrganizationDataType getOrganizationDataType() {
        UnitContract leadUnit;
        OrganizationDataType orgType = (OrganizationDataType)OrganizationDataType.Factory.newInstance();
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        orgType.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)proposalSite));
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            orgType.setDUNSID(organization.getDunsNumber());
        }
        if ((leadUnit = this.pdDoc.getDevelopmentProposal().getOwnedByUnit()) != null) {
            orgType.setDepartmentName(this.getDepartmentName(this.pdDoc.getDevelopmentProposal().getOwnedByUnit()));
            String divisionName = this.s2sDivisionService.getDivisionFromUnit(leadUnit.getUnitNumber());
            if (divisionName != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        return orgType;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo getContactInfo(RolodexContract rolodex) {
        RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo)RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(rolodex));
        contactInfo.setPhone("");
        if (rolodex != null) {
            contactInfo.setPhone(rolodex.getPhoneNumber());
            if (StringUtils.isNotEmpty((CharSequence)rolodex.getFaxNumber())) {
                contactInfo.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getEmailAddress() != null) {
                contactInfo.setEmail(rolodex.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF42412Document.RRSF42412.StateReview getStateReview() {
        RRSF42412Document.RRSF42412.StateReview stateReview = (RRSF42412Document.RRSF42412.StateReview)RRSF42412Document.RRSF42412.StateReview.Factory.newInstance();
        Map<String, String> eoStateReview = this.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.Y_YES;
            String stateReviewDate = eoStateReview.get("reviewDate");
            Calendar reviewDate = this.s2SDateTimeService.convertDateStringToCalendar(stateReviewDate);
            stateReview.setStateReviewDate(reviewDate);
        } else if ("N".equals(strReview)) {
            String stateReviewData = eoStateReview.get("stateReviewData");
            if ("Not Covered".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if ("Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        return stateReview;
    }

    private RRSF42412Document.RRSF42412.ApplicationType getApplicationType() {
        RRSF42412Document.RRSF42412.ApplicationType applicationType = (RRSF42412Document.RRSF42412.ApplicationType)RRSF42412Document.RRSF42412.ApplicationType.Factory.newInstance();
        Map<String, String> submissionInfo = this.getSubmissionType(this.pdDoc);
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(this.getApplicationTypeCodeDataType());
            if (submissionInfo.get("revisionCode") != null) {
                String revisionCode = submissionInfo.get("revisionCode");
                RevisionTypeCodeDataType.Enum revisionCodeApplication = RevisionTypeCodeDataType.Enum.forString(revisionCode);
                applicationType.setRevisionCode(revisionCodeApplication);
            }
            if (submissionInfo.get("revisionOtherDescription") != null) {
                String revisionCodeOtherDesc = submissionInfo.get("revisionOtherDescription");
                applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherDesc);
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
            this.setProposalApplicationType(proposalTypeCode, applicationType);
        }
        this.setOtherAgencySubmissionDetails(applicationType);
        return applicationType;
    }

    private void setProposalApplicationType(String proposalTypeCode, RRSF42412Document.RRSF42412.ApplicationType applicationType) {
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(1));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(5));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(3));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(2));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(4));
        }
    }

    private void setOtherAgencySubmissionDetails(RRSF42412Document.RRSF42412.ApplicationType applicationType) {
        Object answer = null;
        String answerdetails = this.getAnswer(ANSWER_128, this.answerHeaders);
        if (answerdetails != null && !answerdetails.equals("No")) {
            answer = answerdetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            applicationType.setIsOtherAgencySubmission((YesNoDataType.Enum)((Object)answer));
        } else {
            applicationType.setIsOtherAgencySubmission(null);
        }
        if (answer != null && answer.equals((Object)YesNoDataType.Y_YES)) {
            applicationType.setOtherAgencySubmissionExplanation(this.getOtherAgencySubmissionExplanation());
        }
    }

    private ApplicationTypeCodeDataType.Enum getApplicationTypeCodeDataType() {
        return ApplicationTypeCodeDataType.Enum.forInt(Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalType().getCode()));
    }

    private RRSF42412Document.RRSF42412.ProposedProjectPeriod getProjectPeriod() {
        RRSF42412Document.RRSF42412.ProposedProjectPeriod proposedProjectPeriod = (RRSF42412Document.RRSF42412.ProposedProjectPeriod)RRSF42412Document.RRSF42412.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF42412Document.RRSF42412.CongressionalDistrict getCongDistrict() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        RRSF42412Document.RRSF42412.CongressionalDistrict congressionalDistrict = (RRSF42412Document.RRSF42412.CongressionalDistrict)RRSF42412Document.RRSF42412.CongressionalDistrict.Factory.newInstance();
        if (applicantOrganization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = (OrganizationContactPersonDataType)OrganizationContactPersonDataType.Factory.newInstance();
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            ProposalPersonContract PI = proposalPerson;
            ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
            PDPI2.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (StringUtils.isNotEmpty((CharSequence)PI.getFaxNumber())) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)PI));
            this.setDirectoryTitle(PDPI2, PI);
            this.setDepartmentName(PDPI2, PI);
            this.setDivisionName(PDPI2, PI);
            if (applicantOrganization == null) continue;
            PDPI2.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return PDPI2;
    }

    private void setDivisionName(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        String divisionName = this.s2sDivisionService.getDivision(PI);
        if (divisionName != null) {
            PDPI2.setDivisionName(divisionName);
        }
    }

    private void setDepartmentName(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        if (PI.getHomeUnit() != null) {
            PDPI2.setDepartmentName(this.getDepartmentName(PI.getPerson()));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            PDPI2.setDepartmentName(this.getDepartmentName(developmentProposal.getOwnedByUnit()));
        }
    }

    private void setDirectoryTitle(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                PDPI2.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private AORInfoType getAORInfoType() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        AORInfoType aorInfoType = (AORInfoType)AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.globLibV20Generator.getHumanNameDataType(this.departmentalPerson));
            this.setTitle(aorInfoType);
            this.setAddress(aorInfoType);
            this.setDivisionName(aorInfoType, this.departmentalPerson);
        }
        if (applicantOrganization != null) {
            aorInfoType.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return aorInfoType;
    }

    private void setTitle(AORInfoType aorInfoType) {
        if (this.departmentalPerson.getPrimaryTitle() != null) {
            aorInfoType.setTitle(StringUtils.substring((String)this.departmentalPerson.getPrimaryTitle(), (int)0, (int)45));
        } else {
            aorInfoType.setTitle("");
        }
    }

    private void setAddress(AORInfoType aorInfoType) {
        aorInfoType.setAddress(this.globLibV20Generator.getAddressDataType(this.departmentalPerson));
        aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)this.departmentalPerson.getFaxNumber())) {
            aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
        }
        aorInfoType.setDepartmentName(this.getDepartmentName(this.departmentalPerson));
        aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
    }

    private void setDivisionName(AORInfoType aorInfoType, DepartmentalPersonDto departmentalPerson) {
        String divisionName = this.getS2sDivisionService().getDivision(departmentalPerson);
        if (divisionName != null) {
            aorInfoType.setDivisionName(divisionName);
        }
    }

    private RRSF42412Document.RRSF42412.ApplicantType getApplicantType() {
        ApplicantTypeCodeDataType.Enum applicantTypeCode;
        RRSF42412Document.RRSF42412.ApplicantType applicantType = (RRSF42412Document.RRSF42412.ApplicantType)RRSF42412Document.RRSF42412.ApplicantType.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = (RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType)RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = (RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged)RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = (RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned)RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = ((OrganizationTypeContract)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0)).getOrganizationTypeList().getCode();
        }
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            case 100: {
                applicantTypeCode = ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                break;
            }
            case 101: {
                applicantTypeCode = ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                break;
            }
            case 102: {
                applicantTypeCode = ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                break;
            }
            case 103: {
                applicantTypeCode = ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                break;
            }
            case 104: {
                applicantTypeCode = ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                break;
            }
            case 105: {
                applicantTypeCode = ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                break;
            }
            case 106: {
                applicantTypeCode = ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                break;
            }
            case 107: {
                applicantTypeCode = ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        if (orgTypeCode == 3) {
            applicantType.setApplicantTypeCodeOtherExplanation("Federal Government");
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    private String getSubmissionTypeCode() {
        String submissionTypeCode = null;
        S2sOpportunityContract s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionType() != null) {
            submissionTypeCode = s2sOpportunity.getS2sSubmissionType().getCode();
        }
        return submissionTypeCode;
    }

    private String getProposalSiteState() {
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        return proposalSite != null && proposalSite.getState() != null ? proposalSite.getState() : "";
    }

    private void setPreApplicationAttachment(RRSF42412Document.RRSF42412 rrsf42412) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 6 || (preAttachment = this.addAttachedFileType(narrative)) == null) continue;
            rrsf42412.setPreApplicationAttachment(preAttachment);
            break;
        }
    }

    private void setSFLLLAttachment(RRSF42412Document.RRSF42412 rrsf42412) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 86 || (preAttachment = this.addAttachedFileType(narrative)) == null) continue;
            rrsf42412.setSFLLLAttachment(preAttachment);
            break;
        }
    }

    private String getAORSignature() {
        String AORSignature = "";
        if (this.departmentalPerson != null) {
            AORSignature = this.departmentalPerson.getFullName();
        }
        return AORSignature;
    }

    private void setFederalId(RRSF42412Document.RRSF42412 rrsf42412) {
        String federalId = this.getFederalId();
        if (StringUtils.isNotBlank((CharSequence)federalId)) {
            rrsf42412.setFederalID(federalId);
        }
    }

    private String getActivityTitle() {
        String announcementTitle = "";
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
        }
        return announcementTitle;
    }

    private String getProjectTitle() {
        String title = this.pdDoc.getDevelopmentProposal().getTitle();
        if (title != null && title.length() > 200) {
            title = title.substring(0, 200);
        }
        return title;
    }

    private String getAgencyRoutingNumber() {
        return this.pdDoc.getDevelopmentProposal().getAgencyProgramCode();
    }

    @Override
    public RRSF42412Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.departmentalPersonService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424();
    }

    @Override
    protected List<? extends AnswerHeaderContract> getAnswerHeaders() {
        return this.answerHeaders;
    }

    public S2SErrorHandlerService getS2SErrorHandlerService() {
        return this.s2SErrorHandlerService;
    }

    public void setS2SErrorHandlerService(S2SErrorHandlerService s2SErrorHandlerService) {
        this.s2SErrorHandlerService = s2SErrorHandlerService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<RRSF42412Document> factory() {
        return RRSF42412Document.Factory;
    }
}

