/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.print;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.fop.fo.FONode;

public final class FOPUtils {
    private FOPUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String FONodeToString(FONode node) {
        StringBuilder stringBuilder = new StringBuilder();
        FOPUtils.FONodeToStringRecursive(node, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void FONodeToStringRecursive(FONode node, StringBuilder stringBuilder, int indentationLevel) {
        for (int i = 0; i < 2 * indentationLevel; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(node.getName());
        stringBuilder.append(" (");
        stringBuilder.append(node);
        stringBuilder.append(")");
        stringBuilder.append('\n');
        FONode.FONodeIterator i = node.getChildNodes();
        if (i != null) {
            while (i.hasNext()) {
                FONode childNode = i.next();
                FOPUtils.FONodeToStringRecursive(childNode, stringBuilder, indentationLevel + 1);
            }
        }
    }

    public static String FONodeAncestryToString(FONode node) {
        if (node == null) {
            return "";
        }
        ArrayList<FONode> ancestry = new ArrayList<FONode>();
        ancestry.add(node);
        while ((node = node.getParent()) != null) {
            ancestry.add(node);
        }
        Collections.reverse(ancestry);
        StringBuilder stringBuilder = new StringBuilder();
        for (int ancestorIndex = 0; ancestorIndex < ancestry.size(); ++ancestorIndex) {
            for (int i = 0; i < 2 * ancestorIndex; ++i) {
                stringBuilder.append(' ');
            }
            FONode ancestor = (FONode)ancestry.get(ancestorIndex);
            stringBuilder.append(ancestor.getName());
            stringBuilder.append(" (");
            stringBuilder.append(ancestor);
            stringBuilder.append(")");
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

