/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.external.award.AwardAccountValidationService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AwardAccountValidationServiceImpl
implements AwardAccountValidationService {
    private static final String AWARD_EFFECTIVE_DATE_NOT_SPECIFIED = "error.award.createAccount.invalid.effectiveDate";
    private static final String AWARD_ID_NOT_SPECIFIED = "error.award.createAccount.invalid.awardId";
    private static final String AWARD_END_DATE_NOT_SPECIFIED = "error.award.createAccount.invalid.endDate";
    private static final String AWARD_ACTIVITY_TYPE_CODE = "error.award.createAccount.invalid.activityTypeCode";
    private static final String AWARD_PAYMENT_BASIS_NOT_SPECIFIED = "error.award.createAccount.invalid.paymentBasis";
    private static final String AWARD_PAYMENT_METHOD_NOT_SPECIFIED = "error.award.createAccount.invalid.paymentMethod";
    private static final String AWARD_ADDRESS_NOT_COMPLETE = "error.award.createAccount.invalid.piAddress";
    private static final String AWARD_PI_NOT_SPECIFIED = "error.award.createAccount.invalid.pi";
    private static final String AWARD_F_AND_A_RATE_NOT_SPECIFIED = "error.award.createAccount.invalid.rate";
    private static final String AWARD_ACCOUNT_EMPTY = "error.award.createAccount.account.number.empty";
    private static final String AWARD_ACCOUNT_IN_USE = "error.award.createAccount.account.number.inuse";
    private AwardAccountService awardAccountService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public boolean validateAwardAccountDetails(Award award) {
        boolean rulePassed = true;
        rulePassed &= this.isValidEffectiveDate(award);
        rulePassed &= this.isValidExpenseGuidelineText(award);
        rulePassed &= this.isValidExpirationDate(award);
        rulePassed &= this.isValidHigherEducationCode(award);
        rulePassed &= this.isValidPaymentBasis(award);
        rulePassed &= this.isValidPaymentMethod(award);
        rulePassed &= this.isValidAddress(award);
        rulePassed &= this.isValidFandarate(award);
        return rulePassed &= this.isNonNullAccountNumber(award);
    }

    protected boolean isValidAddress(Award award) {
        boolean isValid = true;
        if (ObjectUtils.isNull((Object)award.getPrincipalInvestigator())) {
            GlobalVariables.getMessageMap().putError(AWARD_PI_NOT_SPECIFIED, AWARD_PI_NOT_SPECIFIED, new String[0]);
            isValid = false;
        } else {
            KcPerson principalInvestigator = award.getPrincipalInvestigator().getPerson();
            if (ObjectUtils.isNotNull((Object)principalInvestigator)) {
                String streetAddress = principalInvestigator.getAddressLine1();
                String cityName = principalInvestigator.getCity();
                String stateCode = principalInvestigator.getState();
                String postalCode = principalInvestigator.getPostalCode();
                if (StringUtils.isBlank((CharSequence)streetAddress) || StringUtils.isBlank((CharSequence)cityName) || StringUtils.isBlank((CharSequence)stateCode) || StringUtils.isBlank((CharSequence)postalCode)) {
                    GlobalVariables.getMessageMap().putError(AWARD_ADDRESS_NOT_COMPLETE, AWARD_ADDRESS_NOT_COMPLETE, new String[0]);
                    isValid = false;
                }
            } else {
                GlobalVariables.getMessageMap().putError(AWARD_ADDRESS_NOT_COMPLETE, AWARD_ADDRESS_NOT_COMPLETE, new String[0]);
                isValid = false;
            }
        }
        return isValid;
    }

    protected boolean isValidFandarate(Award award) {
        List<AwardFandaRate> rates = award.getAwardFandaRate();
        boolean isValid = true;
        if (!this.getAwardAccountService().isFinancialRestApiEnabled() && (ObjectUtils.isNull(rates) || rates.size() == 0)) {
            GlobalVariables.getMessageMap().putError(AWARD_F_AND_A_RATE_NOT_SPECIFIED, AWARD_F_AND_A_RATE_NOT_SPECIFIED, new String[0]);
            isValid = false;
        }
        return isValid;
    }

    protected boolean isValidPaymentBasis(Award award) {
        if (award.getBasisOfPaymentCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_PAYMENT_BASIS_NOT_SPECIFIED, AWARD_PAYMENT_BASIS_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidPaymentMethod(Award award) {
        if (award.getMethodOfPaymentCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_PAYMENT_METHOD_NOT_SPECIFIED, AWARD_PAYMENT_METHOD_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidHigherEducationCode(Award award) {
        if (award.getActivityTypeCode() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_ACTIVITY_TYPE_CODE, AWARD_ACTIVITY_TYPE_CODE, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidEffectiveDate(Award award) {
        if (award.getAwardEffectiveDate() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_EFFECTIVE_DATE_NOT_SPECIFIED, AWARD_EFFECTIVE_DATE_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidExpenseGuidelineText(Award award) {
        if (award.getAwardId() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_ID_NOT_SPECIFIED, AWARD_ID_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidExpirationDate(Award award) {
        if (award.getProjectEndDate() == null) {
            GlobalVariables.getMessageMap().putError(AWARD_END_DATE_NOT_SPECIFIED, AWARD_END_DATE_NOT_SPECIFIED, new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isNonNullAccountNumber(Award award) {
        if (StringUtils.isNotBlank((CharSequence)award.getAccountNumber())) {
            return true;
        }
        GlobalVariables.getMessageMap().putError(AWARD_ACCOUNT_EMPTY, AWARD_ACCOUNT_EMPTY, new String[0]);
        return false;
    }

    public AwardAccountService getAwardAccountService() {
        return KcServiceLocator.getService(AwardAccountService.class);
    }
}

