/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.data.migration;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MigrationUtils {
    private static final Logger LOG = LogManager.getLogger(MigrationUtils.class);
    public static final String MYSQL_PRODUCT = "MySQL";
    public static final String MARIADB_PRODUCT = "MariaDB";
    public static final String ORACLE_PRODUCT = "ORACLE";

    public static DatabaseType getDatabaseTypeFromConnection(Connection conn) {
        String dbProduct;
        try {
            dbProduct = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        LOG.info("database product: " + dbProduct);
        if (MigrationUtils.isMysqlConnection(dbProduct)) {
            return DatabaseType.Mysql;
        }
        if (MigrationUtils.isOracleConnection(dbProduct)) {
            return DatabaseType.Oracle;
        }
        return DatabaseType.Unsupported;
    }

    public static boolean isMysqlConnection(String productName) {
        return MYSQL_PRODUCT.equalsIgnoreCase(productName) || MARIADB_PRODUCT.equalsIgnoreCase(productName);
    }

    public static boolean isOracleConnection(String productName) {
        return productName.toUpperCase().contains(ORACLE_PRODUCT);
    }

    private MigrationUtils() {
        throw new UnsupportedOperationException("static class cannot be instantiated");
    }

    public static enum DatabaseType {
        Mysql,
        Oracle,
        Unsupported;

    }
}

