/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class DisapproveAction
extends ActionTakenEvent {
    private static final Logger LOG = LogManager.getLogger(DisapproveAction.class);

    public DisapproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal) {
        super("D", rh, principal);
    }

    public DisapproveAction(DocumentRouteHeaderValue rh, PrincipalContract principal, String annotation) {
        super("D", rh, principal, annotation);
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be disapproved";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "C");
        if (!this.isActionCompatibleRequest((List)filteredActionRequests)) {
            return "No request for the user is compatible with the DISAPPROVE or DENY action";
        }
        return "";
    }

    public boolean isActionCompatibleRequest(List requests) {
        if (this.routeHeader.isStateInitiated() || this.routeHeader.isStateSaved()) {
            return true;
        }
        boolean actionCompatible = false;
        Iterator ars = requests.iterator();
        ActionRequestValue actionRequest = null;
        while (ars.hasNext()) {
            actionRequest = (ActionRequestValue)ars.next();
            String request = actionRequest.getActionRequested();
            if (!"A".equals(request) && !"C".equals(request)) continue;
            actionCompatible = true;
            break;
        }
        return actionCompatible;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        LOG.debug("Disapproving document : " + this.annotation);
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        LOG.debug("Checking to see if the action is legal");
        String errorMessage = this.validateActionRules(actionRequests);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        LOG.debug("Record the disapproval action");
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        LOG.debug("Deactivate all pending action requests");
        actionRequests = this.getActionRequestService().findPendingByDoc(this.getDocumentId());
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        if (!DisapproveAction.isPolicySet(this.getRouteHeader().getDocumentType(), DocumentTypePolicy.SUPPRESS_ACKNOWLEDGEMENTS_ON_DISAPPROVE)) {
            LOG.debug("Sending Acknowledgements to all previous approvers/completers");
            RouteNodeInstance notificationNodeInstance = null;
            notificationNodeInstance = actionRequests.get(0).getNodeInstance();
            this.generateAcknowledgementsToPreviousActionTakers(notificationNodeInstance);
        }
        LOG.debug("Disapproving document");
        try {
            String oldStatus = this.getRouteHeader().getDocRouteStatus();
            this.routeHeader.markDocumentDisapproved();
            String newStatus = this.getRouteHeader().getDocRouteStatus();
            DocumentRouteHeaderValue routeHeaderValue = KEWServiceLocator.getRouteHeaderService().saveRouteHeader(this.routeHeader);
            this.setRouteHeader(routeHeaderValue);
            this.notifyStatusChange(newStatus, oldStatus);
        }
        catch (WorkflowException ex) {
            LOG.warn((Object)ex, (Throwable)ex);
            throw new InvalidActionTakenException(ex.getMessage(), (Throwable)ex);
        }
    }
}

