/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public class FootnoteBodyLayoutManager
extends BlockStackingLayoutManager {
    private List<ListElement> knuthElements;

    public FootnoteBodyLayoutManager(FootnoteBody body) {
        super(body);
    }

    @Override
    public List getNextKnuthElements(LayoutContext context, int alignment) {
        if (this.knuthElements == null) {
            this.knuthElements = super.getNextKnuthElements(context, alignment);
        }
        return this.knuthElements;
    }

    @Override
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        LayoutManager childLM;
        LayoutManager lastLM = null;
        LayoutContext lc = LayoutContext.newInstance();
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position innerPosition;
            Position pos = parentIter.next();
            if (!(pos instanceof NonLeafPosition) || (innerPosition = pos.getPosition()).getLM() == this) continue;
            positionList.add(innerPosition);
            lastLM = innerPosition.getLM();
        }
        PositionIterator childPosIter = new PositionIterator(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(8, layoutContext.isLastArea() && childLM == lastLM);
            childLM.setFromFootnote(true);
            childLM.addAreas(childPosIter, lc);
        }
    }

    @Override
    public void addChildArea(Area childArea) {
        childArea.setAreaClass(4);
        childArea.setFromFootnote(true);
        this.parentLayoutManager.addChildArea(childArea);
    }

    protected FootnoteBody getFootnodeBodyFO() {
        return (FootnoteBody)this.fobj;
    }

    @Override
    public Keep getKeepTogether() {
        return this.getParentKeepTogether();
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public void reset() {
        super.reset();
        this.knuthElements = null;
    }
}

