/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SafeXmlUtils {
    private static final Logger LOG = LogManager.getLogger(SafeXmlUtils.class);
    public static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    public static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    public static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    public static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private SafeXmlUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static DocumentBuilderFactory safeDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature(DISALLOW_DOCTYPE_DECL, true);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        try {
            dbf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        try {
            dbf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        try {
            dbf.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        return dbf;
    }

    public static TransformerFactory safeTransformerFactory() {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return tf;
    }

    public static SAXBuilder safeSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setFeature(DISALLOW_DOCTYPE_DECL, true);
        builder.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        builder.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        return builder;
    }

    public static SAXParserFactory safeSAXParserFactory() throws SAXNotSupportedException, SAXNotRecognizedException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        spf.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        spf.setFeature(LOAD_EXTERNAL_DTD, false);
        return spf;
    }

    public static Validator safeValidator(Schema schema) throws SAXNotRecognizedException, SAXNotSupportedException {
        Validator validator = schema.newValidator();
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return validator;
    }

    public static SchemaFactory safeSchemaFactory() throws SAXNotRecognizedException, SAXNotSupportedException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory;
    }
}

