/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.data.metadata.impl;

import com.google.common.annotations.Beta;
import java.beans.PropertyEditor;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.data.metadata.DataObjectAttribute;
import org.kuali.rice.krad.data.metadata.impl.DataObjectAttributeInternal;
import org.kuali.rice.krad.data.metadata.impl.MetadataCommonBase;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public class DataObjectAttributeImpl
extends MetadataCommonBase
implements DataObjectAttributeInternal {
    private static final long serialVersionUID = -5241499559388935579L;
    private static final Logger LOG = LogManager.getLogger(DataObjectAttributeImpl.class);
    protected DataObjectAttribute embeddedAttribute;
    protected Class<?> owningType;
    protected Class<?> inheritedFromType;
    protected String inheritedFromAttributeName;
    protected String inheritedFromParentAttributeName;
    protected String displayAttributeName;
    protected Boolean caseInsensitive;
    protected Boolean forceUppercase;
    protected Boolean required;
    protected Boolean persisted;
    protected Boolean sensitive;
    protected Long maxLength;
    protected Long minLength;
    protected String validCharactersConstraintBeanName;
    protected PropertyEditor propertyEditor;
    protected KeyValuesFinder validValues;
    protected DataType dataType;
    protected Class<?> type;

    @Override
    public String getDisplayAttributeName() {
        if (this.displayAttributeName != null) {
            return this.displayAttributeName;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getDisplayAttributeName();
        }
        return this.getName();
    }

    public void setDisplayAttributeName(String displayAttributeName) {
        if (StringUtils.isBlank((String)displayAttributeName)) {
            displayAttributeName = null;
        }
        this.displayAttributeName = displayAttributeName;
    }

    @Override
    public boolean isCaseInsensitive() {
        if (this.caseInsensitive != null) {
            return this.caseInsensitive;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.isCaseInsensitive();
        }
        return false;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public boolean isForceUppercase() {
        if (this.forceUppercase != null) {
            return this.forceUppercase;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.isForceUppercase();
        }
        return false;
    }

    public void setForceUppercase(boolean forceUppercase) {
        this.forceUppercase = forceUppercase;
    }

    @Override
    public PropertyEditor getPropertyEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getPropertyEditor();
        }
        return null;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
    }

    @Override
    public KeyValuesFinder getValidValues() {
        if (this.validValues != null) {
            return this.validValues;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getValidValues();
        }
        return null;
    }

    public void setValidValues(KeyValuesFinder validValues) {
        this.validValues = validValues;
    }

    @Override
    public DataType getDataType() {
        if (this.dataType != null) {
            return this.dataType;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getDataType();
        }
        return DataType.STRING;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataObjectAttribute [");
        builder.append("name=").append(this.name);
        if (this.label != null) {
            builder.append(", ").append("label=").append(this.label);
        }
        if (this.backingObjectName != null) {
            builder.append(", ").append("backingObjectName=").append(this.backingObjectName);
        }
        if (this.dataType != null) {
            builder.append(", ").append("dataType=").append(this.dataType);
        }
        if (this.type != null) {
            builder.append(", ").append("type=").append(this.type.getName());
        }
        if (this.caseInsensitive != null) {
            builder.append(", ").append("caseInsensitive=").append(this.caseInsensitive);
        }
        if (this.propertyEditor != null) {
            builder.append(", ").append("propertyEditor=").append(this.propertyEditor);
        }
        if (this.sensitive != null && this.sensitive.booleanValue()) {
            builder.append(", ").append("sensitive=").append(this.sensitive);
        }
        if (this.validValues != null) {
            builder.append(", ").append("validValues=").append(this.validValues);
        }
        if (this.inheritedFromType != null) {
            builder.append(", ").append("inheritedFromType=").append(this.inheritedFromType);
        }
        if (this.inheritedFromAttributeName != null) {
            builder.append(", ").append("inheritedFromAttributeName=").append(this.inheritedFromAttributeName);
        }
        builder.append(", ").append("mergeAction=").append((Object)this.mergeAction);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Long getMaxLength() {
        if (this.maxLength != null) {
            return this.maxLength;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getMaxLength();
        }
        return null;
    }

    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public DataObjectAttribute getEmbeddedAttribute() {
        return this.embeddedAttribute;
    }

    @Override
    public void setEmbeddedAttribute(DataObjectAttribute embeddedAttribute) {
        if (embeddedAttribute == this) {
            LOG.warn("ERROR!!!!  Attempt to embed a DataObjectAttribute into itself.  You must really want a stack overflow!  Trace: ", new Throwable("Throw-away Throwable for tracing purposes."));
            return;
        }
        this.embeddedAttribute = embeddedAttribute;
        this.setEmbeddedCommonMetadata(embeddedAttribute);
    }

    @Override
    public boolean isRequired() {
        if (this.required != null) {
            return this.required;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.isRequired();
        }
        return false;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    @Beta
    public String getValidCharactersConstraintBeanName() {
        if (this.validCharactersConstraintBeanName != null) {
            return this.validCharactersConstraintBeanName;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getValidCharactersConstraintBeanName();
        }
        return this.validCharactersConstraintBeanName;
    }

    @Beta
    public void setValidCharactersConstraintBeanName(String validCharactersConstraintBeanName) {
        this.validCharactersConstraintBeanName = validCharactersConstraintBeanName;
    }

    @Override
    public Class<?> getOwningType() {
        if (this.owningType != null) {
            return this.owningType;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getOwningType();
        }
        return null;
    }

    public void setOwningType(Class<?> owningType) {
        this.owningType = owningType;
    }

    @Override
    public boolean isPersisted() {
        if (this.persisted != null) {
            return this.persisted;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.isPersisted();
        }
        return true;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Class<?> getType() {
        if (this.type != null) {
            return this.type;
        }
        return String.class;
    }

    public void setType(Class<?> javaType) {
        this.type = javaType;
    }

    @Override
    public Class<?> getInheritedFromType() {
        if (this.inheritedFromType != null) {
            return this.inheritedFromType;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getInheritedFromType();
        }
        return null;
    }

    public void setInheritedFromType(Class<?> inheritedFromType) {
        this.inheritedFromType = inheritedFromType;
    }

    @Override
    public String getInheritedFromAttributeName() {
        if (this.inheritedFromAttributeName != null) {
            return this.inheritedFromAttributeName;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getInheritedFromAttributeName();
        }
        return null;
    }

    public void setInheritedFromAttributeName(String inheritedFromAttributeName) {
        this.inheritedFromAttributeName = inheritedFromAttributeName;
    }

    @Override
    public String getInheritedFromParentAttributeName() {
        if (this.inheritedFromParentAttributeName != null) {
            return this.inheritedFromParentAttributeName;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getInheritedFromParentAttributeName();
        }
        return null;
    }

    public void setInheritedFromParentAttributeName(String inheritedFromParentAttributeName) {
        this.inheritedFromParentAttributeName = inheritedFromParentAttributeName;
    }

    @Override
    public boolean isInherited() {
        return this.getInheritedFromAttributeName() != null;
    }

    @Override
    public DataObjectAttribute getOriginalDataObjectAttribute() {
        if (this.embeddedAttribute == null) {
            return this;
        }
        return this.embeddedAttribute.getOriginalDataObjectAttribute();
    }

    @Override
    public Long getMinLength() {
        if (this.minLength != null) {
            return this.minLength;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.getMinLength();
        }
        return null;
    }

    public void setMinLength(Long minLength) {
        this.minLength = minLength;
    }

    @Override
    public boolean isSensitive() {
        if (this.sensitive != null) {
            return this.sensitive;
        }
        if (this.embeddedAttribute != null) {
            return this.embeddedAttribute.isSensitive();
        }
        return false;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }
}

