/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.Arrays;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.List;

public final class DestructiveOperations {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DestructiveOperations.class);
    public static final Setting<Boolean> REQUIRES_NAME_SETTING = Setting.boolSetting("action.destructive_requires_name", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    static final String DESTRUCTIVE_REQUIRES_NAME_DEPRECATION_WARNING = "setting [action.destructive_requires_name] will default to true in 8.0, set explicitly to false to preserve current behavior";
    private static final String[] MATCH_NONE_PATTERN = new String[]{"*", "-*"};
    private volatile boolean destructiveRequiresName;
    private volatile boolean isDestructiveRequiresNameSet;

    public DestructiveOperations(Settings settings, ClusterSettings clusterSettings) {
        this.destructiveRequiresName = REQUIRES_NAME_SETTING.get(settings);
        this.isDestructiveRequiresNameSet = REQUIRES_NAME_SETTING.exists(settings);
        clusterSettings.addSettingsUpdateConsumer(this::setDestructiveRequiresName, List.of(REQUIRES_NAME_SETTING));
    }

    private void setDestructiveRequiresName(Settings settings) {
        this.isDestructiveRequiresNameSet = REQUIRES_NAME_SETTING.exists(settings);
        this.destructiveRequiresName = REQUIRES_NAME_SETTING.get(settings);
    }

    public void failDestructive(String[] aliasesOrIndices) {
        if (this.isDestructiveRequiresNameSet && !this.destructiveRequiresName) {
            return;
        }
        if (aliasesOrIndices == null || aliasesOrIndices.length == 0) {
            this.checkWildCardOK();
        } else if (aliasesOrIndices.length == 1) {
            if (DestructiveOperations.hasWildcardUsage(aliasesOrIndices[0])) {
                this.checkWildCardOK();
            }
        } else if (!Arrays.equals(aliasesOrIndices, MATCH_NONE_PATTERN)) {
            for (String aliasesOrIndex : aliasesOrIndices) {
                if (!DestructiveOperations.hasWildcardUsage(aliasesOrIndex)) continue;
                this.checkWildCardOK();
            }
        }
    }

    private void checkWildCardOK() {
        if (!this.isDestructiveRequiresNameSet) {
            deprecationLogger.critical(DeprecationCategory.SETTINGS, "destructive_requires_name_default", DESTRUCTIVE_REQUIRES_NAME_DEPRECATION_WARNING, new Object[0]);
        }
        if (this.destructiveRequiresName) {
            throw new IllegalArgumentException("Wildcard expressions or all indices are not allowed");
        }
    }

    private static boolean hasWildcardUsage(String aliasOrIndex) {
        return "_all".equals(aliasOrIndex) || aliasOrIndex.indexOf(42) != -1;
    }
}

