/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.lifecycle;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.uif.lifecycle.LifecycleElementState;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTask;
import org.kuali.rice.krad.uif.util.ProcessLogger;

public abstract class ViewLifecycleTaskBase<T>
implements ViewLifecycleTask<T> {
    private final Logger LOG = LogManager.getLogger(ViewLifecycleTaskBase.class);
    private final Class<T> elementType;
    private LifecycleElementState elementState;

    protected ViewLifecycleTaskBase(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public final void run() {
        try {
            if (!this.getElementType().isInstance(this.elementState.getElement())) {
                return;
            }
            if (ProcessLogger.isTraceActive()) {
                ProcessLogger.countBegin("lc-task-" + this.elementState.getViewPhase());
            }
            try {
                this.performLifecycleTask();
            }
            finally {
                if (ProcessLogger.isTraceActive()) {
                    ProcessLogger.countEnd("lc-task-" + this.elementState.getViewPhase(), this.getClass().getName() + " " + this.elementState.getClass().getName() + " " + this.elementState.getElement().getClass().getName() + " " + this.elementState.getElement().getId());
                }
            }
        }
        catch (Throwable t) {
            this.LOG.warn("Error in lifecycle phase " + String.valueOf(this), t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException("Unexpected error in lifecycle phase " + String.valueOf(this), t);
        }
    }

    protected abstract void performLifecycleTask();

    @Override
    public LifecycleElementState getElementState() {
        return this.elementState;
    }

    @Override
    public void setElementState(LifecycleElementState elementState) {
        this.elementState = elementState;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getElementState().getElement().getClass().getSimpleName() + " " + this.getElementState().getElement().getId();
    }
}

