/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.Row;

public class RowIterator {
    private static Log log = LogFactory.getLog((Class)RowIterator.class);
    private Iterator iterator;
    private int rowNumber;
    private TableDecorator decorator;
    private String id;
    private int pageOffset;

    protected RowIterator(List rowList, List columnList, TableDecorator tableDecorator, int offset) {
        this.iterator = rowList.iterator();
        this.rowNumber = 0;
        this.decorator = tableDecorator;
        this.pageOffset = offset;
    }

    public void setId(String tableId) {
        this.id = tableId;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public Row next() {
        int currentRowNumber = this.rowNumber++;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.id + "] rowIterator.next() row number=" + currentRowNumber));
        }
        Object object = this.iterator.next();
        Row row = (Row)object;
        row.setRowNumber(currentRowNumber);
        if (this.decorator != null) {
            this.decorator.initRow(row.getObject(), currentRowNumber, currentRowNumber + this.getPageOffset());
        }
        return row;
    }
}

