/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ErrorMessage
implements Serializable {
    private static final long serialVersionUID = 4397449554212875250L;
    private String namespaceCode;
    private String componentCode;
    private String errorKey;
    private String[] messageParameters;
    private String messagePrefixKey;
    private String[] messagePrefixParameters;
    private String messageSuffixKey;
    private String[] messageSuffixParameters;

    public ErrorMessage() {
    }

    public ErrorMessage(String errorKey, String ... messageParameters) {
        if (StringUtils.isBlank((String)errorKey)) {
            StringBuilder builder = null;
            if (messageParameters != null && messageParameters.length > 0) {
                builder = new StringBuilder("  Message parameters are: ");
                for (String param : messageParameters) {
                    builder.append(param).append("\n");
                }
            } else {
                builder = new StringBuilder("  Message parameters were null or empty.");
            }
            throw new IllegalArgumentException("invalid (blank) errorKey." + builder.toString());
        }
        this.setErrorKey(errorKey);
        this.setMessageParameters((String[])ArrayUtils.clone((Object[])messageParameters));
    }

    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    public void setNamespaceCode(String namespaceCode) {
        this.namespaceCode = namespaceCode;
    }

    public String getComponentCode() {
        return this.componentCode;
    }

    public void setComponentCode(String componentCode) {
        this.componentCode = componentCode;
    }

    public void setErrorKey(String errorKey) {
        if (StringUtils.isBlank((String)errorKey)) {
            throw new IllegalArgumentException("invalid (blank) errorKey");
        }
        this.errorKey = errorKey;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public void setMessageParameters(String[] messageParameters) {
        this.messageParameters = messageParameters;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.getErrorKey());
        String[] params = this.getMessageParameters();
        if (params != null) {
            s.append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    s.append(", ");
                }
                s.append(params[i]);
            }
            s.append(")");
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (this == obj) {
            equals = true;
        } else if (obj instanceof ErrorMessage) {
            ErrorMessage other = (ErrorMessage)obj;
            if (StringUtils.equals((String)this.getErrorKey(), (String)other.getErrorKey())) {
                equals = Arrays.equals(this.getMessageParameters(), other.getMessageParameters());
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = 5011966;
        if (this.getErrorKey() != null) {
            hashCode = this.getErrorKey().hashCode();
        }
        return hashCode;
    }

    public String getMessagePrefixKey() {
        return this.messagePrefixKey;
    }

    public void setMessagePrefixKey(String messagePrefixKey) {
        this.messagePrefixKey = messagePrefixKey;
    }

    public String getMessageSuffixKey() {
        return this.messageSuffixKey;
    }

    public void setMessageSuffixKey(String messageSuffixKey) {
        this.messageSuffixKey = messageSuffixKey;
    }

    public String[] getMessagePrefixParameters() {
        return this.messagePrefixParameters;
    }

    public void setMessagePrefixParameters(String[] messagePrefixParameters) {
        this.messagePrefixParameters = messagePrefixParameters;
    }

    public String[] getMessageSuffixParameters() {
        return this.messageSuffixParameters;
    }

    public void setMessageSuffixParameters(String[] messageSuffixParameters) {
        this.messageSuffixParameters = messageSuffixParameters;
    }
}

