/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.custom.CustomDataHelperBase;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.sys.framework.util.CollectionUtils;

public class FilteredViewCustomDataFormHelper<T extends DocumentCustomData>
extends CustomDataHelperBase<T> {
    private final CustomDataHelperBase<T> customDataHelperBase;
    private final Supplier<Set<Long>> customAttributeIdSupplier;

    public FilteredViewCustomDataFormHelper(CustomDataHelperBase<T> customDataHelperBase, Supplier<Set<Long>> customAttributeIdSupplier) {
        this.customDataHelperBase = customDataHelperBase;
        this.customAttributeIdSupplier = customAttributeIdSupplier;
    }

    @Override
    protected T getNewCustomData() {
        return this.customDataHelperBase.getNewCustomData();
    }

    @Override
    public boolean shouldUpdateCustomDataDocuments() {
        return false;
    }

    @Override
    public List<T> getCustomDataList() {
        Set<Long> ids = this.customAttributeIdSupplier.get();
        return Optional.ofNullable(this.customDataHelperBase.getCustomDataList()).orElseGet(ArrayList::new).stream().filter(e -> ids.isEmpty() || ids.contains(e.getCustomAttributeId())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
        Set<Long> ids = this.customAttributeIdSupplier.get();
        return Optional.ofNullable(this.customDataHelperBase.getCustomAttributeDocuments()).orElseGet(HashMap::new).entrySet().stream().filter(e -> ids.isEmpty() || ids.contains(((CustomAttributeDocument)e.getValue()).getCustomAttribute().getId())).collect(CollectionUtils.nullSafeEntriesToMap());
    }
}

