/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.keyvalue.KeyValueComparator;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.shipment.web.struts.form.ExconIntlShipmentAjaxForm;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kns.web.struts.action.KualiDocumentActionBase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class ExconIntlShipmentAjaxAction
extends KualiDocumentActionBase {
    private transient IdentityService identityService;
    private transient DataObjectService dataObjectService;
    private transient UnitService unitService;
    private static final String LAST_NAME = "lastName";
    private static final String FIRST_NAME = "firstName";
    private static final String MIDDLE_NAME = "middleName";

    private IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KcServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    public ActionForward findPersons(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QueryByCriteria qbc;
        ExconIntlShipmentAjaxForm ajaxForm = (ExconIntlShipmentAjaxForm)form;
        String partialName = ajaxForm.getCode();
        if (partialName.contains(",")) {
            partialName = partialName.substring(0, partialName.indexOf(","));
            QueryByCriteria.Builder.create().setOrderByAscending(new String[]{"names.lastName", "names.firstName", "names.middleName"});
            qbc = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.equalIgnoreCase((String)"names.lastName", (CharSequence)partialName)});
        } else {
            QueryByCriteria.Builder.create().setOrderByAscending(new String[]{"names.lastName", "names.firstName", "names.middleName"});
            qbc = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{PredicateFactory.likeIgnoreCase((String)"names.lastName", (CharSequence)(partialName + "%"))});
        }
        List entities = this.getIdentityService().findEntities(qbc).getResults();
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        for (Entity entity : entities) {
            for (Principal principal : entity.getPrincipals()) {
                if (!principal.isActive()) continue;
                ConcreteKeyValue pair = new ConcreteKeyValue();
                pair.setKey(principal.getPrincipalId());
                pair.setValue(entity.getDefaultName().getCompositeNameUnmasked());
                result.add((KeyValue)pair);
            }
        }
        Collections.sort(result, KeyValueComparator.getInstance());
        ajaxForm.setReturnVal(this.getJSONforKeyVals(result));
        return mapping.findForward("basic");
    }

    public ActionForward findPersonsKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconIntlShipmentAjaxForm ajaxForm = (ExconIntlShipmentAjaxForm)form;
        String personId = ajaxForm.getCode();
        Entity entity = this.getIdentityService().getEntityByPrincipalId(personId);
        String searchKey = entity.getDefaultName().getCompositeNameUnmasked().substring(0, 3);
        ajaxForm.setReturnVal(this.getJSONforSearchKey(searchKey));
        return mapping.findForward("basic");
    }

    public ActionForward findUnits(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconIntlShipmentAjaxForm ajaxForm = (ExconIntlShipmentAjaxForm)form;
        String partialName = ajaxForm.getCode().toUpperCase();
        Collection<Unit> units = this.getUnitService().getUnits();
        List<KeyValue> result = units.stream().filter(unit -> unit.isActive() && (unit.getUnitName().toUpperCase().contains(partialName) || unit.getUnitNumber().toUpperCase().contains(partialName))).map(unit -> {
            ConcreteKeyValue pair = new ConcreteKeyValue();
            pair.setKey(unit.getUnitNumber());
            pair.setValue(unit.getUnitName() + " (" + unit.getUnitNumber() + ")");
            return pair;
        }).sorted(KeyValueComparator.getInstance()).collect(Collectors.toList());
        ajaxForm.setReturnVal(this.getJSONforKeyVals(result));
        return mapping.findForward("basic");
    }

    public ActionForward findUnitsKey(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExconIntlShipmentAjaxForm ajaxForm = (ExconIntlShipmentAjaxForm)form;
        String unitNumber = ajaxForm.getCode();
        Unit unit = this.getUnitService().getUnit(unitNumber);
        String searchKey = unit.getUnitName().substring(0, 3);
        ajaxForm.setReturnVal(this.getJSONforSearchKey(searchKey));
        return mapping.findForward("basic");
    }

    protected String getJSONforSearchKey(String searchKey) {
        return "{\"searchKey\" : \"" + searchKey + "\"}";
    }

    protected String getJSONforKeyVals(List<KeyValue> result) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        int index = 0;
        for (KeyValue kv : result) {
            if (index > 0) {
                builder.append(" , ");
            }
            builder.append("{ \"label\" :\"");
            builder.append(kv.getValue());
            builder.append("\", \"value\" : \"");
            builder.append(kv.getKey());
            builder.append("\"}");
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    protected DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }
}

